package io.gorules.zen_engine;


import com.sun.jna.Structure;
import com.sun.jna.Pointer;

@Structure.FieldOrder({ "handle", "uniffiFree" })
public class UniffiVTableCallbackInterfaceZenCustomNodeCallback extends Structure {
    public UniffiCallbackInterfaceZenCustomNodeCallbackMethod0 handle = null;
    public UniffiCallbackInterfaceFree uniffiFree = null;

    // no-arg constructor required so JNA can instantiate and reflect
    public UniffiVTableCallbackInterfaceZenCustomNodeCallback() {
        super();
    }
    
    public UniffiVTableCallbackInterfaceZenCustomNodeCallback(
        UniffiCallbackInterfaceZenCustomNodeCallbackMethod0 handle,
        UniffiCallbackInterfaceFree uniffiFree
    ) {
        this.handle = handle;
        this.uniffiFree = uniffiFree;
    }

    public static class UniffiByValue extends UniffiVTableCallbackInterfaceZenCustomNodeCallback implements Structure.ByValue {
        public UniffiByValue(
            UniffiCallbackInterfaceZenCustomNodeCallbackMethod0 handle,
            UniffiCallbackInterfaceFree uniffiFree
        ) {
            super(handle,        
            uniffiFree        
            );
        }
    }

    void uniffiSetValue(UniffiVTableCallbackInterfaceZenCustomNodeCallback other) {
        handle = other.handle;
        uniffiFree = other.uniffiFree;
    }

}
