package io.gorules.zen_engine;


import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Callable;
import java.util.function.Function;
import java.util.function.Consumer;
import java.util.function.Supplier;
import java.util.List;
import com.sun.jna.*;
import com.sun.jna.ptr.*;

// Put the implementation in an object so we don't pollute the top-level namespace
public class UniffiCallbackInterfaceZenCustomNodeCallback {
    public static final UniffiCallbackInterfaceZenCustomNodeCallback INSTANCE = new UniffiCallbackInterfaceZenCustomNodeCallback();
    UniffiVTableCallbackInterfaceZenCustomNodeCallback.UniffiByValue vtable;
    
    UniffiCallbackInterfaceZenCustomNodeCallback() {
        vtable = new UniffiVTableCallbackInterfaceZenCustomNodeCallback.UniffiByValue(
            handle.INSTANCE,
            UniffiFree.INSTANCE
        );
    }
    
    // Registers the foreign callback with the Rust side.
    // This method is generated for each callback interface.
    void register(UniffiLib lib) {
        lib.uniffi_zen_uniffi_fn_init_callback_vtable_zencustomnodecallback(vtable);
    }
    
    public static class handle implements UniffiCallbackInterfaceZenCustomNodeCallbackMethod0 {
        public static final handle INSTANCE = new handle();
        private handle() {}

        @Override
        public void callback(long uniffiHandle,RustBuffer.ByValue key,UniffiForeignFutureCompleteRustBuffer uniffiFutureCallback,long uniffiCallbackData,UniffiForeignFuture uniffiOutReturn) {
            var uniffiObj = FfiConverterTypeZenCustomNodeCallback.INSTANCE.handleMap.get(uniffiHandle);
            Supplier<CompletableFuture<ZenEngineHandlerResponse>> makeCall = () -> {
                return uniffiObj.handle(
                    FfiConverterTypeZenEngineHandlerRequest.INSTANCE.lift(key)
                );
                
            };
            Consumer<ZenEngineHandlerResponse> uniffiHandleSuccess = (returnValue) -> {
                var uniffiResult = new UniffiForeignFutureStructRustBuffer.UniffiByValue(
                    FfiConverterTypeZenEngineHandlerResponse.INSTANCE.lower(returnValue),
                    new UniffiRustCallStatus.ByValue()
                );
                uniffiResult.write();
                uniffiFutureCallback.callback(uniffiCallbackData, uniffiResult);
            };
            Consumer<UniffiRustCallStatus.ByValue> uniffiHandleError = (callStatus) -> {
                uniffiFutureCallback.callback(
                    uniffiCallbackData,
                    new UniffiForeignFutureStructRustBuffer.UniffiByValue(
                        new RustBuffer.ByValue(),
                        callStatus
                    )
                );
            };

            uniffiOutReturn.uniffiSetValue(
                UniffiAsyncHelpers.uniffiTraitInterfaceCallAsyncWithError(
                    makeCall,
                    uniffiHandleSuccess,
                    uniffiHandleError,
                    (ZenException e) -> FfiConverterTypeZenError.INSTANCE.lower(e),
                    ZenException.class
                )
            );
        }
    }

    public static class UniffiFree implements UniffiCallbackInterfaceFree {
        public static final UniffiFree INSTANCE = new UniffiFree();

        private UniffiFree() {}

        @Override
        public void callback(long handle) {
            FfiConverterTypeZenCustomNodeCallback.INSTANCE.handleMap.remove(handle);
        }
    }
}

