package io.gorules.zen_engine;


import java.nio.ByteBuffer;

public enum FfiConverterTypeZenEngineHandlerRequest implements FfiConverterRustBuffer<ZenEngineHandlerRequest> {
  INSTANCE;

  @Override
  public ZenEngineHandlerRequest read(ByteBuffer buf) {
    return new ZenEngineHandlerRequest(
      FfiConverterTypeJsonBuffer.INSTANCE.read(buf),
      FfiConverterTypeDecisionNode.INSTANCE.read(buf)
    );
  }

  @Override
  public long allocationSize(ZenEngineHandlerRequest value) {
      return (
            FfiConverterTypeJsonBuffer.INSTANCE.allocationSize(value.input()) +
            FfiConverterTypeDecisionNode.INSTANCE.allocationSize(value.node())
      );
  }

  @Override
  public void write(ZenEngineHandlerRequest value, ByteBuffer buf) {
      FfiConverterTypeJsonBuffer.INSTANCE.write(value.input(), buf);
      FfiConverterTypeDecisionNode.INSTANCE.write(value.node(), buf);
  }
}



