package io.gorules.zen_engine;


import java.nio.ByteBuffer;

public enum FfiConverterTypeDecisionNode implements FfiConverterRustBuffer<DecisionNode> {
  INSTANCE;

  @Override
  public DecisionNode read(ByteBuffer buf) {
    return new DecisionNode(
      FfiConverterString.INSTANCE.read(buf),
      FfiConverterString.INSTANCE.read(buf),
      FfiConverterString.INSTANCE.read(buf),
      FfiConverterTypeJsonBuffer.INSTANCE.read(buf)
    );
  }

  @Override
  public long allocationSize(DecisionNode value) {
      return (
            FfiConverterString.INSTANCE.allocationSize(value.id()) +
            FfiConverterString.INSTANCE.allocationSize(value.name()) +
            FfiConverterString.INSTANCE.allocationSize(value.kind()) +
            FfiConverterTypeJsonBuffer.INSTANCE.allocationSize(value.config())
      );
  }

  @Override
  public void write(DecisionNode value, ByteBuffer buf) {
      FfiConverterString.INSTANCE.write(value.id(), buf);
      FfiConverterString.INSTANCE.write(value.name(), buf);
      FfiConverterString.INSTANCE.write(value.kind(), buf);
      FfiConverterTypeJsonBuffer.INSTANCE.write(value.config(), buf);
  }
}



