package io.gorules.zen_engine;


import com.sun.jna.Structure;
import com.sun.jna.Pointer;

@Structure.FieldOrder({ "load", "uniffiFree" })
public class UniffiVTableCallbackInterfaceZenDecisionLoaderCallback extends Structure {
    public UniffiCallbackInterfaceZenDecisionLoaderCallbackMethod0 load = null;
    public UniffiCallbackInterfaceFree uniffiFree = null;

    // no-arg constructor required so JNA can instantiate and reflect
    public UniffiVTableCallbackInterfaceZenDecisionLoaderCallback() {
        super();
    }
    
    public UniffiVTableCallbackInterfaceZenDecisionLoaderCallback(
        UniffiCallbackInterfaceZenDecisionLoaderCallbackMethod0 load,
        UniffiCallbackInterfaceFree uniffiFree
    ) {
        this.load = load;
        this.uniffiFree = uniffiFree;
    }

    public static class UniffiByValue extends UniffiVTableCallbackInterfaceZenDecisionLoaderCallback implements Structure.ByValue {
        public UniffiByValue(
            UniffiCallbackInterfaceZenDecisionLoaderCallbackMethod0 load,
            UniffiCallbackInterfaceFree uniffiFree
        ) {
            super(load,        
            uniffiFree        
            );
        }
    }

    void uniffiSetValue(UniffiVTableCallbackInterfaceZenDecisionLoaderCallback other) {
        load = other.load;
        uniffiFree = other.uniffiFree;
    }

}
































































































