package io.gorules.zen_engine;


import com.sun.jna.Library;
import com.sun.jna.Pointer;

// A JNA Library to expose the extern-C FFI definitions.
// This is an implementation detail which will be called internally by the public API.
interface UniffiLib extends Library {
    UniffiLib INSTANCE = UniffiLibInitializer.load();

    
    // The Cleaner for the whole library
    static UniffiCleaner CLEANER = UniffiCleaner.create();
    
    Pointer uniffi_zen_uniffi_fn_clone_zendecision(Pointer ptr, UniffiRustCallStatus uniffi_out_errmk);
    void uniffi_zen_uniffi_fn_free_zendecision(Pointer ptr, UniffiRustCallStatus uniffi_out_errmk);
    Long uniffi_zen_uniffi_fn_method_zendecision_evaluate(Pointer ptr, RustBuffer.ByValue context, RustBuffer.ByValue options);
    void uniffi_zen_uniffi_fn_method_zendecision_validate(Pointer ptr, UniffiRustCallStatus uniffi_out_errmk);
    Pointer uniffi_zen_uniffi_fn_clone_zenengine(Pointer ptr, UniffiRustCallStatus uniffi_out_errmk);
    void uniffi_zen_uniffi_fn_free_zenengine(Pointer ptr, UniffiRustCallStatus uniffi_out_errmk);
    Pointer uniffi_zen_uniffi_fn_constructor_zenengine_new(RustBuffer.ByValue loader, RustBuffer.ByValue customNode, UniffiRustCallStatus uniffi_out_errmk);
    Pointer uniffi_zen_uniffi_fn_method_zenengine_create_decision(Pointer ptr, RustBuffer.ByValue content, UniffiRustCallStatus uniffi_out_errmk);
    Long uniffi_zen_uniffi_fn_method_zenengine_evaluate(Pointer ptr, RustBuffer.ByValue key, RustBuffer.ByValue context, RustBuffer.ByValue options);
    Long uniffi_zen_uniffi_fn_method_zenengine_get_decision(Pointer ptr, RustBuffer.ByValue key);
    Pointer uniffi_zen_uniffi_fn_clone_zenexpression(Pointer ptr, UniffiRustCallStatus uniffi_out_errmk);
    void uniffi_zen_uniffi_fn_free_zenexpression(Pointer ptr, UniffiRustCallStatus uniffi_out_errmk);
    Pointer uniffi_zen_uniffi_fn_constructor_zenexpression_compile(RustBuffer.ByValue expression, UniffiRustCallStatus uniffi_out_errmk);
    RustBuffer.ByValue uniffi_zen_uniffi_fn_method_zenexpression_evaluate(Pointer ptr, RustBuffer.ByValue context, UniffiRustCallStatus uniffi_out_errmk);
    Pointer uniffi_zen_uniffi_fn_clone_zenexpressionunary(Pointer ptr, UniffiRustCallStatus uniffi_out_errmk);
    void uniffi_zen_uniffi_fn_free_zenexpressionunary(Pointer ptr, UniffiRustCallStatus uniffi_out_errmk);
    Pointer uniffi_zen_uniffi_fn_constructor_zenexpressionunary_compile(RustBuffer.ByValue expression, UniffiRustCallStatus uniffi_out_errmk);
    Byte uniffi_zen_uniffi_fn_method_zenexpressionunary_evaluate(Pointer ptr, RustBuffer.ByValue context, UniffiRustCallStatus uniffi_out_errmk);
    void uniffi_zen_uniffi_fn_init_callback_vtable_zencustomnodecallback(UniffiVTableCallbackInterfaceZenCustomNodeCallback vtable);
    void uniffi_zen_uniffi_fn_init_callback_vtable_zendecisionloadercallback(UniffiVTableCallbackInterfaceZenDecisionLoaderCallback vtable);
    RustBuffer.ByValue uniffi_zen_uniffi_fn_func_evaluate_expression(RustBuffer.ByValue expression, RustBuffer.ByValue context, UniffiRustCallStatus uniffi_out_errmk);
    Byte uniffi_zen_uniffi_fn_func_evaluate_unary_expression(RustBuffer.ByValue expression, RustBuffer.ByValue context, UniffiRustCallStatus uniffi_out_errmk);
    void uniffi_zen_uniffi_fn_func_override_config(RustBuffer.ByValue config, UniffiRustCallStatus uniffi_out_errmk);
    RustBuffer.ByValue ffi_zen_uniffi_rustbuffer_alloc(Long size, UniffiRustCallStatus uniffi_out_errmk);
    RustBuffer.ByValue ffi_zen_uniffi_rustbuffer_from_bytes(ForeignBytes.ByValue bytes, UniffiRustCallStatus uniffi_out_errmk);
    void ffi_zen_uniffi_rustbuffer_free(RustBuffer.ByValue buf, UniffiRustCallStatus uniffi_out_errmk);
    RustBuffer.ByValue ffi_zen_uniffi_rustbuffer_reserve(RustBuffer.ByValue buf, Long additional, UniffiRustCallStatus uniffi_out_errmk);
    void ffi_zen_uniffi_rust_future_poll_u8(Long handle, UniffiRustFutureContinuationCallback callback, Long callbackData);
    void ffi_zen_uniffi_rust_future_cancel_u8(Long handle);
    void ffi_zen_uniffi_rust_future_free_u8(Long handle);
    Byte ffi_zen_uniffi_rust_future_complete_u8(Long handle, UniffiRustCallStatus uniffi_out_errmk);
    void ffi_zen_uniffi_rust_future_poll_i8(Long handle, UniffiRustFutureContinuationCallback callback, Long callbackData);
    void ffi_zen_uniffi_rust_future_cancel_i8(Long handle);
    void ffi_zen_uniffi_rust_future_free_i8(Long handle);
    Byte ffi_zen_uniffi_rust_future_complete_i8(Long handle, UniffiRustCallStatus uniffi_out_errmk);
    void ffi_zen_uniffi_rust_future_poll_u16(Long handle, UniffiRustFutureContinuationCallback callback, Long callbackData);
    void ffi_zen_uniffi_rust_future_cancel_u16(Long handle);
    void ffi_zen_uniffi_rust_future_free_u16(Long handle);
    Short ffi_zen_uniffi_rust_future_complete_u16(Long handle, UniffiRustCallStatus uniffi_out_errmk);
    void ffi_zen_uniffi_rust_future_poll_i16(Long handle, UniffiRustFutureContinuationCallback callback, Long callbackData);
    void ffi_zen_uniffi_rust_future_cancel_i16(Long handle);
    void ffi_zen_uniffi_rust_future_free_i16(Long handle);
    Short ffi_zen_uniffi_rust_future_complete_i16(Long handle, UniffiRustCallStatus uniffi_out_errmk);
    void ffi_zen_uniffi_rust_future_poll_u32(Long handle, UniffiRustFutureContinuationCallback callback, Long callbackData);
    void ffi_zen_uniffi_rust_future_cancel_u32(Long handle);
    void ffi_zen_uniffi_rust_future_free_u32(Long handle);
    Integer ffi_zen_uniffi_rust_future_complete_u32(Long handle, UniffiRustCallStatus uniffi_out_errmk);
    void ffi_zen_uniffi_rust_future_poll_i32(Long handle, UniffiRustFutureContinuationCallback callback, Long callbackData);
    void ffi_zen_uniffi_rust_future_cancel_i32(Long handle);
    void ffi_zen_uniffi_rust_future_free_i32(Long handle);
    Integer ffi_zen_uniffi_rust_future_complete_i32(Long handle, UniffiRustCallStatus uniffi_out_errmk);
    void ffi_zen_uniffi_rust_future_poll_u64(Long handle, UniffiRustFutureContinuationCallback callback, Long callbackData);
    void ffi_zen_uniffi_rust_future_cancel_u64(Long handle);
    void ffi_zen_uniffi_rust_future_free_u64(Long handle);
    Long ffi_zen_uniffi_rust_future_complete_u64(Long handle, UniffiRustCallStatus uniffi_out_errmk);
    void ffi_zen_uniffi_rust_future_poll_i64(Long handle, UniffiRustFutureContinuationCallback callback, Long callbackData);
    void ffi_zen_uniffi_rust_future_cancel_i64(Long handle);
    void ffi_zen_uniffi_rust_future_free_i64(Long handle);
    Long ffi_zen_uniffi_rust_future_complete_i64(Long handle, UniffiRustCallStatus uniffi_out_errmk);
    void ffi_zen_uniffi_rust_future_poll_f32(Long handle, UniffiRustFutureContinuationCallback callback, Long callbackData);
    void ffi_zen_uniffi_rust_future_cancel_f32(Long handle);
    void ffi_zen_uniffi_rust_future_free_f32(Long handle);
    Float ffi_zen_uniffi_rust_future_complete_f32(Long handle, UniffiRustCallStatus uniffi_out_errmk);
    void ffi_zen_uniffi_rust_future_poll_f64(Long handle, UniffiRustFutureContinuationCallback callback, Long callbackData);
    void ffi_zen_uniffi_rust_future_cancel_f64(Long handle);
    void ffi_zen_uniffi_rust_future_free_f64(Long handle);
    Double ffi_zen_uniffi_rust_future_complete_f64(Long handle, UniffiRustCallStatus uniffi_out_errmk);
    void ffi_zen_uniffi_rust_future_poll_pointer(Long handle, UniffiRustFutureContinuationCallback callback, Long callbackData);
    void ffi_zen_uniffi_rust_future_cancel_pointer(Long handle);
    void ffi_zen_uniffi_rust_future_free_pointer(Long handle);
    Pointer ffi_zen_uniffi_rust_future_complete_pointer(Long handle, UniffiRustCallStatus uniffi_out_errmk);
    void ffi_zen_uniffi_rust_future_poll_rust_buffer(Long handle, UniffiRustFutureContinuationCallback callback, Long callbackData);
    void ffi_zen_uniffi_rust_future_cancel_rust_buffer(Long handle);
    void ffi_zen_uniffi_rust_future_free_rust_buffer(Long handle);
    RustBuffer.ByValue ffi_zen_uniffi_rust_future_complete_rust_buffer(Long handle, UniffiRustCallStatus uniffi_out_errmk);
    void ffi_zen_uniffi_rust_future_poll_void(Long handle, UniffiRustFutureContinuationCallback callback, Long callbackData);
    void ffi_zen_uniffi_rust_future_cancel_void(Long handle);
    void ffi_zen_uniffi_rust_future_free_void(Long handle);
    void ffi_zen_uniffi_rust_future_complete_void(Long handle, UniffiRustCallStatus uniffi_out_errmk);
    Short uniffi_zen_uniffi_checksum_func_evaluate_expression();
    Short uniffi_zen_uniffi_checksum_func_evaluate_unary_expression();
    Short uniffi_zen_uniffi_checksum_func_override_config();
    Short uniffi_zen_uniffi_checksum_method_zendecision_evaluate();
    Short uniffi_zen_uniffi_checksum_method_zendecision_validate();
    Short uniffi_zen_uniffi_checksum_method_zenengine_create_decision();
    Short uniffi_zen_uniffi_checksum_method_zenengine_evaluate();
    Short uniffi_zen_uniffi_checksum_method_zenengine_get_decision();
    Short uniffi_zen_uniffi_checksum_method_zenexpression_evaluate();
    Short uniffi_zen_uniffi_checksum_method_zenexpressionunary_evaluate();
    Short uniffi_zen_uniffi_checksum_constructor_zenengine_new();
    Short uniffi_zen_uniffi_checksum_constructor_zenexpression_compile();
    Short uniffi_zen_uniffi_checksum_constructor_zenexpressionunary_compile();
    Short uniffi_zen_uniffi_checksum_method_zencustomnodecallback_handle();
    Short uniffi_zen_uniffi_checksum_method_zendecisionloadercallback_load();
    Integer ffi_zen_uniffi_uniffi_contract_version();
    
}

