package io.gorules.zen_engine;


import java.nio.ByteBuffer;

public enum FfiConverterTypeZenEvaluateOptions implements FfiConverterRustBuffer<ZenEvaluateOptions> {
  INSTANCE;

  @Override
  public ZenEvaluateOptions read(ByteBuffer buf) {
    return new ZenEvaluateOptions(
      FfiConverterOptionalByte.INSTANCE.read(buf),
      FfiConverterOptionalBoolean.INSTANCE.read(buf)
    );
  }

  @Override
  public long allocationSize(ZenEvaluateOptions value) {
      return (
            FfiConverterOptionalByte.INSTANCE.allocationSize(value.maxDepth()) +
            FfiConverterOptionalBoolean.INSTANCE.allocationSize(value.trace())
      );
  }

  @Override
  public void write(ZenEvaluateOptions value, ByteBuffer buf) {
      FfiConverterOptionalByte.INSTANCE.write(value.maxDepth(), buf);
      FfiConverterOptionalBoolean.INSTANCE.write(value.trace(), buf);
  }
}


