package io.gorules.zen_engine;


import java.nio.ByteBuffer;

public enum FfiConverterTypeZenConfig implements FfiConverterRustBuffer<ZenConfig> {
  INSTANCE;

  @Override
  public ZenConfig read(ByteBuffer buf) {
    return new ZenConfig(
      FfiConverterOptionalBoolean.INSTANCE.read(buf)
    );
  }

  @Override
  public long allocationSize(ZenConfig value) {
      return (
            FfiConverterOptionalBoolean.INSTANCE.allocationSize(value.nodesInContext())
      );
  }

  @Override
  public void write(ZenConfig value, ByteBuffer buf) {
      FfiConverterOptionalBoolean.INSTANCE.write(value.nodesInContext(), buf);
  }
}



