package io.gorules.zen_engine;


import java.nio.ByteBuffer;
import com.sun.jna.Pointer;
// FFI converter with custom code.
public enum FfiConverterTypeJsonBuffer implements FfiConverter<JsonBuffer, RustBuffer.ByValue> {
    INSTANCE;
    @Override
    public JsonBuffer lift(RustBuffer.ByValue value) {
        var builtinValue = FfiConverterByteArray.INSTANCE.lift(value);
        try{
          return new JsonBuffer(builtinValue);
        } catch(Exception e){
          throw new RuntimeException(e);
        }
    }
    @Override
    public RustBuffer.ByValue lower(JsonBuffer value) {
      try{
        var builtinValue = value.value();
        return FfiConverterByteArray.INSTANCE.lower(builtinValue);
      } catch(Exception e){
        throw new RuntimeException(e);
      }
    }
    @Override
    public JsonBuffer read(ByteBuffer buf) {
      try{
        var builtinValue = FfiConverterByteArray.INSTANCE.read(buf);
        return new JsonBuffer(builtinValue);
      } catch(Exception e){
        throw new RuntimeException(e);
      }
    }
    @Override
    public long allocationSize(JsonBuffer value) {
      try {
        var builtinValue = value.value();
        return FfiConverterByteArray.INSTANCE.allocationSize(builtinValue);
      } catch(Exception e){
        throw new RuntimeException(e);
      } 
    }
    @Override
    public void write(JsonBuffer value, ByteBuffer buf) {
      try {
        var builtinValue = value.value();
        FfiConverterByteArray.INSTANCE.write(builtinValue, buf);
      } catch(Exception e){
        throw new RuntimeException(e);
      }
    }
}

