package io.gorules.zen_engine;


import java.nio.ByteBuffer;
import java.util.List;
import java.util.Map;

// public class TestForOptionals {}
public enum FfiConverterOptionalTypeJsonBuffer implements FfiConverterRustBuffer<JsonBuffer> {
  INSTANCE;

  @Override
  public JsonBuffer read(ByteBuffer buf) {
    if (buf.get() == (byte)0) {
      return null;
    }
    return FfiConverterTypeJsonBuffer.INSTANCE.read(buf);
  }

  @Override
  public long allocationSize(JsonBuffer value) {
    if (value == null) {
      return 1L;
    } else {
      return 1L + FfiConverterTypeJsonBuffer.INSTANCE.allocationSize(value);
    }
  }

  @Override
  public void write(JsonBuffer value, ByteBuffer buf) {
    if (value == null) {
      buf.put((byte)0);
    } else {
      buf.put((byte)1);
      FfiConverterTypeJsonBuffer.INSTANCE.write(value, buf);
    }
  }
}



