package io.gorules.zen_engine;


import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Callable;
import java.util.function.Function;
import java.util.function.Consumer;
import java.util.function.Supplier;
import java.util.List;
import com.sun.jna.*;
import com.sun.jna.ptr.*;

// Put the implementation in an object so we don't pollute the top-level namespace
public class UniffiCallbackInterfaceZenDecisionLoaderCallback {
    public static final UniffiCallbackInterfaceZenDecisionLoaderCallback INSTANCE = new UniffiCallbackInterfaceZenDecisionLoaderCallback();
    UniffiVTableCallbackInterfaceZenDecisionLoaderCallback.UniffiByValue vtable;
    
    UniffiCallbackInterfaceZenDecisionLoaderCallback() {
        vtable = new UniffiVTableCallbackInterfaceZenDecisionLoaderCallback.UniffiByValue(
            load.INSTANCE,
            UniffiFree.INSTANCE
        );
    }
    
    // Registers the foreign callback with the Rust side.
    // This method is generated for each callback interface.
    void register(UniffiLib lib) {
        lib.uniffi_zen_uniffi_fn_init_callback_vtable_zendecisionloadercallback(vtable);
    }
    
    public static class load implements UniffiCallbackInterfaceZenDecisionLoaderCallbackMethod0 {
        public static final load INSTANCE = new load();
        private load() {}

        @Override
        public void callback(long uniffiHandle,RustBuffer.ByValue key,UniffiForeignFutureCompleteRustBuffer uniffiFutureCallback,long uniffiCallbackData,UniffiForeignFuture uniffiOutReturn) {
            var uniffiObj = FfiConverterTypeZenDecisionLoaderCallback.INSTANCE.handleMap.get(uniffiHandle);
            Supplier<CompletableFuture<JsonBuffer>> makeCall = () -> {
                return uniffiObj.load(
                    FfiConverterString.INSTANCE.lift(key)
                );
                
            };
            Consumer<JsonBuffer> uniffiHandleSuccess = (returnValue) -> {
                var uniffiResult = new UniffiForeignFutureStructRustBuffer.UniffiByValue(
                    FfiConverterOptionalTypeJsonBuffer.INSTANCE.lower(returnValue),
                    new UniffiRustCallStatus.ByValue()
                );
                uniffiResult.write();
                uniffiFutureCallback.callback(uniffiCallbackData, uniffiResult);
            };
            Consumer<UniffiRustCallStatus.ByValue> uniffiHandleError = (callStatus) -> {
                uniffiFutureCallback.callback(
                    uniffiCallbackData,
                    new UniffiForeignFutureStructRustBuffer.UniffiByValue(
                        new RustBuffer.ByValue(),
                        callStatus
                    )
                );
            };

            uniffiOutReturn.uniffiSetValue(
                UniffiAsyncHelpers.uniffiTraitInterfaceCallAsyncWithError(
                    makeCall,
                    uniffiHandleSuccess,
                    uniffiHandleError,
                    (ZenException e) -> FfiConverterTypeZenError.INSTANCE.lower(e),
                    ZenException.class
                )
            );
        }
    }

    public static class UniffiFree implements UniffiCallbackInterfaceFree {
        public static final UniffiFree INSTANCE = new UniffiFree();

        private UniffiFree() {}

        @Override
        public void callback(long handle) {
            FfiConverterTypeZenDecisionLoaderCallback.INSTANCE.handleMap.remove(handle);
        }
    }
}

