package io.gorules.zen_engine;


import java.nio.ByteBuffer;
import com.sun.jna.Pointer;

public enum FfiConverterTypeZenExpressionUnary implements FfiConverter<ZenExpressionUnary, Pointer> {
    INSTANCE;

    @Override
    public Pointer lower(ZenExpressionUnary value) {
        return value.uniffiClonePointer();
    }

    @Override
    public ZenExpressionUnary lift(Pointer value) {
        return new ZenExpressionUnary(value);
    }

    @Override
    public ZenExpressionUnary read(ByteBuffer buf) {
        // The Rust code always writes pointers as 8 bytes, and will
        // fail to compile if they don't fit.
        return lift(new Pointer(buf.getLong()));
    }

    @Override
    public long allocationSize(ZenExpressionUnary value) {
      return 8L;
    }

    @Override
    public void write(ZenExpressionUnary value, ByteBuffer buf) {
        // The Rust code always expects pointers written as 8 bytes,
        // and will fail to compile if they don't fit.
        buf.putLong(Pointer.nativeValue(lower(value)));
    }
}



