package io.gorules.zen_engine;


import java.nio.ByteBuffer;
import java.util.List;
import java.util.Map;

// public class TestForOptionals {}
public enum FfiConverterOptionalTypeZenEvaluateOptions implements FfiConverterRustBuffer<ZenEvaluateOptions> {
  INSTANCE;

  @Override
  public ZenEvaluateOptions read(ByteBuffer buf) {
    if (buf.get() == (byte)0) {
      return null;
    }
    return FfiConverterTypeZenEvaluateOptions.INSTANCE.read(buf);
  }

  @Override
  public long allocationSize(ZenEvaluateOptions value) {
    if (value == null) {
      return 1L;
    } else {
      return 1L + FfiConverterTypeZenEvaluateOptions.INSTANCE.allocationSize(value);
    }
  }

  @Override
  public void write(ZenEvaluateOptions value, ByteBuffer buf) {
    if (value == null) {
      buf.put((byte)0);
    } else {
      buf.put((byte)1);
      FfiConverterTypeZenEvaluateOptions.INSTANCE.write(value, buf);
    }
  }
}



