package io.gorules.zen_engine;


import java.nio.ByteBuffer;
import java.util.List;
import java.util.Map;

// public class TestForOptionals {}
public enum FfiConverterOptionalTypeZenCustomNodeCallback implements FfiConverterRustBuffer<ZenCustomNodeCallback> {
  INSTANCE;

  @Override
  public ZenCustomNodeCallback read(ByteBuffer buf) {
    if (buf.get() == (byte)0) {
      return null;
    }
    return FfiConverterTypeZenCustomNodeCallback.INSTANCE.read(buf);
  }

  @Override
  public long allocationSize(ZenCustomNodeCallback value) {
    if (value == null) {
      return 1L;
    } else {
      return 1L + FfiConverterTypeZenCustomNodeCallback.INSTANCE.allocationSize(value);
    }
  }

  @Override
  public void write(ZenCustomNodeCallback value, ByteBuffer buf) {
    if (value == null) {
      buf.put((byte)0);
    } else {
      buf.put((byte)1);
      FfiConverterTypeZenCustomNodeCallback.INSTANCE.write(value, buf);
    }
  }
}



