package io.gorules.zen_engine;


import java.nio.ByteBuffer;
import java.util.List;
import java.util.Map;

// public class TestForOptionals {}
public enum FfiConverterOptionalByte implements FfiConverterRustBuffer<Byte> {
  INSTANCE;

  @Override
  public Byte read(ByteBuffer buf) {
    if (buf.get() == (byte)0) {
      return null;
    }
    return FfiConverterByte.INSTANCE.read(buf);
  }

  @Override
  public long allocationSize(Byte value) {
    if (value == null) {
      return 1L;
    } else {
      return 1L + FfiConverterByte.INSTANCE.allocationSize(value);
    }
  }

  @Override
  public void write(Byte value, ByteBuffer buf) {
    if (value == null) {
      buf.put((byte)0);
    } else {
      buf.put((byte)1);
      FfiConverterByte.INSTANCE.write(value, buf);
    }
  }
}



