/*
 * Decompiled with CFR 0.152.
 */
package io.gorules.zen_engine;

import io.gorules.zen_engine.FfiConverterString;
import io.gorules.zen_engine.RustBuffer;
import io.gorules.zen_engine.UniffiForeignFuture;
import io.gorules.zen_engine.UniffiForeignFutureFree;
import io.gorules.zen_engine.UniffiHandleMap;
import io.gorules.zen_engine.UniffiHelpers;
import io.gorules.zen_engine.UniffiRustCallStatus;
import io.gorules.zen_engine.UniffiRustCallStatusErrorHandler;
import io.gorules.zen_engine.UniffiRustFutureContinuationCallback;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutionException;
import java.util.function.BiConsumer;
import java.util.function.BiFunction;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Supplier;

public final class UniffiAsyncHelpers {
    static final byte UNIFFI_RUST_FUTURE_POLL_READY = 0;
    static final byte UNIFFI_RUST_FUTURE_POLL_MAYBE_READY = 1;
    static final UniffiHandleMap<CompletableFuture<Byte>> uniffiContinuationHandleMap = new UniffiHandleMap();
    static final UniffiHandleMap<CancelableForeignFuture> uniffiForeignFutureHandleMap = new UniffiHandleMap();

    static <T, F, E extends Exception> CompletableFuture<T> uniffiRustCallAsync(long rustFuture, PollingFunction pollFunc, BiFunction<Long, UniffiRustCallStatus, F> completeFunc, Consumer<Long> freeFunc, Function<F, T> liftFunc, UniffiRustCallStatusErrorHandler<E> errorHandler) {
        UniffiFreeingFuture future = new UniffiFreeingFuture(rustFuture, freeFunc);
        CompletableFuture.runAsync(() -> {
            try {
                byte pollResult;
                while ((pollResult = UniffiAsyncHelpers.poll(rustFuture, pollFunc)) != 0) {
                }
                if (!future.isCancelled()) {
                    Object result = UniffiHelpers.uniffiRustCallWithError(errorHandler, status -> completeFunc.apply(rustFuture, (UniffiRustCallStatus)((Object)status)));
                    Object liftedResult = liftFunc.apply(result);
                    future.complete(liftedResult);
                }
            }
            catch (Exception e) {
                future.completeExceptionally(e);
            }
            finally {
                if (!future.isCancelled()) {
                    freeFunc.accept(rustFuture);
                }
            }
        });
        return future;
    }

    static <E extends Exception> CompletableFuture<Void> uniffiRustCallAsync(long rustFuture, PollingFunction pollFunc, BiConsumer<Long, UniffiRustCallStatus> completeFunc, Consumer<Long> freeFunc, Runnable liftFunc, UniffiRustCallStatusErrorHandler<E> errorHandler) {
        UniffiFreeingFuture<Void> future = new UniffiFreeingFuture<Void>(rustFuture, freeFunc);
        CompletableFuture.runAsync(() -> {
            try {
                byte pollResult;
                while ((pollResult = UniffiAsyncHelpers.poll(rustFuture, pollFunc)) != 0) {
                }
                if (!future.isCancelled()) {
                    UniffiHelpers.uniffiRustCallWithError(errorHandler, status -> completeFunc.accept(rustFuture, (UniffiRustCallStatus)((Object)status)));
                    future.complete(null);
                }
            }
            catch (Throwable e) {
                future.completeExceptionally(e);
            }
            finally {
                if (!future.isCancelled()) {
                    freeFunc.accept(rustFuture);
                }
            }
        });
        return future;
    }

    private static byte poll(long rustFuture, PollingFunction pollFunc) throws InterruptedException, ExecutionException {
        CompletableFuture pollFuture = new CompletableFuture();
        long handle2 = uniffiContinuationHandleMap.insert(pollFuture);
        pollFunc.apply(rustFuture, UniffiRustFutureContinuationCallbackImpl.INSTANCE, handle2);
        while (!pollFuture.isDone()) {
        }
        return (Byte)pollFuture.get();
    }

    static <T> UniffiForeignFuture uniffiTraitInterfaceCallAsync(Supplier<CompletableFuture<T>> makeCall, Consumer<T> handleSuccess, Consumer<UniffiRustCallStatus.ByValue> handleError) {
        CompletableFuture foreignFutureCf = makeCall.get();
        CompletableFuture<Void> ffHandler = CompletableFuture.supplyAsync(() -> {
            try {
                ((CompletableFuture)foreignFutureCf.thenAcceptAsync(handleSuccess)).get();
            }
            catch (Throwable e) {
                if (e instanceof ExecutionException) {
                    e = e.getCause();
                }
                handleError.accept(UniffiRustCallStatus.create((byte)2, FfiConverterString.INSTANCE.lower(e.toString())));
            }
            return null;
        });
        long handle2 = uniffiForeignFutureHandleMap.insert(new CancelableForeignFuture(foreignFutureCf, ffHandler));
        return new UniffiForeignFuture(handle2, UniffiForeignFutureFreeImpl.INSTANCE);
    }

    static <T, E extends Throwable> UniffiForeignFuture uniffiTraitInterfaceCallAsyncWithError(Supplier<CompletableFuture<T>> makeCall, Consumer<T> handleSuccess, Consumer<UniffiRustCallStatus.ByValue> handleError, Function<E, RustBuffer.ByValue> lowerError, Class<E> errorClass) {
        CompletableFuture foreignFutureCf = makeCall.get();
        CompletableFuture<Void> ffHandler = CompletableFuture.supplyAsync(() -> {
            try {
                ((CompletableFuture)foreignFutureCf.thenAcceptAsync(handleSuccess)).get();
            }
            catch (Throwable e) {
                if (e instanceof ExecutionException) {
                    e = e.getCause();
                }
                if (errorClass.isInstance(e)) {
                    handleError.accept(UniffiRustCallStatus.create((byte)1, (RustBuffer.ByValue)((Object)((Object)lowerError.apply(e)))));
                }
                handleError.accept(UniffiRustCallStatus.create((byte)2, FfiConverterString.INSTANCE.lower(e.getMessage())));
            }
            return null;
        });
        long handle2 = uniffiForeignFutureHandleMap.insert(new CancelableForeignFuture(foreignFutureCf, ffHandler));
        return new UniffiForeignFuture(handle2, UniffiForeignFutureFreeImpl.INSTANCE);
    }

    public static int uniffiForeignFutureHandleCount() {
        return uniffiForeignFutureHandleMap.size();
    }

    static class UniffiFreeingFuture<T>
    extends CompletableFuture<T> {
        private Consumer<Long> freeFunc;
        private long rustFuture;

        public UniffiFreeingFuture(long rustFuture, Consumer<Long> freeFunc) {
            this.freeFunc = freeFunc;
            this.rustFuture = rustFuture;
        }

        @Override
        public boolean cancel(boolean ignored) {
            boolean cancelled = super.cancel(ignored);
            if (cancelled) {
                this.freeFunc.accept(this.rustFuture);
            }
            return cancelled;
        }
    }

    @FunctionalInterface
    static interface PollingFunction {
        public void apply(long var1, UniffiRustFutureContinuationCallback var3, long var4);
    }

    static enum UniffiRustFutureContinuationCallbackImpl implements UniffiRustFutureContinuationCallback
    {
        INSTANCE;


        @Override
        public void callback(long data, byte pollResult) {
            uniffiContinuationHandleMap.remove(data).complete(pollResult);
        }
    }

    static class CancelableForeignFuture {
        private CompletableFuture<?> childFuture;
        private CompletableFuture<Void> childFutureHandler;

        CancelableForeignFuture(CompletableFuture<?> childFuture, CompletableFuture<Void> childFutureHandler) {
            this.childFuture = childFuture;
            this.childFutureHandler = childFutureHandler;
        }

        public void cancel() {
            boolean successfullyCancelled = this.childFutureHandler.cancel(true);
            if (successfullyCancelled) {
                this.childFuture.cancel(true);
            }
        }
    }

    static enum UniffiForeignFutureFreeImpl implements UniffiForeignFutureFree
    {
        INSTANCE;


        @Override
        public void callback(long handle2) {
            CancelableForeignFuture futureWithHandler = uniffiForeignFutureHandleMap.remove(handle2);
            futureWithHandler.cancel();
        }
    }
}

