/*
 * Decompiled with CFR 0.152.
 */
package io.gorules.zen_engine;

import com.sun.jna.Pointer;
import com.sun.jna.Structure;
import io.gorules.zen_engine.UniffiHelpers;
import io.gorules.zen_engine.UniffiLib;
import io.gorules.zen_engine.UniffiRustCallStatus;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;

@Structure.FieldOrder(value={"capacity", "len", "data"})
public class RustBuffer
extends Structure {
    public long capacity;
    public long len;
    public Pointer data;

    void setValue(RustBuffer other) {
        this.capacity = other.capacity;
        this.len = other.len;
        this.data = other.data;
    }

    public static ByValue alloc(long size) {
        ByValue buffer = UniffiHelpers.uniffiRustCall(status -> UniffiLib.INSTANCE.ffi_zen_uniffi_rustbuffer_alloc(size, (UniffiRustCallStatus)((Object)status)));
        if (buffer.data == null) {
            throw new RuntimeException("RustBuffer.alloc() returned null data pointer (size=" + size + ")");
        }
        return buffer;
    }

    public static void free(ByValue buffer) {
        UniffiHelpers.uniffiRustCall(status -> {
            UniffiLib.INSTANCE.ffi_zen_uniffi_rustbuffer_free(buffer, (UniffiRustCallStatus)((Object)status));
            return null;
        });
    }

    public ByteBuffer asByteBuffer() {
        if (this.data != null) {
            ByteBuffer byteBuffer = this.data.getByteBuffer(0L, this.len);
            byteBuffer.order(ByteOrder.BIG_ENDIAN);
            return byteBuffer;
        }
        return null;
    }

    public static class ByValue
    extends RustBuffer
    implements Structure.ByValue {
    }

    public static class ByReference
    extends RustBuffer
    implements Structure.ByReference {
    }
}

