/*
 * Decompiled with CFR 0.152.
 */
package io.gorules.zen_engine;

import com.sun.jna.Library;
import com.sun.jna.Native;
import io.gorules.zen_engine.UniffiLib;

final class NamespaceLibrary {
    NamespaceLibrary() {
    }

    static synchronized String findLibraryName(String componentName) {
        String libOverride = System.getProperty("uniffi.component." + componentName + ".libraryOverride");
        if (libOverride != null) {
            return libOverride;
        }
        return "zen_uniffi";
    }

    static <Lib extends Library> Lib loadIndirect(String componentName, Class<Lib> clazz) {
        return (Lib)Native.load((String)NamespaceLibrary.findLibraryName(componentName), clazz);
    }

    static void uniffiCheckContractApiVersion(UniffiLib lib) {
        int bindingsContractVersion = 29;
        int scaffoldingContractVersion = lib.ffi_zen_uniffi_uniffi_contract_version();
        if (bindingsContractVersion != scaffoldingContractVersion) {
            throw new RuntimeException("UniFFI contract version mismatch: try cleaning and rebuilding your project");
        }
    }

    static void uniffiCheckApiChecksums(UniffiLib lib) {
        if (lib.uniffi_zen_uniffi_checksum_func_evaluate_expression() != -19424) {
            throw new RuntimeException("UniFFI API checksum mismatch: try cleaning and rebuilding your project");
        }
        if (lib.uniffi_zen_uniffi_checksum_func_evaluate_unary_expression() != 5920) {
            throw new RuntimeException("UniFFI API checksum mismatch: try cleaning and rebuilding your project");
        }
        if (lib.uniffi_zen_uniffi_checksum_func_override_config() != 10824) {
            throw new RuntimeException("UniFFI API checksum mismatch: try cleaning and rebuilding your project");
        }
        if (lib.uniffi_zen_uniffi_checksum_method_zendecision_evaluate() != -17277) {
            throw new RuntimeException("UniFFI API checksum mismatch: try cleaning and rebuilding your project");
        }
        if (lib.uniffi_zen_uniffi_checksum_method_zendecision_validate() != 18546) {
            throw new RuntimeException("UniFFI API checksum mismatch: try cleaning and rebuilding your project");
        }
        if (lib.uniffi_zen_uniffi_checksum_method_zenengine_create_decision() != -3032) {
            throw new RuntimeException("UniFFI API checksum mismatch: try cleaning and rebuilding your project");
        }
        if (lib.uniffi_zen_uniffi_checksum_method_zenengine_evaluate() != -6375) {
            throw new RuntimeException("UniFFI API checksum mismatch: try cleaning and rebuilding your project");
        }
        if (lib.uniffi_zen_uniffi_checksum_method_zenengine_get_decision() != 30326) {
            throw new RuntimeException("UniFFI API checksum mismatch: try cleaning and rebuilding your project");
        }
        if (lib.uniffi_zen_uniffi_checksum_method_zenexpression_evaluate() != -18090) {
            throw new RuntimeException("UniFFI API checksum mismatch: try cleaning and rebuilding your project");
        }
        if (lib.uniffi_zen_uniffi_checksum_method_zenexpressionunary_evaluate() != -10557) {
            throw new RuntimeException("UniFFI API checksum mismatch: try cleaning and rebuilding your project");
        }
        if (lib.uniffi_zen_uniffi_checksum_constructor_zenengine_new() != -2938) {
            throw new RuntimeException("UniFFI API checksum mismatch: try cleaning and rebuilding your project");
        }
        if (lib.uniffi_zen_uniffi_checksum_constructor_zenexpression_compile() != -28583) {
            throw new RuntimeException("UniFFI API checksum mismatch: try cleaning and rebuilding your project");
        }
        if (lib.uniffi_zen_uniffi_checksum_constructor_zenexpressionunary_compile() != 16181) {
            throw new RuntimeException("UniFFI API checksum mismatch: try cleaning and rebuilding your project");
        }
        if (lib.uniffi_zen_uniffi_checksum_method_zencustomnodecallback_handle() != -10654) {
            throw new RuntimeException("UniFFI API checksum mismatch: try cleaning and rebuilding your project");
        }
        if (lib.uniffi_zen_uniffi_checksum_method_zendecisionloadercallback_load() != -22607) {
            throw new RuntimeException("UniFFI API checksum mismatch: try cleaning and rebuilding your project");
        }
    }
}

