/*
 * Decompiled with CFR 0.152.
 */
package io.gorules.zen_engine;

import io.gorules.zen_engine.FfiConverterRustBuffer;
import io.gorules.zen_engine.FfiConverterString;
import io.gorules.zen_engine.ZenException;
import java.lang.runtime.SwitchBootstraps;
import java.nio.ByteBuffer;
import java.util.Objects;

public enum FfiConverterTypeZenError implements FfiConverterRustBuffer<ZenException>
{
    INSTANCE;


    @Override
    public ZenException read(ByteBuffer buf) {
        return switch (buf.getInt()) {
            case 1 -> new ZenException.Zero();
            case 2 -> new ZenException.InvalidArgument();
            case 3 -> new ZenException.StringNullException();
            case 4 -> new ZenException.StringUtf8Exception();
            case 5 -> new ZenException.JsonSerializationFailed();
            case 6 -> new ZenException.JsonDeserializationFailed();
            case 7 -> new ZenException.ExecutionTaskSpawnException();
            case 8 -> new ZenException.IsolateException(FfiConverterString.INSTANCE.read(buf));
            case 9 -> new ZenException.EvaluationException(FfiConverterString.INSTANCE.read(buf));
            case 10 -> new ZenException.ValidationException(FfiConverterString.INSTANCE.read(buf));
            case 11 -> new ZenException.LoaderKeyNotFound(FfiConverterString.INSTANCE.read(buf));
            case 12 -> new ZenException.LoaderInternalException(FfiConverterString.INSTANCE.read(buf), FfiConverterString.INSTANCE.read(buf));
            case 13 -> new ZenException.TemplateEngineException(FfiConverterString.INSTANCE.read(buf), FfiConverterString.INSTANCE.read(buf));
            default -> throw new RuntimeException("invalid error enum value, something is very wrong!!");
        };
    }

    @Override
    public long allocationSize(ZenException value) {
        ZenException zenException = value;
        Objects.requireNonNull(zenException);
        ZenException zenException2 = zenException;
        int n = 0;
        return switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{ZenException.Zero.class, ZenException.InvalidArgument.class, ZenException.StringNullException.class, ZenException.StringUtf8Exception.class, ZenException.JsonSerializationFailed.class, ZenException.JsonDeserializationFailed.class, ZenException.ExecutionTaskSpawnException.class, ZenException.IsolateException.class, ZenException.EvaluationException.class, ZenException.ValidationException.class, ZenException.LoaderKeyNotFound.class, ZenException.LoaderInternalException.class, ZenException.TemplateEngineException.class}, (Object)zenException2, n)) {
            case 0 -> {
                ZenException.Zero x = (ZenException.Zero)zenException2;
                yield 4L;
            }
            case 1 -> {
                ZenException.InvalidArgument x = (ZenException.InvalidArgument)zenException2;
                yield 4L;
            }
            case 2 -> {
                ZenException.StringNullException x = (ZenException.StringNullException)zenException2;
                yield 4L;
            }
            case 3 -> {
                ZenException.StringUtf8Exception x = (ZenException.StringUtf8Exception)zenException2;
                yield 4L;
            }
            case 4 -> {
                ZenException.JsonSerializationFailed x = (ZenException.JsonSerializationFailed)zenException2;
                yield 4L;
            }
            case 5 -> {
                ZenException.JsonDeserializationFailed x = (ZenException.JsonDeserializationFailed)zenException2;
                yield 4L;
            }
            case 6 -> {
                ZenException.ExecutionTaskSpawnException x = (ZenException.ExecutionTaskSpawnException)zenException2;
                yield 4L;
            }
            case 7 -> {
                ZenException.IsolateException x = (ZenException.IsolateException)zenException2;
                yield 4L + FfiConverterString.INSTANCE.allocationSize(x.v1);
            }
            case 8 -> {
                ZenException.EvaluationException x = (ZenException.EvaluationException)zenException2;
                yield 4L + FfiConverterString.INSTANCE.allocationSize(x.v1);
            }
            case 9 -> {
                ZenException.ValidationException x = (ZenException.ValidationException)zenException2;
                yield 4L + FfiConverterString.INSTANCE.allocationSize(x.v1);
            }
            case 10 -> {
                ZenException.LoaderKeyNotFound x = (ZenException.LoaderKeyNotFound)zenException2;
                yield 4L + FfiConverterString.INSTANCE.allocationSize(x.key);
            }
            case 11 -> {
                ZenException.LoaderInternalException x = (ZenException.LoaderInternalException)zenException2;
                yield 4L + FfiConverterString.INSTANCE.allocationSize(x.key) + FfiConverterString.INSTANCE.allocationSize(x.details);
            }
            case 12 -> {
                ZenException.TemplateEngineException x = (ZenException.TemplateEngineException)zenException2;
                yield 4L + FfiConverterString.INSTANCE.allocationSize(x.template) + FfiConverterString.INSTANCE.allocationSize(x.details);
            }
            default -> throw new RuntimeException("invalid error enum value, something is very wrong!!");
        };
    }

    @Override
    public void write(ZenException value, ByteBuffer buf) {
        ZenException zenException = value;
        Objects.requireNonNull(zenException);
        ZenException zenException2 = zenException;
        int n = 0;
        switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{ZenException.Zero.class, ZenException.InvalidArgument.class, ZenException.StringNullException.class, ZenException.StringUtf8Exception.class, ZenException.JsonSerializationFailed.class, ZenException.JsonDeserializationFailed.class, ZenException.ExecutionTaskSpawnException.class, ZenException.IsolateException.class, ZenException.EvaluationException.class, ZenException.ValidationException.class, ZenException.LoaderKeyNotFound.class, ZenException.LoaderInternalException.class, ZenException.TemplateEngineException.class}, (Object)zenException2, n)) {
            case 0: {
                ZenException.Zero x = (ZenException.Zero)zenException2;
                buf.putInt(1);
                break;
            }
            case 1: {
                ZenException.InvalidArgument x = (ZenException.InvalidArgument)zenException2;
                buf.putInt(2);
                break;
            }
            case 2: {
                ZenException.StringNullException x = (ZenException.StringNullException)zenException2;
                buf.putInt(3);
                break;
            }
            case 3: {
                ZenException.StringUtf8Exception x = (ZenException.StringUtf8Exception)zenException2;
                buf.putInt(4);
                break;
            }
            case 4: {
                ZenException.JsonSerializationFailed x = (ZenException.JsonSerializationFailed)zenException2;
                buf.putInt(5);
                break;
            }
            case 5: {
                ZenException.JsonDeserializationFailed x = (ZenException.JsonDeserializationFailed)zenException2;
                buf.putInt(6);
                break;
            }
            case 6: {
                ZenException.ExecutionTaskSpawnException x = (ZenException.ExecutionTaskSpawnException)zenException2;
                buf.putInt(7);
                break;
            }
            case 7: {
                ZenException.IsolateException x = (ZenException.IsolateException)zenException2;
                buf.putInt(8);
                FfiConverterString.INSTANCE.write(x.v1, buf);
                break;
            }
            case 8: {
                ZenException.EvaluationException x = (ZenException.EvaluationException)zenException2;
                buf.putInt(9);
                FfiConverterString.INSTANCE.write(x.v1, buf);
                break;
            }
            case 9: {
                ZenException.ValidationException x = (ZenException.ValidationException)zenException2;
                buf.putInt(10);
                FfiConverterString.INSTANCE.write(x.v1, buf);
                break;
            }
            case 10: {
                ZenException.LoaderKeyNotFound x = (ZenException.LoaderKeyNotFound)zenException2;
                buf.putInt(11);
                FfiConverterString.INSTANCE.write(x.key, buf);
                break;
            }
            case 11: {
                ZenException.LoaderInternalException x = (ZenException.LoaderInternalException)zenException2;
                buf.putInt(12);
                FfiConverterString.INSTANCE.write(x.key, buf);
                FfiConverterString.INSTANCE.write(x.details, buf);
                break;
            }
            case 12: {
                ZenException.TemplateEngineException x = (ZenException.TemplateEngineException)zenException2;
                buf.putInt(13);
                FfiConverterString.INSTANCE.write(x.template, buf);
                FfiConverterString.INSTANCE.write(x.details, buf);
                break;
            }
            default: {
                throw new RuntimeException("invalid error enum value, something is very wrong!!");
            }
        }
    }
}

