/*
 * Decompiled with CFR 0.152.
 */
package io.gorules.zen_engine;

import io.gorules.zen_engine.RustBuffer;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;

public interface FfiConverter<JavaType, FfiType> {
    public JavaType lift(FfiType var1);

    public FfiType lower(JavaType var1);

    public JavaType read(ByteBuffer var1);

    public long allocationSize(JavaType var1);

    public void write(JavaType var1, ByteBuffer var2);

    default public RustBuffer.ByValue lowerIntoRustBuffer(JavaType value) {
        RustBuffer.ByValue rbuf = RustBuffer.alloc(this.allocationSize(value));
        try {
            ByteBuffer bbuf = rbuf.data.getByteBuffer(0L, rbuf.capacity);
            bbuf.order(ByteOrder.BIG_ENDIAN);
            this.write(value, bbuf);
            rbuf.writeField("len", bbuf.position());
            return rbuf;
        }
        catch (Throwable e) {
            RustBuffer.free(rbuf);
            throw e;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    default public JavaType liftFromRustBuffer(RustBuffer.ByValue rbuf) {
        ByteBuffer byteBuf = rbuf.asByteBuffer();
        try {
            JavaType item = this.read(byteBuf);
            if (byteBuf.hasRemaining()) {
                throw new RuntimeException("junk remaining in buffer after lifting, something is very wrong!!");
            }
            JavaType JavaType = item;
            return JavaType;
        }
        finally {
            RustBuffer.free(rbuf);
        }
    }
}

