/*
 * Decompiled with CFR 0.152.
 */
package io.gorules.zen_engine;

import com.sun.jna.Pointer;
import io.gorules.zen_engine.FfiConverterBoolean;
import io.gorules.zen_engine.FfiConverterString;
import io.gorules.zen_engine.FfiConverterTypeJsonBuffer;
import io.gorules.zen_engine.FfiConverterTypeZenExpressionUnary;
import io.gorules.zen_engine.InternalException;
import io.gorules.zen_engine.JsonBuffer;
import io.gorules.zen_engine.NoPointer;
import io.gorules.zen_engine.UniffiCleaner;
import io.gorules.zen_engine.UniffiHelpers;
import io.gorules.zen_engine.UniffiLib;
import io.gorules.zen_engine.UniffiRustCallStatus;
import io.gorules.zen_engine.ZenException;
import io.gorules.zen_engine.ZenExceptionErrorHandler;
import io.gorules.zen_engine.ZenExpressionUnaryInterface;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicLong;
import java.util.function.Consumer;
import java.util.function.Function;

public class ZenExpressionUnary
implements AutoCloseable,
ZenExpressionUnaryInterface {
    protected Pointer pointer;
    protected UniffiCleaner.Cleanable cleanable;
    private AtomicBoolean wasDestroyed = new AtomicBoolean(false);
    private AtomicLong callCounter = new AtomicLong(1L);

    public ZenExpressionUnary(Pointer pointer) {
        this.pointer = pointer;
        this.cleanable = UniffiLib.CLEANER.register(this, new UniffiCleanAction(this, pointer));
    }

    public ZenExpressionUnary(NoPointer noPointer) {
        this.pointer = null;
        this.cleanable = UniffiLib.CLEANER.register(this, new UniffiCleanAction(this, this.pointer));
    }

    @Override
    public synchronized void close() {
        if (this.wasDestroyed.compareAndSet(false, true) && this.callCounter.decrementAndGet() == 0L) {
            this.cleanable.clean();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <R> R callWithPointer(Function<Pointer, R> block) {
        long c;
        do {
            if ((c = this.callCounter.get()) == 0L) {
                throw new IllegalStateException("ZenExpressionUnary object has already been destroyed");
            }
            if (c != Long.MAX_VALUE) continue;
            throw new IllegalStateException("ZenExpressionUnary call counter would overflow");
        } while (!this.callCounter.compareAndSet(c, c + 1L));
        try {
            R r = block.apply(this.uniffiClonePointer());
            return r;
        }
        finally {
            if (this.callCounter.decrementAndGet() == 0L) {
                this.cleanable.clean();
            }
        }
    }

    public void callWithPointer(Consumer<Pointer> block) {
        this.callWithPointer((Pointer p) -> {
            block.accept((Pointer)p);
            return null;
        });
    }

    Pointer uniffiClonePointer() {
        return UniffiHelpers.uniffiRustCall(status -> {
            if (this.pointer == null) {
                throw new NullPointerException();
            }
            return UniffiLib.INSTANCE.uniffi_zen_uniffi_fn_clone_zenexpressionunary(this.pointer, (UniffiRustCallStatus)((Object)status));
        });
    }

    @Override
    public Boolean evaluate(JsonBuffer context) throws ZenException {
        try {
            return FfiConverterBoolean.INSTANCE.lift(this.callWithPointer((Pointer it) -> {
                try {
                    return UniffiHelpers.uniffiRustCallWithError(new ZenExceptionErrorHandler(), _status -> UniffiLib.INSTANCE.uniffi_zen_uniffi_fn_method_zenexpressionunary_evaluate((Pointer)it, FfiConverterTypeJsonBuffer.INSTANCE.lower(context), (UniffiRustCallStatus)((Object)((Object)_status))));
                }
                catch (Exception e) {
                    throw new RuntimeException(e);
                }
            }));
        }
        catch (RuntimeException _e) {
            if (ZenException.class.isInstance(_e.getCause())) {
                throw (ZenException)_e.getCause();
            }
            if (InternalException.class.isInstance(_e.getCause())) {
                throw (InternalException)_e.getCause();
            }
            throw _e;
        }
    }

    public static ZenExpressionUnary compile(String expression) throws ZenException {
        try {
            return FfiConverterTypeZenExpressionUnary.INSTANCE.lift(UniffiHelpers.uniffiRustCallWithError(new ZenExceptionErrorHandler(), _status -> UniffiLib.INSTANCE.uniffi_zen_uniffi_fn_constructor_zenexpressionunary_compile(FfiConverterString.INSTANCE.lower(expression), (UniffiRustCallStatus)((Object)_status))));
        }
        catch (RuntimeException _e) {
            if (ZenException.class.isInstance(_e.getCause())) {
                throw (ZenException)_e.getCause();
            }
            if (InternalException.class.isInstance(_e.getCause())) {
                throw (InternalException)_e.getCause();
            }
            throw _e;
        }
    }

    private class UniffiCleanAction
    implements Runnable {
        private final Pointer pointer;

        public UniffiCleanAction(ZenExpressionUnary zenExpressionUnary, Pointer pointer) {
            this.pointer = pointer;
        }

        @Override
        public void run() {
            if (this.pointer != null) {
                UniffiHelpers.uniffiRustCall(status -> {
                    UniffiLib.INSTANCE.uniffi_zen_uniffi_fn_free_zenexpressionunary(this.pointer, (UniffiRustCallStatus)((Object)status));
                    return null;
                });
            }
        }
    }
}

