/*
 * Decompiled with CFR 0.152.
 */
package io.gorules.zen_engine;

import com.sun.jna.Pointer;
import io.gorules.zen_engine.FfiConverterOptionalTypeZenCustomNodeCallback;
import io.gorules.zen_engine.FfiConverterOptionalTypeZenDecisionLoaderCallback;
import io.gorules.zen_engine.FfiConverterOptionalTypeZenEvaluateOptions;
import io.gorules.zen_engine.FfiConverterString;
import io.gorules.zen_engine.FfiConverterTypeJsonBuffer;
import io.gorules.zen_engine.FfiConverterTypeZenDecision;
import io.gorules.zen_engine.FfiConverterTypeZenEngineResponse;
import io.gorules.zen_engine.InternalException;
import io.gorules.zen_engine.JsonBuffer;
import io.gorules.zen_engine.NoPointer;
import io.gorules.zen_engine.RustBuffer;
import io.gorules.zen_engine.UniffiAsyncHelpers;
import io.gorules.zen_engine.UniffiCleaner;
import io.gorules.zen_engine.UniffiHelpers;
import io.gorules.zen_engine.UniffiLib;
import io.gorules.zen_engine.UniffiRustCallStatus;
import io.gorules.zen_engine.ZenCustomNodeCallback;
import io.gorules.zen_engine.ZenDecision;
import io.gorules.zen_engine.ZenDecisionLoaderCallback;
import io.gorules.zen_engine.ZenEngineInterface;
import io.gorules.zen_engine.ZenEngineResponse;
import io.gorules.zen_engine.ZenEvaluateOptions;
import io.gorules.zen_engine.ZenException;
import io.gorules.zen_engine.ZenExceptionErrorHandler;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicLong;
import java.util.function.Consumer;
import java.util.function.Function;

public class ZenEngine
implements AutoCloseable,
ZenEngineInterface {
    protected Pointer pointer;
    protected UniffiCleaner.Cleanable cleanable;
    private AtomicBoolean wasDestroyed = new AtomicBoolean(false);
    private AtomicLong callCounter = new AtomicLong(1L);

    public ZenEngine(Pointer pointer) {
        this.pointer = pointer;
        this.cleanable = UniffiLib.CLEANER.register(this, new UniffiCleanAction(this, pointer));
    }

    public ZenEngine(NoPointer noPointer) {
        this.pointer = null;
        this.cleanable = UniffiLib.CLEANER.register(this, new UniffiCleanAction(this, this.pointer));
    }

    public ZenEngine(ZenDecisionLoaderCallback loader, ZenCustomNodeCallback customNode) {
        this(UniffiHelpers.uniffiRustCall(_status -> UniffiLib.INSTANCE.uniffi_zen_uniffi_fn_constructor_zenengine_new(FfiConverterOptionalTypeZenDecisionLoaderCallback.INSTANCE.lower(loader), FfiConverterOptionalTypeZenCustomNodeCallback.INSTANCE.lower(customNode), (UniffiRustCallStatus)((Object)_status))));
    }

    @Override
    public synchronized void close() {
        if (this.wasDestroyed.compareAndSet(false, true) && this.callCounter.decrementAndGet() == 0L) {
            this.cleanable.clean();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <R> R callWithPointer(Function<Pointer, R> block) {
        long c;
        do {
            if ((c = this.callCounter.get()) == 0L) {
                throw new IllegalStateException("ZenEngine object has already been destroyed");
            }
            if (c != Long.MAX_VALUE) continue;
            throw new IllegalStateException("ZenEngine call counter would overflow");
        } while (!this.callCounter.compareAndSet(c, c + 1L));
        try {
            R r = block.apply(this.uniffiClonePointer());
            return r;
        }
        finally {
            if (this.callCounter.decrementAndGet() == 0L) {
                this.cleanable.clean();
            }
        }
    }

    public void callWithPointer(Consumer<Pointer> block) {
        this.callWithPointer((Pointer p) -> {
            block.accept((Pointer)p);
            return null;
        });
    }

    Pointer uniffiClonePointer() {
        return UniffiHelpers.uniffiRustCall(status -> {
            if (this.pointer == null) {
                throw new NullPointerException();
            }
            return UniffiLib.INSTANCE.uniffi_zen_uniffi_fn_clone_zenengine(this.pointer, (UniffiRustCallStatus)((Object)status));
        });
    }

    @Override
    public ZenDecision createDecision(JsonBuffer content) throws ZenException {
        try {
            return FfiConverterTypeZenDecision.INSTANCE.lift(this.callWithPointer((Pointer it) -> {
                try {
                    return UniffiHelpers.uniffiRustCallWithError(new ZenExceptionErrorHandler(), _status -> UniffiLib.INSTANCE.uniffi_zen_uniffi_fn_method_zenengine_create_decision((Pointer)it, FfiConverterTypeJsonBuffer.INSTANCE.lower(content), (UniffiRustCallStatus)((Object)((Object)_status))));
                }
                catch (Exception e) {
                    throw new RuntimeException(e);
                }
            }));
        }
        catch (RuntimeException _e) {
            if (ZenException.class.isInstance(_e.getCause())) {
                throw (ZenException)_e.getCause();
            }
            if (InternalException.class.isInstance(_e.getCause())) {
                throw (InternalException)_e.getCause();
            }
            throw _e;
        }
    }

    @Override
    public CompletableFuture<ZenEngineResponse> evaluate(String key, JsonBuffer context, ZenEvaluateOptions options) {
        return UniffiAsyncHelpers.uniffiRustCallAsync((long)this.callWithPointer((Pointer thisPtr) -> UniffiLib.INSTANCE.uniffi_zen_uniffi_fn_method_zenengine_evaluate((Pointer)thisPtr, FfiConverterString.INSTANCE.lower(key), FfiConverterTypeJsonBuffer.INSTANCE.lower(context), FfiConverterOptionalTypeZenEvaluateOptions.INSTANCE.lower(options))), (future, callback, continuation) -> UniffiLib.INSTANCE.ffi_zen_uniffi_rust_future_poll_rust_buffer(future, callback, continuation), (future, continuation) -> UniffiLib.INSTANCE.ffi_zen_uniffi_rust_future_complete_rust_buffer((Long)future, (UniffiRustCallStatus)((Object)continuation)), future -> UniffiLib.INSTANCE.ffi_zen_uniffi_rust_future_free_rust_buffer((Long)future), it -> (ZenEngineResponse)FfiConverterTypeZenEngineResponse.INSTANCE.lift((RustBuffer.ByValue)((Object)it)), new ZenExceptionErrorHandler());
    }

    @Override
    public CompletableFuture<ZenDecision> getDecision(String key) {
        return UniffiAsyncHelpers.uniffiRustCallAsync((long)this.callWithPointer((Pointer thisPtr) -> UniffiLib.INSTANCE.uniffi_zen_uniffi_fn_method_zenengine_get_decision((Pointer)thisPtr, FfiConverterString.INSTANCE.lower(key))), (future, callback, continuation) -> UniffiLib.INSTANCE.ffi_zen_uniffi_rust_future_poll_pointer(future, callback, continuation), (future, continuation) -> UniffiLib.INSTANCE.ffi_zen_uniffi_rust_future_complete_pointer((Long)future, (UniffiRustCallStatus)((Object)continuation)), future -> UniffiLib.INSTANCE.ffi_zen_uniffi_rust_future_free_pointer((Long)future), it -> FfiConverterTypeZenDecision.INSTANCE.lift((Pointer)it), new ZenExceptionErrorHandler());
    }

    private class UniffiCleanAction
    implements Runnable {
        private final Pointer pointer;

        public UniffiCleanAction(ZenEngine zenEngine, Pointer pointer) {
            this.pointer = pointer;
        }

        @Override
        public void run() {
            if (this.pointer != null) {
                UniffiHelpers.uniffiRustCall(status -> {
                    UniffiLib.INSTANCE.uniffi_zen_uniffi_fn_free_zenengine(this.pointer, (UniffiRustCallStatus)((Object)status));
                    return null;
                });
            }
        }
    }
}

