/*
 * Decompiled with CFR 0.152.
 */
package io.gorules.zen_engine;

import com.sun.jna.Pointer;
import io.gorules.zen_engine.FfiConverterOptionalTypeZenEvaluateOptions;
import io.gorules.zen_engine.FfiConverterTypeJsonBuffer;
import io.gorules.zen_engine.FfiConverterTypeZenEngineResponse;
import io.gorules.zen_engine.InternalException;
import io.gorules.zen_engine.JsonBuffer;
import io.gorules.zen_engine.NoPointer;
import io.gorules.zen_engine.RustBuffer;
import io.gorules.zen_engine.UniffiAsyncHelpers;
import io.gorules.zen_engine.UniffiCleaner;
import io.gorules.zen_engine.UniffiHelpers;
import io.gorules.zen_engine.UniffiLib;
import io.gorules.zen_engine.UniffiRustCallStatus;
import io.gorules.zen_engine.ZenDecisionInterface;
import io.gorules.zen_engine.ZenEngineResponse;
import io.gorules.zen_engine.ZenEvaluateOptions;
import io.gorules.zen_engine.ZenException;
import io.gorules.zen_engine.ZenExceptionErrorHandler;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicLong;
import java.util.function.Consumer;
import java.util.function.Function;

public class ZenDecision
implements AutoCloseable,
ZenDecisionInterface {
    protected Pointer pointer;
    protected UniffiCleaner.Cleanable cleanable;
    private AtomicBoolean wasDestroyed = new AtomicBoolean(false);
    private AtomicLong callCounter = new AtomicLong(1L);

    public ZenDecision(Pointer pointer) {
        this.pointer = pointer;
        this.cleanable = UniffiLib.CLEANER.register(this, new UniffiCleanAction(this, pointer));
    }

    public ZenDecision(NoPointer noPointer) {
        this.pointer = null;
        this.cleanable = UniffiLib.CLEANER.register(this, new UniffiCleanAction(this, this.pointer));
    }

    @Override
    public synchronized void close() {
        if (this.wasDestroyed.compareAndSet(false, true) && this.callCounter.decrementAndGet() == 0L) {
            this.cleanable.clean();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <R> R callWithPointer(Function<Pointer, R> block) {
        long c;
        do {
            if ((c = this.callCounter.get()) == 0L) {
                throw new IllegalStateException("ZenDecision object has already been destroyed");
            }
            if (c != Long.MAX_VALUE) continue;
            throw new IllegalStateException("ZenDecision call counter would overflow");
        } while (!this.callCounter.compareAndSet(c, c + 1L));
        try {
            R r = block.apply(this.uniffiClonePointer());
            return r;
        }
        finally {
            if (this.callCounter.decrementAndGet() == 0L) {
                this.cleanable.clean();
            }
        }
    }

    public void callWithPointer(Consumer<Pointer> block) {
        this.callWithPointer((Pointer p) -> {
            block.accept((Pointer)p);
            return null;
        });
    }

    Pointer uniffiClonePointer() {
        return UniffiHelpers.uniffiRustCall(status -> {
            if (this.pointer == null) {
                throw new NullPointerException();
            }
            return UniffiLib.INSTANCE.uniffi_zen_uniffi_fn_clone_zendecision(this.pointer, (UniffiRustCallStatus)((Object)status));
        });
    }

    @Override
    public CompletableFuture<ZenEngineResponse> evaluate(JsonBuffer context, ZenEvaluateOptions options) {
        return UniffiAsyncHelpers.uniffiRustCallAsync((long)this.callWithPointer((Pointer thisPtr) -> UniffiLib.INSTANCE.uniffi_zen_uniffi_fn_method_zendecision_evaluate((Pointer)thisPtr, FfiConverterTypeJsonBuffer.INSTANCE.lower(context), FfiConverterOptionalTypeZenEvaluateOptions.INSTANCE.lower(options))), (future, callback, continuation) -> UniffiLib.INSTANCE.ffi_zen_uniffi_rust_future_poll_rust_buffer(future, callback, continuation), (future, continuation) -> UniffiLib.INSTANCE.ffi_zen_uniffi_rust_future_complete_rust_buffer((Long)future, (UniffiRustCallStatus)((Object)continuation)), future -> UniffiLib.INSTANCE.ffi_zen_uniffi_rust_future_free_rust_buffer((Long)future), it -> (ZenEngineResponse)FfiConverterTypeZenEngineResponse.INSTANCE.lift((RustBuffer.ByValue)((Object)it)), new ZenExceptionErrorHandler());
    }

    @Override
    public void validate() throws ZenException {
        try {
            this.callWithPointer((Pointer it) -> {
                try {
                    UniffiHelpers.uniffiRustCallWithError(new ZenExceptionErrorHandler(), _status -> UniffiLib.INSTANCE.uniffi_zen_uniffi_fn_method_zendecision_validate((Pointer)it, (UniffiRustCallStatus)((Object)((Object)_status))));
                }
                catch (Exception e) {
                    throw new RuntimeException(e);
                }
            });
        }
        catch (RuntimeException _e) {
            if (ZenException.class.isInstance(_e.getCause())) {
                throw (ZenException)_e.getCause();
            }
            if (InternalException.class.isInstance(_e.getCause())) {
                throw (InternalException)_e.getCause();
            }
            throw _e;
        }
    }

    private class UniffiCleanAction
    implements Runnable {
        private final Pointer pointer;

        public UniffiCleanAction(ZenDecision zenDecision, Pointer pointer) {
            this.pointer = pointer;
        }

        @Override
        public void run() {
            if (this.pointer != null) {
                UniffiHelpers.uniffiRustCall(status -> {
                    UniffiLib.INSTANCE.uniffi_zen_uniffi_fn_free_zendecision(this.pointer, (UniffiRustCallStatus)((Object)status));
                    return null;
                });
            }
        }
    }
}

