/*
 * Decompiled with CFR 0.152.
 */
package io.gorules.zen_engine;

import com.sun.jna.Structure;
import io.gorules.zen_engine.RustBuffer;

@Structure.FieldOrder(value={"code", "error_buf"})
public class UniffiRustCallStatus
extends Structure {
    public byte code;
    public RustBuffer.ByValue error_buf;
    public static final byte UNIFFI_CALL_SUCCESS = 0;
    public static final byte UNIFFI_CALL_ERROR = 1;
    public static final byte UNIFFI_CALL_UNEXPECTED_ERROR = 2;

    public boolean isSuccess() {
        return this.code == 0;
    }

    public boolean isError() {
        return this.code == 1;
    }

    public boolean isPanic() {
        return this.code == 2;
    }

    public void setCode(byte code) {
        this.code = code;
    }

    public void setErrorBuf(RustBuffer.ByValue errorBuf) {
        this.error_buf = errorBuf;
    }

    public static ByValue create(byte code, RustBuffer.ByValue errorBuf) {
        ByValue callStatus = new ByValue();
        callStatus.code = code;
        callStatus.error_buf = errorBuf;
        return callStatus;
    }

    public static class ByValue
    extends UniffiRustCallStatus
    implements Structure.ByValue {
    }
}

