/*
 * Decompiled with CFR 0.152.
 */
package io.gorules.zen_engine;

import io.gorules.zen_engine.FfiConverterString;
import io.gorules.zen_engine.InternalException;
import io.gorules.zen_engine.RustBuffer;
import io.gorules.zen_engine.UniffiNullRustCallStatusErrorHandler;
import io.gorules.zen_engine.UniffiRustCallStatus;
import io.gorules.zen_engine.UniffiRustCallStatusErrorHandler;
import java.util.concurrent.Callable;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Supplier;

public final class UniffiHelpers {
    static <U, E extends Exception> U uniffiRustCallWithError(UniffiRustCallStatusErrorHandler<E> errorHandler, Function<UniffiRustCallStatus, U> callback) throws E {
        UniffiRustCallStatus status = new UniffiRustCallStatus();
        U returnValue = callback.apply(status);
        UniffiHelpers.uniffiCheckCallStatus(errorHandler, status);
        return returnValue;
    }

    static <E extends Exception> void uniffiRustCallWithError(UniffiRustCallStatusErrorHandler<E> errorHandler, Consumer<UniffiRustCallStatus> callback) throws E {
        UniffiRustCallStatus status = new UniffiRustCallStatus();
        callback.accept(status);
        UniffiHelpers.uniffiCheckCallStatus(errorHandler, status);
    }

    static <E extends Exception> void uniffiCheckCallStatus(UniffiRustCallStatusErrorHandler<E> errorHandler, UniffiRustCallStatus status) throws E {
        if (status.isSuccess()) {
            return;
        }
        if (status.isError()) {
            throw errorHandler.lift(status.error_buf);
        }
        if (status.isPanic()) {
            if (status.error_buf.len > 0L) {
                throw new InternalException(FfiConverterString.INSTANCE.lift(status.error_buf));
            }
            throw new InternalException("Rust panic");
        }
        throw new InternalException("Unknown rust call status: " + status.code);
    }

    static <U> U uniffiRustCall(Function<UniffiRustCallStatus, U> callback) {
        return UniffiHelpers.uniffiRustCallWithError(new UniffiNullRustCallStatusErrorHandler(), callback);
    }

    static void uniffiRustCall(Consumer<UniffiRustCallStatus> callback) {
        UniffiHelpers.uniffiRustCallWithError(new UniffiNullRustCallStatusErrorHandler(), callback);
    }

    static <T> void uniffiTraitInterfaceCall(UniffiRustCallStatus callStatus, Supplier<T> makeCall, Consumer<T> writeReturn) {
        try {
            writeReturn.accept(makeCall.get());
        }
        catch (Exception e) {
            callStatus.setCode((byte)2);
            callStatus.setErrorBuf(FfiConverterString.INSTANCE.lower(e.toString()));
        }
    }

    static <T, E extends Throwable> void uniffiTraitInterfaceCallWithError(UniffiRustCallStatus callStatus, Callable<T> makeCall, Consumer<T> writeReturn, Function<E, RustBuffer.ByValue> lowerError, Class<E> errorClazz) {
        try {
            writeReturn.accept(makeCall.call());
        }
        catch (Exception e) {
            if (errorClazz.isAssignableFrom(e.getClass())) {
                Exception castedE = e;
                callStatus.setCode((byte)1);
                callStatus.setErrorBuf(lowerError.apply(castedE));
            }
            callStatus.setCode((byte)2);
            callStatus.setErrorBuf(FfiConverterString.INSTANCE.lower(e.toString()));
        }
    }
}

