/*
 * Decompiled with CFR 0.152.
 */
package io.gorules.zen_engine;

import io.gorules.zen_engine.FfiConverter;
import io.gorules.zen_engine.RustBuffer;
import java.nio.ByteBuffer;
import java.nio.CharBuffer;
import java.nio.charset.CharacterCodingException;
import java.nio.charset.CharsetEncoder;
import java.nio.charset.CodingErrorAction;
import java.nio.charset.StandardCharsets;

public enum FfiConverterString implements FfiConverter<String, RustBuffer.ByValue>
{
    INSTANCE;


    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String lift(RustBuffer.ByValue value) {
        try {
            byte[] byteArr = new byte[(int)value.len];
            value.asByteBuffer().get(byteArr);
            String string = new String(byteArr, StandardCharsets.UTF_8);
            return string;
        }
        finally {
            RustBuffer.free(value);
        }
    }

    @Override
    public String read(ByteBuffer buf) {
        int len = buf.getInt();
        byte[] byteArr = new byte[len];
        buf.get(byteArr);
        return new String(byteArr, StandardCharsets.UTF_8);
    }

    private ByteBuffer toUtf8(String value) {
        CharsetEncoder encoder = StandardCharsets.UTF_8.newEncoder();
        encoder.onMalformedInput(CodingErrorAction.REPORT);
        try {
            return encoder.encode(CharBuffer.wrap(value));
        }
        catch (CharacterCodingException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public RustBuffer.ByValue lower(String value) {
        ByteBuffer byteBuf = this.toUtf8(value);
        RustBuffer.ByValue rbuf = RustBuffer.alloc(byteBuf.limit());
        rbuf.asByteBuffer().put(byteBuf);
        return rbuf;
    }

    @Override
    public long allocationSize(String value) {
        long sizeForLength = 4L;
        long sizeForString = (long)value.length() * 3L;
        return sizeForLength + sizeForString;
    }

    @Override
    public void write(String value, ByteBuffer buf) {
        ByteBuffer byteBuf = this.toUtf8(value);
        buf.putInt(byteBuf.limit());
        buf.put(byteBuf);
    }
}

