package io.gorules.zen_engine;


import java.util.List;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
public class ZenUniffi {
  public static JsonBuffer evaluateExpression(String expression, JsonBuffer context) throws ZenException {
            try {
                return FfiConverterTypeJsonBuffer.INSTANCE.lift(
    UniffiHelpers.uniffiRustCallWithError(new ZenExceptionErrorHandler(), _status -> {
        return UniffiLib.INSTANCE.uniffi_zen_uniffi_fn_func_evaluate_expression(
            FfiConverterString.INSTANCE.lower(expression), FfiConverterOptionalTypeJsonBuffer.INSTANCE.lower(context), _status);
    })
    );
            } catch (RuntimeException _e) {
                
                if (ZenException.class.isInstance(_e.getCause())) {
                    throw (ZenException)_e.getCause();
                }
                
                if (InternalException.class.isInstance(_e.getCause())) {
                    throw (InternalException)_e.getCause();
                }
                throw _e;
            }
    }
    

  public static Boolean evaluateUnaryExpression(String expression, JsonBuffer context) throws ZenException {
            try {
                return FfiConverterBoolean.INSTANCE.lift(
    UniffiHelpers.uniffiRustCallWithError(new ZenExceptionErrorHandler(), _status -> {
        return UniffiLib.INSTANCE.uniffi_zen_uniffi_fn_func_evaluate_unary_expression(
            FfiConverterString.INSTANCE.lower(expression), FfiConverterTypeJsonBuffer.INSTANCE.lower(context), _status);
    })
    );
            } catch (RuntimeException _e) {
                
                if (ZenException.class.isInstance(_e.getCause())) {
                    throw (ZenException)_e.getCause();
                }
                
                if (InternalException.class.isInstance(_e.getCause())) {
                    throw (InternalException)_e.getCause();
                }
                throw _e;
            }
    }
    

  public static void overrideConfig(ZenConfig config)  {
            try {
                
    UniffiHelpers.uniffiRustCall( _status -> {
        UniffiLib.INSTANCE.uniffi_zen_uniffi_fn_func_override_config(
            FfiConverterTypeZenConfig.INSTANCE.lower(config), _status);
    })
    ;
            } catch (RuntimeException _e) {
                
                
                if (InternalException.class.isInstance(_e.getCause())) {
                    throw (InternalException)_e.getCause();
                }
                throw _e;
            }
    }
    

}

