package io.gorules.zen_engine;



public class ZenException extends Exception {
    private ZenException(String message) {
      super(message); 
    }

    
    public static class Zero extends ZenException {
      public Zero() {
        super(new StringBuilder()
        .toString());
        }

      
      
      
    }
    
    public static class InvalidArgument extends ZenException {
      public InvalidArgument() {
        super(new StringBuilder()
        .toString());
        }

      
      
      
    }
    
    public static class StringNullException extends ZenException {
      public StringNullException() {
        super(new StringBuilder()
        .toString());
        }

      
      
      
    }
    
    public static class StringUtf8Exception extends ZenException {
      public StringUtf8Exception() {
        super(new StringBuilder()
        .toString());
        }

      
      
      
    }
    
    public static class JsonSerializationFailed extends ZenException {
      public JsonSerializationFailed() {
        super(new StringBuilder()
        .toString());
        }

      
      
      
    }
    
    public static class JsonDeserializationFailed extends ZenException {
      public JsonDeserializationFailed() {
        super(new StringBuilder()
        .toString());
        }

      
      
      
    }
    
    public static class ExecutionTaskSpawnException extends ZenException {
      public ExecutionTaskSpawnException() {
        super(new StringBuilder()
        .toString());
        }

      
      
      
    }
    
    public static class IsolateException extends ZenException {
      
      String v1;
      public IsolateException(String v1) {
        super(new StringBuilder()
        .append("v1=")
        .append(v1)
        
        
        .toString());
        this.v1 = v1;
        }

      public String v1() {
        return this.v1;
      }
      
      
      
    }
    
    public static class EvaluationException extends ZenException {
      
      String v1;
      public EvaluationException(String v1) {
        super(new StringBuilder()
        .append("v1=")
        .append(v1)
        
        
        .toString());
        this.v1 = v1;
        }

      public String v1() {
        return this.v1;
      }
      
      
      
    }
    
    public static class ValidationException extends ZenException {
      
      String v1;
      public ValidationException(String v1) {
        super(new StringBuilder()
        .append("v1=")
        .append(v1)
        
        
        .toString());
        this.v1 = v1;
        }

      public String v1() {
        return this.v1;
      }
      
      
      
    }
    
    public static class LoaderKeyNotFound extends ZenException {
      
      String key;
      public LoaderKeyNotFound(String key) {
        super(new StringBuilder()
        .append("key=")
        .append(key)
        
        
        .toString());
        this.key = key;
        }

      public String key() {
        return this.key;
      }
      
      
      
    }
    
    public static class LoaderInternalException extends ZenException {
      
      String key;
      
      String details;
      public LoaderInternalException(String key, String details) {
        super(new StringBuilder()
        .append("key=")
        .append(key)
        
        .append(", ")
        
        
        .append("details=")
        .append(details)
        
        
        .toString());
        this.key = key;
        this.details = details;
        }

      public String key() {
        return this.key;
      }
      public String details() {
        return this.details;
      }
      
      
      
    }
    
    public static class TemplateEngineException extends ZenException {
      
      String template;
      
      String details;
      public TemplateEngineException(String template, String details) {
        super(new StringBuilder()
        .append("template=")
        .append(template)
        
        .append(", ")
        
        
        .append("details=")
        .append(details)
        
        
        .toString());
        this.template = template;
        this.details = details;
        }

      public String template() {
        return this.template;
      }
      public String details() {
        return this.details;
      }
      
      
      
    }
     
}

