package io.gorules.zen_engine;


import com.sun.jna.Structure;
import com.sun.jna.Pointer;

@Structure.FieldOrder({ "returnValue", "callStatus" })
public class UniffiForeignFutureStructI8 extends Structure {
    public byte returnValue = (byte)0;
    public UniffiRustCallStatus.ByValue callStatus = new UniffiRustCallStatus.ByValue();

    // no-arg constructor required so JNA can instantiate and reflect
    public UniffiForeignFutureStructI8() {
        super();
    }
    
    public UniffiForeignFutureStructI8(
        byte returnValue,
        UniffiRustCallStatus.ByValue callStatus
    ) {
        this.returnValue = returnValue;
        this.callStatus = callStatus;
    }

    public static class UniffiByValue extends UniffiForeignFutureStructI8 implements Structure.ByValue {
        public UniffiByValue(
            byte returnValue,
            UniffiRustCallStatus.ByValue callStatus
        ) {
            super(returnValue,        
            callStatus        
            );
        }
    }

    void uniffiSetValue(UniffiForeignFutureStructI8 other) {
        returnValue = other.returnValue;
        callStatus = other.callStatus;
    }

}
