package io.gorules.zen_engine;


import java.nio.ByteBuffer;

public enum FfiConverterTypeZenError implements FfiConverterRustBuffer<ZenException> {
    INSTANCE;

    @Override
    public ZenException read(ByteBuffer buf) {

        return switch(buf.getInt()) {
            case 1 -> new ZenException.Zero();
            case 2 -> new ZenException.InvalidArgument();
            case 3 -> new ZenException.StringNullException();
            case 4 -> new ZenException.StringUtf8Exception();
            case 5 -> new ZenException.JsonSerializationFailed();
            case 6 -> new ZenException.JsonDeserializationFailed();
            case 7 -> new ZenException.ExecutionTaskSpawnException();
            case 8 -> new ZenException.IsolateException(
                FfiConverterString.INSTANCE.read(buf)
                );
            case 9 -> new ZenException.EvaluationException(
                FfiConverterString.INSTANCE.read(buf)
                );
            case 10 -> new ZenException.ValidationException(
                FfiConverterString.INSTANCE.read(buf)
                );
            case 11 -> new ZenException.LoaderKeyNotFound(
                FfiConverterString.INSTANCE.read(buf)
                );
            case 12 -> new ZenException.LoaderInternalException(
                FfiConverterString.INSTANCE.read(buf),
                FfiConverterString.INSTANCE.read(buf)
                );
            case 13 -> new ZenException.TemplateEngineException(
                FfiConverterString.INSTANCE.read(buf),
                FfiConverterString.INSTANCE.read(buf)
                );
            default -> throw new RuntimeException("invalid error enum value, something is very wrong!!");
        };
    }

    @Override
    public long allocationSize(ZenException value) {
        return switch(value) {
            case ZenException.Zero x -> (
                // Add the size for the Int that specifies the variant plus the size needed for all fields
                4L
            );
            case ZenException.InvalidArgument x -> (
                // Add the size for the Int that specifies the variant plus the size needed for all fields
                4L
            );
            case ZenException.StringNullException x -> (
                // Add the size for the Int that specifies the variant plus the size needed for all fields
                4L
            );
            case ZenException.StringUtf8Exception x -> (
                // Add the size for the Int that specifies the variant plus the size needed for all fields
                4L
            );
            case ZenException.JsonSerializationFailed x -> (
                // Add the size for the Int that specifies the variant plus the size needed for all fields
                4L
            );
            case ZenException.JsonDeserializationFailed x -> (
                // Add the size for the Int that specifies the variant plus the size needed for all fields
                4L
            );
            case ZenException.ExecutionTaskSpawnException x -> (
                // Add the size for the Int that specifies the variant plus the size needed for all fields
                4L
            );
            case ZenException.IsolateException x -> (
                // Add the size for the Int that specifies the variant plus the size needed for all fields
                4L
                + FfiConverterString.INSTANCE.allocationSize(x.v1)
            );
            case ZenException.EvaluationException x -> (
                // Add the size for the Int that specifies the variant plus the size needed for all fields
                4L
                + FfiConverterString.INSTANCE.allocationSize(x.v1)
            );
            case ZenException.ValidationException x -> (
                // Add the size for the Int that specifies the variant plus the size needed for all fields
                4L
                + FfiConverterString.INSTANCE.allocationSize(x.v1)
            );
            case ZenException.LoaderKeyNotFound x -> (
                // Add the size for the Int that specifies the variant plus the size needed for all fields
                4L
                + FfiConverterString.INSTANCE.allocationSize(x.key)
            );
            case ZenException.LoaderInternalException x -> (
                // Add the size for the Int that specifies the variant plus the size needed for all fields
                4L
                + FfiConverterString.INSTANCE.allocationSize(x.key)
                + FfiConverterString.INSTANCE.allocationSize(x.details)
            );
            case ZenException.TemplateEngineException x -> (
                // Add the size for the Int that specifies the variant plus the size needed for all fields
                4L
                + FfiConverterString.INSTANCE.allocationSize(x.template)
                + FfiConverterString.INSTANCE.allocationSize(x.details)
            );
            default -> throw new RuntimeException("invalid error enum value, something is very wrong!!");
        };
    }

    @Override
    public void write(ZenException value, ByteBuffer buf) {
        switch(value) {
            case ZenException.Zero x -> {
                buf.putInt(1);
            }
            case ZenException.InvalidArgument x -> {
                buf.putInt(2);
            }
            case ZenException.StringNullException x -> {
                buf.putInt(3);
            }
            case ZenException.StringUtf8Exception x -> {
                buf.putInt(4);
            }
            case ZenException.JsonSerializationFailed x -> {
                buf.putInt(5);
            }
            case ZenException.JsonDeserializationFailed x -> {
                buf.putInt(6);
            }
            case ZenException.ExecutionTaskSpawnException x -> {
                buf.putInt(7);
            }
            case ZenException.IsolateException x -> {
                buf.putInt(8);
                FfiConverterString.INSTANCE.write(x.v1, buf);
            }
            case ZenException.EvaluationException x -> {
                buf.putInt(9);
                FfiConverterString.INSTANCE.write(x.v1, buf);
            }
            case ZenException.ValidationException x -> {
                buf.putInt(10);
                FfiConverterString.INSTANCE.write(x.v1, buf);
            }
            case ZenException.LoaderKeyNotFound x -> {
                buf.putInt(11);
                FfiConverterString.INSTANCE.write(x.key, buf);
            }
            case ZenException.LoaderInternalException x -> {
                buf.putInt(12);
                FfiConverterString.INSTANCE.write(x.key, buf);
                FfiConverterString.INSTANCE.write(x.details, buf);
            }
            case ZenException.TemplateEngineException x -> {
                buf.putInt(13);
                FfiConverterString.INSTANCE.write(x.template, buf);
                FfiConverterString.INSTANCE.write(x.details, buf);
            }
            default -> throw new RuntimeException("invalid error enum value, something is very wrong!!");
        };
    }
}




