package io.gorules.zen_engine;


import java.nio.ByteBuffer;
import java.util.List;
import java.util.Map;

// public class TestForOptionals {}
public enum FfiConverterOptionalTypeZenDecisionLoaderCallback implements FfiConverterRustBuffer<ZenDecisionLoaderCallback> {
  INSTANCE;

  @Override
  public ZenDecisionLoaderCallback read(ByteBuffer buf) {
    if (buf.get() == (byte)0) {
      return null;
    }
    return FfiConverterTypeZenDecisionLoaderCallback.INSTANCE.read(buf);
  }

  @Override
  public long allocationSize(ZenDecisionLoaderCallback value) {
    if (value == null) {
      return 1L;
    } else {
      return 1L + FfiConverterTypeZenDecisionLoaderCallback.INSTANCE.allocationSize(value);
    }
  }

  @Override
  public void write(ZenDecisionLoaderCallback value, ByteBuffer buf) {
    if (value == null) {
      buf.put((byte)0);
    } else {
      buf.put((byte)1);
      FfiConverterTypeZenDecisionLoaderCallback.INSTANCE.write(value, buf);
    }
  }
}



