// This file was autogenerated by some hot garbage in the `uniffi` crate.
// Trust me, you don't want to mess with it!

@file:Suppress("NAME_SHADOWING")

package io.gorules.zen_engine.kotlin

// Common helper code.
//
// Ideally this would live in a separate .kt file where it can be unittested etc
// in isolation, and perhaps even published as a re-useable package.
//
// However, it's important that the details of how this helper code works (e.g. the
// way that different builtin types are passed across the FFI) exactly match what's
// expected by the Rust code on the other side of the interface. In practice right
// now that means coming from the exact some version of `uniffi` that was used to
// compile the Rust component. The easiest way to ensure this is to bundle the Kotlin
// helpers directly inline like we're doing here.

import com.sun.jna.Library
import com.sun.jna.IntegerType
import com.sun.jna.Native
import com.sun.jna.Pointer
import com.sun.jna.Structure
import com.sun.jna.Callback
import com.sun.jna.ptr.*
import java.nio.ByteBuffer
import java.nio.ByteOrder
import java.nio.CharBuffer
import java.nio.charset.CodingErrorAction
import java.util.concurrent.atomic.AtomicLong
import java.util.concurrent.ConcurrentHashMap
import java.util.concurrent.atomic.AtomicBoolean
import kotlin.coroutines.resume
import kotlinx.coroutines.CancellableContinuation
import kotlinx.coroutines.DelicateCoroutinesApi
import kotlinx.coroutines.GlobalScope
import kotlinx.coroutines.Job
import kotlinx.coroutines.launch
import kotlinx.coroutines.suspendCancellableCoroutine

// This is a helper for safely working with byte buffers returned from the Rust code.
// A rust-owned buffer is represented by its capacity, its current length, and a
// pointer to the underlying data.

/**
 * @suppress
 */
@Structure.FieldOrder("capacity", "len", "data")
open class RustBuffer : Structure() {
    // Note: `capacity` and `len` are actually `ULong` values, but JVM only supports signed values.
    // When dealing with these fields, make sure to call `toULong()`.
    @JvmField var capacity: Long = 0
    @JvmField var len: Long = 0
    @JvmField var data: Pointer? = null

    class ByValue: RustBuffer(), Structure.ByValue
    class ByReference: RustBuffer(), Structure.ByReference

   internal fun setValue(other: RustBuffer) {
        capacity = other.capacity
        len = other.len
        data = other.data
    }

    companion object {
        internal fun alloc(size: ULong = 0UL) = uniffiRustCall() { status ->
            // Note: need to convert the size to a `Long` value to make this work with JVM.
            UniffiLib.INSTANCE.ffi_zen_uniffi_rustbuffer_alloc(size.toLong(), status)
        }.also {
            if(it.data == null) {
               throw RuntimeException("RustBuffer.alloc() returned null data pointer (size=${size})")
           }
        }

        internal fun create(capacity: ULong, len: ULong, data: Pointer?): RustBuffer.ByValue {
            var buf = RustBuffer.ByValue()
            buf.capacity = capacity.toLong()
            buf.len = len.toLong()
            buf.data = data
            return buf
        }

        internal fun free(buf: RustBuffer.ByValue) = uniffiRustCall() { status ->
            UniffiLib.INSTANCE.ffi_zen_uniffi_rustbuffer_free(buf, status)
        }
    }

    @Suppress("TooGenericExceptionThrown")
    fun asByteBuffer() =
        this.data?.getByteBuffer(0, this.len.toLong())?.also {
            it.order(ByteOrder.BIG_ENDIAN)
        }
}

/**
 * The equivalent of the `*mut RustBuffer` type.
 * Required for callbacks taking in an out pointer.
 *
 * Size is the sum of all values in the struct.
 *
 * @suppress
 */
class RustBufferByReference : ByReference(16) {
    /**
     * Set the pointed-to `RustBuffer` to the given value.
     */
    fun setValue(value: RustBuffer.ByValue) {
        // NOTE: The offsets are as they are in the C-like struct.
        val pointer = getPointer()
        pointer.setLong(0, value.capacity)
        pointer.setLong(8, value.len)
        pointer.setPointer(16, value.data)
    }

    /**
     * Get a `RustBuffer.ByValue` from this reference.
     */
    fun getValue(): RustBuffer.ByValue {
        val pointer = getPointer()
        val value = RustBuffer.ByValue()
        value.writeField("capacity", pointer.getLong(0))
        value.writeField("len", pointer.getLong(8))
        value.writeField("data", pointer.getLong(16))

        return value
    }
}

// This is a helper for safely passing byte references into the rust code.
// It's not actually used at the moment, because there aren't many things that you
// can take a direct pointer to in the JVM, and if we're going to copy something
// then we might as well copy it into a `RustBuffer`. But it's here for API
// completeness.

@Structure.FieldOrder("len", "data")
internal open class ForeignBytes : Structure() {
    @JvmField var len: Int = 0
    @JvmField var data: Pointer? = null

    class ByValue : ForeignBytes(), Structure.ByValue
}
/**
 * The FfiConverter interface handles converter types to and from the FFI
 *
 * All implementing objects should be public to support external types.  When a
 * type is external we need to import it's FfiConverter.
 *
 * @suppress
 */
public interface FfiConverter<KotlinType, FfiType> {
    // Convert an FFI type to a Kotlin type
    fun lift(value: FfiType): KotlinType

    // Convert an Kotlin type to an FFI type
    fun lower(value: KotlinType): FfiType

    // Read a Kotlin type from a `ByteBuffer`
    fun read(buf: ByteBuffer): KotlinType

    // Calculate bytes to allocate when creating a `RustBuffer`
    //
    // This must return at least as many bytes as the write() function will
    // write. It can return more bytes than needed, for example when writing
    // Strings we can't know the exact bytes needed until we the UTF-8
    // encoding, so we pessimistically allocate the largest size possible (3
    // bytes per codepoint).  Allocating extra bytes is not really a big deal
    // because the `RustBuffer` is short-lived.
    fun allocationSize(value: KotlinType): ULong

    // Write a Kotlin type to a `ByteBuffer`
    fun write(value: KotlinType, buf: ByteBuffer)

    // Lower a value into a `RustBuffer`
    //
    // This method lowers a value into a `RustBuffer` rather than the normal
    // FfiType.  It's used by the callback interface code.  Callback interface
    // returns are always serialized into a `RustBuffer` regardless of their
    // normal FFI type.
    fun lowerIntoRustBuffer(value: KotlinType): RustBuffer.ByValue {
        val rbuf = RustBuffer.alloc(allocationSize(value))
        try {
            val bbuf = rbuf.data!!.getByteBuffer(0, rbuf.capacity).also {
                it.order(ByteOrder.BIG_ENDIAN)
            }
            write(value, bbuf)
            rbuf.writeField("len", bbuf.position().toLong())
            return rbuf
        } catch (e: Throwable) {
            RustBuffer.free(rbuf)
            throw e
        }
    }

    // Lift a value from a `RustBuffer`.
    //
    // This here mostly because of the symmetry with `lowerIntoRustBuffer()`.
    // It's currently only used by the `FfiConverterRustBuffer` class below.
    fun liftFromRustBuffer(rbuf: RustBuffer.ByValue): KotlinType {
        val byteBuf = rbuf.asByteBuffer()!!
        try {
           val item = read(byteBuf)
           if (byteBuf.hasRemaining()) {
               throw RuntimeException("junk remaining in buffer after lifting, something is very wrong!!")
           }
           return item
        } finally {
            RustBuffer.free(rbuf)
        }
    }
}

/**
 * FfiConverter that uses `RustBuffer` as the FfiType
 *
 * @suppress
 */
public interface FfiConverterRustBuffer<KotlinType>: FfiConverter<KotlinType, RustBuffer.ByValue> {
    override fun lift(value: RustBuffer.ByValue) = liftFromRustBuffer(value)
    override fun lower(value: KotlinType) = lowerIntoRustBuffer(value)
}
// A handful of classes and functions to support the generated data structures.
// This would be a good candidate for isolating in its own ffi-support lib.

internal const val UNIFFI_CALL_SUCCESS = 0.toByte()
internal const val UNIFFI_CALL_ERROR = 1.toByte()
internal const val UNIFFI_CALL_UNEXPECTED_ERROR = 2.toByte()

@Structure.FieldOrder("code", "error_buf")
internal open class UniffiRustCallStatus : Structure() {
    @JvmField var code: Byte = 0
    @JvmField var error_buf: RustBuffer.ByValue = RustBuffer.ByValue()

    class ByValue: UniffiRustCallStatus(), Structure.ByValue

    fun isSuccess(): Boolean {
        return code == UNIFFI_CALL_SUCCESS
    }

    fun isError(): Boolean {
        return code == UNIFFI_CALL_ERROR
    }

    fun isPanic(): Boolean {
        return code == UNIFFI_CALL_UNEXPECTED_ERROR
    }

    companion object {
        fun create(code: Byte, errorBuf: RustBuffer.ByValue): UniffiRustCallStatus.ByValue {
            val callStatus = UniffiRustCallStatus.ByValue()
            callStatus.code = code
            callStatus.error_buf = errorBuf
            return callStatus
        }
    }
}

class InternalException(message: String) : kotlin.Exception(message)

/**
 * Each top-level error class has a companion object that can lift the error from the call status's rust buffer
 *
 * @suppress
 */
interface UniffiRustCallStatusErrorHandler<E> {
    fun lift(error_buf: RustBuffer.ByValue): E;
}

// Helpers for calling Rust
// In practice we usually need to be synchronized to call this safely, so it doesn't
// synchronize itself

// Call a rust function that returns a Result<>.  Pass in the Error class companion that corresponds to the Err
private inline fun <U, E: kotlin.Exception> uniffiRustCallWithError(errorHandler: UniffiRustCallStatusErrorHandler<E>, callback: (UniffiRustCallStatus) -> U): U {
    var status = UniffiRustCallStatus()
    val return_value = callback(status)
    uniffiCheckCallStatus(errorHandler, status)
    return return_value
}

// Check UniffiRustCallStatus and throw an error if the call wasn't successful
private fun<E: kotlin.Exception> uniffiCheckCallStatus(errorHandler: UniffiRustCallStatusErrorHandler<E>, status: UniffiRustCallStatus) {
    if (status.isSuccess()) {
        return
    } else if (status.isError()) {
        throw errorHandler.lift(status.error_buf)
    } else if (status.isPanic()) {
        // when the rust code sees a panic, it tries to construct a rustbuffer
        // with the message.  but if that code panics, then it just sends back
        // an empty buffer.
        if (status.error_buf.len > 0) {
            throw InternalException(FfiConverterString.lift(status.error_buf))
        } else {
            throw InternalException("Rust panic")
        }
    } else {
        throw InternalException("Unknown rust call status: $status.code")
    }
}

/**
 * UniffiRustCallStatusErrorHandler implementation for times when we don't expect a CALL_ERROR
 *
 * @suppress
 */
object UniffiNullRustCallStatusErrorHandler: UniffiRustCallStatusErrorHandler<InternalException> {
    override fun lift(error_buf: RustBuffer.ByValue): InternalException {
        RustBuffer.free(error_buf)
        return InternalException("Unexpected CALL_ERROR")
    }
}

// Call a rust function that returns a plain value
private inline fun <U> uniffiRustCall(callback: (UniffiRustCallStatus) -> U): U {
    return uniffiRustCallWithError(UniffiNullRustCallStatusErrorHandler, callback)
}

internal inline fun<T> uniffiTraitInterfaceCall(
    callStatus: UniffiRustCallStatus,
    makeCall: () -> T,
    writeReturn: (T) -> Unit,
) {
    try {
        writeReturn(makeCall())
    } catch(e: kotlin.Exception) {
        callStatus.code = UNIFFI_CALL_UNEXPECTED_ERROR
        callStatus.error_buf = FfiConverterString.lower(e.toString())
    }
}

internal inline fun<T, reified E: Throwable> uniffiTraitInterfaceCallWithError(
    callStatus: UniffiRustCallStatus,
    makeCall: () -> T,
    writeReturn: (T) -> Unit,
    lowerError: (E) -> RustBuffer.ByValue
) {
    try {
        writeReturn(makeCall())
    } catch(e: kotlin.Exception) {
        if (e is E) {
            callStatus.code = UNIFFI_CALL_ERROR
            callStatus.error_buf = lowerError(e)
        } else {
            callStatus.code = UNIFFI_CALL_UNEXPECTED_ERROR
            callStatus.error_buf = FfiConverterString.lower(e.toString())
        }
    }
}
// Map handles to objects
//
// This is used pass an opaque 64-bit handle representing a foreign object to the Rust code.
internal class UniffiHandleMap<T: Any> {
    private val map = ConcurrentHashMap<Long, T>()
    private val counter = java.util.concurrent.atomic.AtomicLong(0)

    val size: Int
        get() = map.size

    // Insert a new object into the handle map and get a handle for it
    fun insert(obj: T): Long {
        val handle = counter.getAndAdd(1)
        map.put(handle, obj)
        return handle
    }

    // Get an object from the handle map
    fun get(handle: Long): T {
        return map.get(handle) ?: throw InternalException("UniffiHandleMap.get: Invalid handle")
    }

    // Remove an entry from the handlemap and get the Kotlin object back
    fun remove(handle: Long): T {
        return map.remove(handle) ?: throw InternalException("UniffiHandleMap: Invalid handle")
    }
}

// Contains loading, initialization code,
// and the FFI Function declarations in a com.sun.jna.Library.
@Synchronized
private fun findLibraryName(componentName: String): String {
    val libOverride = System.getProperty("uniffi.component.$componentName.libraryOverride")
    if (libOverride != null) {
        return libOverride
    }
    return "zen_uniffi"
}

private inline fun <reified Lib : Library> loadIndirect(
    componentName: String
): Lib {
    return Native.load<Lib>(findLibraryName(componentName), Lib::class.java)
}

// Define FFI callback types
internal interface UniffiRustFutureContinuationCallback : com.sun.jna.Callback {
    fun callback(`data`: Long,`pollResult`: Byte,)
}
internal interface UniffiForeignFutureFree : com.sun.jna.Callback {
    fun callback(`handle`: Long,)
}
internal interface UniffiCallbackInterfaceFree : com.sun.jna.Callback {
    fun callback(`handle`: Long,)
}
@Structure.FieldOrder("handle", "free")
internal open class UniffiForeignFuture(
    @JvmField internal var `handle`: Long = 0.toLong(),
    @JvmField internal var `free`: UniffiForeignFutureFree? = null,
) : Structure() {
    class UniffiByValue(
        `handle`: Long = 0.toLong(),
        `free`: UniffiForeignFutureFree? = null,
    ): UniffiForeignFuture(`handle`,`free`,), Structure.ByValue

   internal fun uniffiSetValue(other: UniffiForeignFuture) {
        `handle` = other.`handle`
        `free` = other.`free`
    }

}
@Structure.FieldOrder("returnValue", "callStatus")
internal open class UniffiForeignFutureStructU8(
    @JvmField internal var `returnValue`: Byte = 0.toByte(),
    @JvmField internal var `callStatus`: UniffiRustCallStatus.ByValue = UniffiRustCallStatus.ByValue(),
) : Structure() {
    class UniffiByValue(
        `returnValue`: Byte = 0.toByte(),
        `callStatus`: UniffiRustCallStatus.ByValue = UniffiRustCallStatus.ByValue(),
    ): UniffiForeignFutureStructU8(`returnValue`,`callStatus`,), Structure.ByValue

   internal fun uniffiSetValue(other: UniffiForeignFutureStructU8) {
        `returnValue` = other.`returnValue`
        `callStatus` = other.`callStatus`
    }

}
internal interface UniffiForeignFutureCompleteU8 : com.sun.jna.Callback {
    fun callback(`callbackData`: Long,`result`: UniffiForeignFutureStructU8.UniffiByValue,)
}
@Structure.FieldOrder("returnValue", "callStatus")
internal open class UniffiForeignFutureStructI8(
    @JvmField internal var `returnValue`: Byte = 0.toByte(),
    @JvmField internal var `callStatus`: UniffiRustCallStatus.ByValue = UniffiRustCallStatus.ByValue(),
) : Structure() {
    class UniffiByValue(
        `returnValue`: Byte = 0.toByte(),
        `callStatus`: UniffiRustCallStatus.ByValue = UniffiRustCallStatus.ByValue(),
    ): UniffiForeignFutureStructI8(`returnValue`,`callStatus`,), Structure.ByValue

   internal fun uniffiSetValue(other: UniffiForeignFutureStructI8) {
        `returnValue` = other.`returnValue`
        `callStatus` = other.`callStatus`
    }

}
internal interface UniffiForeignFutureCompleteI8 : com.sun.jna.Callback {
    fun callback(`callbackData`: Long,`result`: UniffiForeignFutureStructI8.UniffiByValue,)
}
@Structure.FieldOrder("returnValue", "callStatus")
internal open class UniffiForeignFutureStructU16(
    @JvmField internal var `returnValue`: Short = 0.toShort(),
    @JvmField internal var `callStatus`: UniffiRustCallStatus.ByValue = UniffiRustCallStatus.ByValue(),
) : Structure() {
    class UniffiByValue(
        `returnValue`: Short = 0.toShort(),
        `callStatus`: UniffiRustCallStatus.ByValue = UniffiRustCallStatus.ByValue(),
    ): UniffiForeignFutureStructU16(`returnValue`,`callStatus`,), Structure.ByValue

   internal fun uniffiSetValue(other: UniffiForeignFutureStructU16) {
        `returnValue` = other.`returnValue`
        `callStatus` = other.`callStatus`
    }

}
internal interface UniffiForeignFutureCompleteU16 : com.sun.jna.Callback {
    fun callback(`callbackData`: Long,`result`: UniffiForeignFutureStructU16.UniffiByValue,)
}
@Structure.FieldOrder("returnValue", "callStatus")
internal open class UniffiForeignFutureStructI16(
    @JvmField internal var `returnValue`: Short = 0.toShort(),
    @JvmField internal var `callStatus`: UniffiRustCallStatus.ByValue = UniffiRustCallStatus.ByValue(),
) : Structure() {
    class UniffiByValue(
        `returnValue`: Short = 0.toShort(),
        `callStatus`: UniffiRustCallStatus.ByValue = UniffiRustCallStatus.ByValue(),
    ): UniffiForeignFutureStructI16(`returnValue`,`callStatus`,), Structure.ByValue

   internal fun uniffiSetValue(other: UniffiForeignFutureStructI16) {
        `returnValue` = other.`returnValue`
        `callStatus` = other.`callStatus`
    }

}
internal interface UniffiForeignFutureCompleteI16 : com.sun.jna.Callback {
    fun callback(`callbackData`: Long,`result`: UniffiForeignFutureStructI16.UniffiByValue,)
}
@Structure.FieldOrder("returnValue", "callStatus")
internal open class UniffiForeignFutureStructU32(
    @JvmField internal var `returnValue`: Int = 0,
    @JvmField internal var `callStatus`: UniffiRustCallStatus.ByValue = UniffiRustCallStatus.ByValue(),
) : Structure() {
    class UniffiByValue(
        `returnValue`: Int = 0,
        `callStatus`: UniffiRustCallStatus.ByValue = UniffiRustCallStatus.ByValue(),
    ): UniffiForeignFutureStructU32(`returnValue`,`callStatus`,), Structure.ByValue

   internal fun uniffiSetValue(other: UniffiForeignFutureStructU32) {
        `returnValue` = other.`returnValue`
        `callStatus` = other.`callStatus`
    }

}
internal interface UniffiForeignFutureCompleteU32 : com.sun.jna.Callback {
    fun callback(`callbackData`: Long,`result`: UniffiForeignFutureStructU32.UniffiByValue,)
}
@Structure.FieldOrder("returnValue", "callStatus")
internal open class UniffiForeignFutureStructI32(
    @JvmField internal var `returnValue`: Int = 0,
    @JvmField internal var `callStatus`: UniffiRustCallStatus.ByValue = UniffiRustCallStatus.ByValue(),
) : Structure() {
    class UniffiByValue(
        `returnValue`: Int = 0,
        `callStatus`: UniffiRustCallStatus.ByValue = UniffiRustCallStatus.ByValue(),
    ): UniffiForeignFutureStructI32(`returnValue`,`callStatus`,), Structure.ByValue

   internal fun uniffiSetValue(other: UniffiForeignFutureStructI32) {
        `returnValue` = other.`returnValue`
        `callStatus` = other.`callStatus`
    }

}
internal interface UniffiForeignFutureCompleteI32 : com.sun.jna.Callback {
    fun callback(`callbackData`: Long,`result`: UniffiForeignFutureStructI32.UniffiByValue,)
}
@Structure.FieldOrder("returnValue", "callStatus")
internal open class UniffiForeignFutureStructU64(
    @JvmField internal var `returnValue`: Long = 0.toLong(),
    @JvmField internal var `callStatus`: UniffiRustCallStatus.ByValue = UniffiRustCallStatus.ByValue(),
) : Structure() {
    class UniffiByValue(
        `returnValue`: Long = 0.toLong(),
        `callStatus`: UniffiRustCallStatus.ByValue = UniffiRustCallStatus.ByValue(),
    ): UniffiForeignFutureStructU64(`returnValue`,`callStatus`,), Structure.ByValue

   internal fun uniffiSetValue(other: UniffiForeignFutureStructU64) {
        `returnValue` = other.`returnValue`
        `callStatus` = other.`callStatus`
    }

}
internal interface UniffiForeignFutureCompleteU64 : com.sun.jna.Callback {
    fun callback(`callbackData`: Long,`result`: UniffiForeignFutureStructU64.UniffiByValue,)
}
@Structure.FieldOrder("returnValue", "callStatus")
internal open class UniffiForeignFutureStructI64(
    @JvmField internal var `returnValue`: Long = 0.toLong(),
    @JvmField internal var `callStatus`: UniffiRustCallStatus.ByValue = UniffiRustCallStatus.ByValue(),
) : Structure() {
    class UniffiByValue(
        `returnValue`: Long = 0.toLong(),
        `callStatus`: UniffiRustCallStatus.ByValue = UniffiRustCallStatus.ByValue(),
    ): UniffiForeignFutureStructI64(`returnValue`,`callStatus`,), Structure.ByValue

   internal fun uniffiSetValue(other: UniffiForeignFutureStructI64) {
        `returnValue` = other.`returnValue`
        `callStatus` = other.`callStatus`
    }

}
internal interface UniffiForeignFutureCompleteI64 : com.sun.jna.Callback {
    fun callback(`callbackData`: Long,`result`: UniffiForeignFutureStructI64.UniffiByValue,)
}
@Structure.FieldOrder("returnValue", "callStatus")
internal open class UniffiForeignFutureStructF32(
    @JvmField internal var `returnValue`: Float = 0.0f,
    @JvmField internal var `callStatus`: UniffiRustCallStatus.ByValue = UniffiRustCallStatus.ByValue(),
) : Structure() {
    class UniffiByValue(
        `returnValue`: Float = 0.0f,
        `callStatus`: UniffiRustCallStatus.ByValue = UniffiRustCallStatus.ByValue(),
    ): UniffiForeignFutureStructF32(`returnValue`,`callStatus`,), Structure.ByValue

   internal fun uniffiSetValue(other: UniffiForeignFutureStructF32) {
        `returnValue` = other.`returnValue`
        `callStatus` = other.`callStatus`
    }

}
internal interface UniffiForeignFutureCompleteF32 : com.sun.jna.Callback {
    fun callback(`callbackData`: Long,`result`: UniffiForeignFutureStructF32.UniffiByValue,)
}
@Structure.FieldOrder("returnValue", "callStatus")
internal open class UniffiForeignFutureStructF64(
    @JvmField internal var `returnValue`: Double = 0.0,
    @JvmField internal var `callStatus`: UniffiRustCallStatus.ByValue = UniffiRustCallStatus.ByValue(),
) : Structure() {
    class UniffiByValue(
        `returnValue`: Double = 0.0,
        `callStatus`: UniffiRustCallStatus.ByValue = UniffiRustCallStatus.ByValue(),
    ): UniffiForeignFutureStructF64(`returnValue`,`callStatus`,), Structure.ByValue

   internal fun uniffiSetValue(other: UniffiForeignFutureStructF64) {
        `returnValue` = other.`returnValue`
        `callStatus` = other.`callStatus`
    }

}
internal interface UniffiForeignFutureCompleteF64 : com.sun.jna.Callback {
    fun callback(`callbackData`: Long,`result`: UniffiForeignFutureStructF64.UniffiByValue,)
}
@Structure.FieldOrder("returnValue", "callStatus")
internal open class UniffiForeignFutureStructPointer(
    @JvmField internal var `returnValue`: Pointer = Pointer.NULL,
    @JvmField internal var `callStatus`: UniffiRustCallStatus.ByValue = UniffiRustCallStatus.ByValue(),
) : Structure() {
    class UniffiByValue(
        `returnValue`: Pointer = Pointer.NULL,
        `callStatus`: UniffiRustCallStatus.ByValue = UniffiRustCallStatus.ByValue(),
    ): UniffiForeignFutureStructPointer(`returnValue`,`callStatus`,), Structure.ByValue

   internal fun uniffiSetValue(other: UniffiForeignFutureStructPointer) {
        `returnValue` = other.`returnValue`
        `callStatus` = other.`callStatus`
    }

}
internal interface UniffiForeignFutureCompletePointer : com.sun.jna.Callback {
    fun callback(`callbackData`: Long,`result`: UniffiForeignFutureStructPointer.UniffiByValue,)
}
@Structure.FieldOrder("returnValue", "callStatus")
internal open class UniffiForeignFutureStructRustBuffer(
    @JvmField internal var `returnValue`: RustBuffer.ByValue = RustBuffer.ByValue(),
    @JvmField internal var `callStatus`: UniffiRustCallStatus.ByValue = UniffiRustCallStatus.ByValue(),
) : Structure() {
    class UniffiByValue(
        `returnValue`: RustBuffer.ByValue = RustBuffer.ByValue(),
        `callStatus`: UniffiRustCallStatus.ByValue = UniffiRustCallStatus.ByValue(),
    ): UniffiForeignFutureStructRustBuffer(`returnValue`,`callStatus`,), Structure.ByValue

   internal fun uniffiSetValue(other: UniffiForeignFutureStructRustBuffer) {
        `returnValue` = other.`returnValue`
        `callStatus` = other.`callStatus`
    }

}
internal interface UniffiForeignFutureCompleteRustBuffer : com.sun.jna.Callback {
    fun callback(`callbackData`: Long,`result`: UniffiForeignFutureStructRustBuffer.UniffiByValue,)
}
@Structure.FieldOrder("callStatus")
internal open class UniffiForeignFutureStructVoid(
    @JvmField internal var `callStatus`: UniffiRustCallStatus.ByValue = UniffiRustCallStatus.ByValue(),
) : Structure() {
    class UniffiByValue(
        `callStatus`: UniffiRustCallStatus.ByValue = UniffiRustCallStatus.ByValue(),
    ): UniffiForeignFutureStructVoid(`callStatus`,), Structure.ByValue

   internal fun uniffiSetValue(other: UniffiForeignFutureStructVoid) {
        `callStatus` = other.`callStatus`
    }

}
internal interface UniffiForeignFutureCompleteVoid : com.sun.jna.Callback {
    fun callback(`callbackData`: Long,`result`: UniffiForeignFutureStructVoid.UniffiByValue,)
}
internal interface UniffiCallbackInterfaceZenCustomNodeCallbackMethod0 : com.sun.jna.Callback {
    fun callback(`uniffiHandle`: Long,`key`: RustBuffer.ByValue,`uniffiFutureCallback`: UniffiForeignFutureCompleteRustBuffer,`uniffiCallbackData`: Long,`uniffiOutReturn`: UniffiForeignFuture,)
}
internal interface UniffiCallbackInterfaceZenDecisionLoaderCallbackMethod0 : com.sun.jna.Callback {
    fun callback(`uniffiHandle`: Long,`key`: RustBuffer.ByValue,`uniffiFutureCallback`: UniffiForeignFutureCompleteRustBuffer,`uniffiCallbackData`: Long,`uniffiOutReturn`: UniffiForeignFuture,)
}
@Structure.FieldOrder("handle", "uniffiFree")
internal open class UniffiVTableCallbackInterfaceZenCustomNodeCallback(
    @JvmField internal var `handle`: UniffiCallbackInterfaceZenCustomNodeCallbackMethod0? = null,
    @JvmField internal var `uniffiFree`: UniffiCallbackInterfaceFree? = null,
) : Structure() {
    class UniffiByValue(
        `handle`: UniffiCallbackInterfaceZenCustomNodeCallbackMethod0? = null,
        `uniffiFree`: UniffiCallbackInterfaceFree? = null,
    ): UniffiVTableCallbackInterfaceZenCustomNodeCallback(`handle`,`uniffiFree`,), Structure.ByValue

   internal fun uniffiSetValue(other: UniffiVTableCallbackInterfaceZenCustomNodeCallback) {
        `handle` = other.`handle`
        `uniffiFree` = other.`uniffiFree`
    }

}
@Structure.FieldOrder("load", "uniffiFree")
internal open class UniffiVTableCallbackInterfaceZenDecisionLoaderCallback(
    @JvmField internal var `load`: UniffiCallbackInterfaceZenDecisionLoaderCallbackMethod0? = null,
    @JvmField internal var `uniffiFree`: UniffiCallbackInterfaceFree? = null,
) : Structure() {
    class UniffiByValue(
        `load`: UniffiCallbackInterfaceZenDecisionLoaderCallbackMethod0? = null,
        `uniffiFree`: UniffiCallbackInterfaceFree? = null,
    ): UniffiVTableCallbackInterfaceZenDecisionLoaderCallback(`load`,`uniffiFree`,), Structure.ByValue

   internal fun uniffiSetValue(other: UniffiVTableCallbackInterfaceZenDecisionLoaderCallback) {
        `load` = other.`load`
        `uniffiFree` = other.`uniffiFree`
    }

}
































































































// For large crates we prevent `MethodTooLargeException` (see #2340)
// N.B. the name of the extension is very misleading, since it is 
// rather `InterfaceTooLargeException`, caused by too many methods 
// in the interface for large crates.
//
// By splitting the otherwise huge interface into two parts
// * UniffiLib 
// * IntegrityCheckingUniffiLib (this)
// we allow for ~2x as many methods in the UniffiLib interface.
// 
// The `ffi_uniffi_contract_version` method and all checksum methods are put 
// into `IntegrityCheckingUniffiLib` and these methods are called only once,
// when the library is loaded.
internal interface IntegrityCheckingUniffiLib : Library {
    // Integrity check functions only
    fun uniffi_zen_uniffi_checksum_func_evaluate_expression(
): Short
fun uniffi_zen_uniffi_checksum_func_evaluate_unary_expression(
): Short
fun uniffi_zen_uniffi_checksum_func_override_config(
): Short
fun uniffi_zen_uniffi_checksum_method_zendecision_evaluate(
): Short
fun uniffi_zen_uniffi_checksum_method_zendecision_validate(
): Short
fun uniffi_zen_uniffi_checksum_method_zenengine_create_decision(
): Short
fun uniffi_zen_uniffi_checksum_method_zenengine_evaluate(
): Short
fun uniffi_zen_uniffi_checksum_method_zenengine_get_decision(
): Short
fun uniffi_zen_uniffi_checksum_method_zenexpression_evaluate(
): Short
fun uniffi_zen_uniffi_checksum_method_zenexpressionunary_evaluate(
): Short
fun uniffi_zen_uniffi_checksum_constructor_zenengine_new(
): Short
fun uniffi_zen_uniffi_checksum_constructor_zenexpression_compile(
): Short
fun uniffi_zen_uniffi_checksum_constructor_zenexpressionunary_compile(
): Short
fun uniffi_zen_uniffi_checksum_method_zencustomnodecallback_handle(
): Short
fun uniffi_zen_uniffi_checksum_method_zendecisionloadercallback_load(
): Short
fun ffi_zen_uniffi_uniffi_contract_version(
): Int

}

// A JNA Library to expose the extern-C FFI definitions.
// This is an implementation detail which will be called internally by the public API.
internal interface UniffiLib : Library {
    companion object {
        internal val INSTANCE: UniffiLib by lazy {
            val componentName = "zen_uniffi"
            // For large crates we prevent `MethodTooLargeException` (see #2340)
            // N.B. the name of the extension is very misleading, since it is 
            // rather `InterfaceTooLargeException`, caused by too many methods 
            // in the interface for large crates.
            //
            // By splitting the otherwise huge interface into two parts
            // * UniffiLib (this)
            // * IntegrityCheckingUniffiLib
            // And all checksum methods are put into `IntegrityCheckingUniffiLib`
            // we allow for ~2x as many methods in the UniffiLib interface.
            // 
            // Thus we first load the library with `loadIndirect` as `IntegrityCheckingUniffiLib`
            // so that we can (optionally!) call `uniffiCheckApiChecksums`...
            loadIndirect<IntegrityCheckingUniffiLib>(componentName)
                .also { lib: IntegrityCheckingUniffiLib ->
                    uniffiCheckContractApiVersion(lib)
                    uniffiCheckApiChecksums(lib)
                }
            // ... and then we load the library as `UniffiLib`
            // N.B. we cannot use `loadIndirect` once and then try to cast it to `UniffiLib`
            // => results in `java.lang.ClassCastException: com.sun.proxy.$Proxy cannot be cast to ...`
            // error. So we must call `loadIndirect` twice. For crates large enough
            // to trigger this issue, the performance impact is negligible, running on
            // a macOS M1 machine the `loadIndirect` call takes ~50ms.
            val lib = loadIndirect<UniffiLib>(componentName)
            // No need to check the contract version and checksums, since 
            // we already did that with `IntegrityCheckingUniffiLib` above.
            uniffiCallbackInterfaceZenCustomNodeCallback.register(lib)
            uniffiCallbackInterfaceZenDecisionLoaderCallback.register(lib)
            // Loading of library with integrity check done.
            lib
        }
        
        // The Cleaner for the whole library
        internal val CLEANER: UniffiCleaner by lazy {
            UniffiCleaner.create()
        }
    }

    // FFI functions
    fun uniffi_zen_uniffi_fn_clone_zendecision(`ptr`: Pointer,uniffi_out_err: UniffiRustCallStatus, 
): Pointer
fun uniffi_zen_uniffi_fn_free_zendecision(`ptr`: Pointer,uniffi_out_err: UniffiRustCallStatus, 
): Unit
fun uniffi_zen_uniffi_fn_method_zendecision_evaluate(`ptr`: Pointer,`context`: RustBuffer.ByValue,`options`: RustBuffer.ByValue,
): Long
fun uniffi_zen_uniffi_fn_method_zendecision_validate(`ptr`: Pointer,uniffi_out_err: UniffiRustCallStatus, 
): Unit
fun uniffi_zen_uniffi_fn_clone_zenengine(`ptr`: Pointer,uniffi_out_err: UniffiRustCallStatus, 
): Pointer
fun uniffi_zen_uniffi_fn_free_zenengine(`ptr`: Pointer,uniffi_out_err: UniffiRustCallStatus, 
): Unit
fun uniffi_zen_uniffi_fn_constructor_zenengine_new(`loader`: RustBuffer.ByValue,`customNode`: RustBuffer.ByValue,uniffi_out_err: UniffiRustCallStatus, 
): Pointer
fun uniffi_zen_uniffi_fn_method_zenengine_create_decision(`ptr`: Pointer,`content`: RustBuffer.ByValue,uniffi_out_err: UniffiRustCallStatus, 
): Pointer
fun uniffi_zen_uniffi_fn_method_zenengine_evaluate(`ptr`: Pointer,`key`: RustBuffer.ByValue,`context`: RustBuffer.ByValue,`options`: RustBuffer.ByValue,
): Long
fun uniffi_zen_uniffi_fn_method_zenengine_get_decision(`ptr`: Pointer,`key`: RustBuffer.ByValue,
): Long
fun uniffi_zen_uniffi_fn_clone_zenexpression(`ptr`: Pointer,uniffi_out_err: UniffiRustCallStatus, 
): Pointer
fun uniffi_zen_uniffi_fn_free_zenexpression(`ptr`: Pointer,uniffi_out_err: UniffiRustCallStatus, 
): Unit
fun uniffi_zen_uniffi_fn_constructor_zenexpression_compile(`expression`: RustBuffer.ByValue,uniffi_out_err: UniffiRustCallStatus, 
): Pointer
fun uniffi_zen_uniffi_fn_method_zenexpression_evaluate(`ptr`: Pointer,`context`: RustBuffer.ByValue,uniffi_out_err: UniffiRustCallStatus, 
): RustBuffer.ByValue
fun uniffi_zen_uniffi_fn_clone_zenexpressionunary(`ptr`: Pointer,uniffi_out_err: UniffiRustCallStatus, 
): Pointer
fun uniffi_zen_uniffi_fn_free_zenexpressionunary(`ptr`: Pointer,uniffi_out_err: UniffiRustCallStatus, 
): Unit
fun uniffi_zen_uniffi_fn_constructor_zenexpressionunary_compile(`expression`: RustBuffer.ByValue,uniffi_out_err: UniffiRustCallStatus, 
): Pointer
fun uniffi_zen_uniffi_fn_method_zenexpressionunary_evaluate(`ptr`: Pointer,`context`: RustBuffer.ByValue,uniffi_out_err: UniffiRustCallStatus, 
): Byte
fun uniffi_zen_uniffi_fn_init_callback_vtable_zencustomnodecallback(`vtable`: UniffiVTableCallbackInterfaceZenCustomNodeCallback,
): Unit
fun uniffi_zen_uniffi_fn_init_callback_vtable_zendecisionloadercallback(`vtable`: UniffiVTableCallbackInterfaceZenDecisionLoaderCallback,
): Unit
fun uniffi_zen_uniffi_fn_func_evaluate_expression(`expression`: RustBuffer.ByValue,`context`: RustBuffer.ByValue,uniffi_out_err: UniffiRustCallStatus, 
): RustBuffer.ByValue
fun uniffi_zen_uniffi_fn_func_evaluate_unary_expression(`expression`: RustBuffer.ByValue,`context`: RustBuffer.ByValue,uniffi_out_err: UniffiRustCallStatus, 
): Byte
fun uniffi_zen_uniffi_fn_func_override_config(`config`: RustBuffer.ByValue,uniffi_out_err: UniffiRustCallStatus, 
): Unit
fun ffi_zen_uniffi_rustbuffer_alloc(`size`: Long,uniffi_out_err: UniffiRustCallStatus, 
): RustBuffer.ByValue
fun ffi_zen_uniffi_rustbuffer_from_bytes(`bytes`: ForeignBytes.ByValue,uniffi_out_err: UniffiRustCallStatus, 
): RustBuffer.ByValue
fun ffi_zen_uniffi_rustbuffer_free(`buf`: RustBuffer.ByValue,uniffi_out_err: UniffiRustCallStatus, 
): Unit
fun ffi_zen_uniffi_rustbuffer_reserve(`buf`: RustBuffer.ByValue,`additional`: Long,uniffi_out_err: UniffiRustCallStatus, 
): RustBuffer.ByValue
fun ffi_zen_uniffi_rust_future_poll_u8(`handle`: Long,`callback`: UniffiRustFutureContinuationCallback,`callbackData`: Long,
): Unit
fun ffi_zen_uniffi_rust_future_cancel_u8(`handle`: Long,
): Unit
fun ffi_zen_uniffi_rust_future_free_u8(`handle`: Long,
): Unit
fun ffi_zen_uniffi_rust_future_complete_u8(`handle`: Long,uniffi_out_err: UniffiRustCallStatus, 
): Byte
fun ffi_zen_uniffi_rust_future_poll_i8(`handle`: Long,`callback`: UniffiRustFutureContinuationCallback,`callbackData`: Long,
): Unit
fun ffi_zen_uniffi_rust_future_cancel_i8(`handle`: Long,
): Unit
fun ffi_zen_uniffi_rust_future_free_i8(`handle`: Long,
): Unit
fun ffi_zen_uniffi_rust_future_complete_i8(`handle`: Long,uniffi_out_err: UniffiRustCallStatus, 
): Byte
fun ffi_zen_uniffi_rust_future_poll_u16(`handle`: Long,`callback`: UniffiRustFutureContinuationCallback,`callbackData`: Long,
): Unit
fun ffi_zen_uniffi_rust_future_cancel_u16(`handle`: Long,
): Unit
fun ffi_zen_uniffi_rust_future_free_u16(`handle`: Long,
): Unit
fun ffi_zen_uniffi_rust_future_complete_u16(`handle`: Long,uniffi_out_err: UniffiRustCallStatus, 
): Short
fun ffi_zen_uniffi_rust_future_poll_i16(`handle`: Long,`callback`: UniffiRustFutureContinuationCallback,`callbackData`: Long,
): Unit
fun ffi_zen_uniffi_rust_future_cancel_i16(`handle`: Long,
): Unit
fun ffi_zen_uniffi_rust_future_free_i16(`handle`: Long,
): Unit
fun ffi_zen_uniffi_rust_future_complete_i16(`handle`: Long,uniffi_out_err: UniffiRustCallStatus, 
): Short
fun ffi_zen_uniffi_rust_future_poll_u32(`handle`: Long,`callback`: UniffiRustFutureContinuationCallback,`callbackData`: Long,
): Unit
fun ffi_zen_uniffi_rust_future_cancel_u32(`handle`: Long,
): Unit
fun ffi_zen_uniffi_rust_future_free_u32(`handle`: Long,
): Unit
fun ffi_zen_uniffi_rust_future_complete_u32(`handle`: Long,uniffi_out_err: UniffiRustCallStatus, 
): Int
fun ffi_zen_uniffi_rust_future_poll_i32(`handle`: Long,`callback`: UniffiRustFutureContinuationCallback,`callbackData`: Long,
): Unit
fun ffi_zen_uniffi_rust_future_cancel_i32(`handle`: Long,
): Unit
fun ffi_zen_uniffi_rust_future_free_i32(`handle`: Long,
): Unit
fun ffi_zen_uniffi_rust_future_complete_i32(`handle`: Long,uniffi_out_err: UniffiRustCallStatus, 
): Int
fun ffi_zen_uniffi_rust_future_poll_u64(`handle`: Long,`callback`: UniffiRustFutureContinuationCallback,`callbackData`: Long,
): Unit
fun ffi_zen_uniffi_rust_future_cancel_u64(`handle`: Long,
): Unit
fun ffi_zen_uniffi_rust_future_free_u64(`handle`: Long,
): Unit
fun ffi_zen_uniffi_rust_future_complete_u64(`handle`: Long,uniffi_out_err: UniffiRustCallStatus, 
): Long
fun ffi_zen_uniffi_rust_future_poll_i64(`handle`: Long,`callback`: UniffiRustFutureContinuationCallback,`callbackData`: Long,
): Unit
fun ffi_zen_uniffi_rust_future_cancel_i64(`handle`: Long,
): Unit
fun ffi_zen_uniffi_rust_future_free_i64(`handle`: Long,
): Unit
fun ffi_zen_uniffi_rust_future_complete_i64(`handle`: Long,uniffi_out_err: UniffiRustCallStatus, 
): Long
fun ffi_zen_uniffi_rust_future_poll_f32(`handle`: Long,`callback`: UniffiRustFutureContinuationCallback,`callbackData`: Long,
): Unit
fun ffi_zen_uniffi_rust_future_cancel_f32(`handle`: Long,
): Unit
fun ffi_zen_uniffi_rust_future_free_f32(`handle`: Long,
): Unit
fun ffi_zen_uniffi_rust_future_complete_f32(`handle`: Long,uniffi_out_err: UniffiRustCallStatus, 
): Float
fun ffi_zen_uniffi_rust_future_poll_f64(`handle`: Long,`callback`: UniffiRustFutureContinuationCallback,`callbackData`: Long,
): Unit
fun ffi_zen_uniffi_rust_future_cancel_f64(`handle`: Long,
): Unit
fun ffi_zen_uniffi_rust_future_free_f64(`handle`: Long,
): Unit
fun ffi_zen_uniffi_rust_future_complete_f64(`handle`: Long,uniffi_out_err: UniffiRustCallStatus, 
): Double
fun ffi_zen_uniffi_rust_future_poll_pointer(`handle`: Long,`callback`: UniffiRustFutureContinuationCallback,`callbackData`: Long,
): Unit
fun ffi_zen_uniffi_rust_future_cancel_pointer(`handle`: Long,
): Unit
fun ffi_zen_uniffi_rust_future_free_pointer(`handle`: Long,
): Unit
fun ffi_zen_uniffi_rust_future_complete_pointer(`handle`: Long,uniffi_out_err: UniffiRustCallStatus, 
): Pointer
fun ffi_zen_uniffi_rust_future_poll_rust_buffer(`handle`: Long,`callback`: UniffiRustFutureContinuationCallback,`callbackData`: Long,
): Unit
fun ffi_zen_uniffi_rust_future_cancel_rust_buffer(`handle`: Long,
): Unit
fun ffi_zen_uniffi_rust_future_free_rust_buffer(`handle`: Long,
): Unit
fun ffi_zen_uniffi_rust_future_complete_rust_buffer(`handle`: Long,uniffi_out_err: UniffiRustCallStatus, 
): RustBuffer.ByValue
fun ffi_zen_uniffi_rust_future_poll_void(`handle`: Long,`callback`: UniffiRustFutureContinuationCallback,`callbackData`: Long,
): Unit
fun ffi_zen_uniffi_rust_future_cancel_void(`handle`: Long,
): Unit
fun ffi_zen_uniffi_rust_future_free_void(`handle`: Long,
): Unit
fun ffi_zen_uniffi_rust_future_complete_void(`handle`: Long,uniffi_out_err: UniffiRustCallStatus, 
): Unit

}

private fun uniffiCheckContractApiVersion(lib: IntegrityCheckingUniffiLib) {
    // Get the bindings contract version from our ComponentInterface
    val bindings_contract_version = 29
    // Get the scaffolding contract version by calling the into the dylib
    val scaffolding_contract_version = lib.ffi_zen_uniffi_uniffi_contract_version()
    if (bindings_contract_version != scaffolding_contract_version) {
        throw RuntimeException("UniFFI contract version mismatch: try cleaning and rebuilding your project")
    }
}
@Suppress("UNUSED_PARAMETER")
private fun uniffiCheckApiChecksums(lib: IntegrityCheckingUniffiLib) {
    if (lib.uniffi_zen_uniffi_checksum_func_evaluate_expression() != 46112.toShort()) {
        throw RuntimeException("UniFFI API checksum mismatch: try cleaning and rebuilding your project")
    }
    if (lib.uniffi_zen_uniffi_checksum_func_evaluate_unary_expression() != 5920.toShort()) {
        throw RuntimeException("UniFFI API checksum mismatch: try cleaning and rebuilding your project")
    }
    if (lib.uniffi_zen_uniffi_checksum_func_override_config() != 10824.toShort()) {
        throw RuntimeException("UniFFI API checksum mismatch: try cleaning and rebuilding your project")
    }
    if (lib.uniffi_zen_uniffi_checksum_method_zendecision_evaluate() != 48259.toShort()) {
        throw RuntimeException("UniFFI API checksum mismatch: try cleaning and rebuilding your project")
    }
    if (lib.uniffi_zen_uniffi_checksum_method_zendecision_validate() != 18546.toShort()) {
        throw RuntimeException("UniFFI API checksum mismatch: try cleaning and rebuilding your project")
    }
    if (lib.uniffi_zen_uniffi_checksum_method_zenengine_create_decision() != 62504.toShort()) {
        throw RuntimeException("UniFFI API checksum mismatch: try cleaning and rebuilding your project")
    }
    if (lib.uniffi_zen_uniffi_checksum_method_zenengine_evaluate() != 59161.toShort()) {
        throw RuntimeException("UniFFI API checksum mismatch: try cleaning and rebuilding your project")
    }
    if (lib.uniffi_zen_uniffi_checksum_method_zenengine_get_decision() != 30326.toShort()) {
        throw RuntimeException("UniFFI API checksum mismatch: try cleaning and rebuilding your project")
    }
    if (lib.uniffi_zen_uniffi_checksum_method_zenexpression_evaluate() != 47446.toShort()) {
        throw RuntimeException("UniFFI API checksum mismatch: try cleaning and rebuilding your project")
    }
    if (lib.uniffi_zen_uniffi_checksum_method_zenexpressionunary_evaluate() != 54979.toShort()) {
        throw RuntimeException("UniFFI API checksum mismatch: try cleaning and rebuilding your project")
    }
    if (lib.uniffi_zen_uniffi_checksum_constructor_zenengine_new() != 62598.toShort()) {
        throw RuntimeException("UniFFI API checksum mismatch: try cleaning and rebuilding your project")
    }
    if (lib.uniffi_zen_uniffi_checksum_constructor_zenexpression_compile() != 36953.toShort()) {
        throw RuntimeException("UniFFI API checksum mismatch: try cleaning and rebuilding your project")
    }
    if (lib.uniffi_zen_uniffi_checksum_constructor_zenexpressionunary_compile() != 16181.toShort()) {
        throw RuntimeException("UniFFI API checksum mismatch: try cleaning and rebuilding your project")
    }
    if (lib.uniffi_zen_uniffi_checksum_method_zencustomnodecallback_handle() != 54882.toShort()) {
        throw RuntimeException("UniFFI API checksum mismatch: try cleaning and rebuilding your project")
    }
    if (lib.uniffi_zen_uniffi_checksum_method_zendecisionloadercallback_load() != 42929.toShort()) {
        throw RuntimeException("UniFFI API checksum mismatch: try cleaning and rebuilding your project")
    }
}

/**
 * @suppress
 */
public fun uniffiEnsureInitialized() {
    UniffiLib.INSTANCE
}

// Async support
// Async return type handlers

internal const val UNIFFI_RUST_FUTURE_POLL_READY = 0.toByte()
internal const val UNIFFI_RUST_FUTURE_POLL_MAYBE_READY = 1.toByte()

internal val uniffiContinuationHandleMap = UniffiHandleMap<CancellableContinuation<Byte>>()

// FFI type for Rust future continuations
internal object uniffiRustFutureContinuationCallbackImpl: UniffiRustFutureContinuationCallback {
    override fun callback(data: Long, pollResult: Byte) {
        uniffiContinuationHandleMap.remove(data).resume(pollResult)
    }
}

internal suspend fun<T, F, E: kotlin.Exception> uniffiRustCallAsync(
    rustFuture: Long,
    pollFunc: (Long, UniffiRustFutureContinuationCallback, Long) -> Unit,
    completeFunc: (Long, UniffiRustCallStatus) -> F,
    freeFunc: (Long) -> Unit,
    liftFunc: (F) -> T,
    errorHandler: UniffiRustCallStatusErrorHandler<E>
): T {
    try {
        do {
            val pollResult = suspendCancellableCoroutine<Byte> { continuation ->
                pollFunc(
                    rustFuture,
                    uniffiRustFutureContinuationCallbackImpl,
                    uniffiContinuationHandleMap.insert(continuation)
                )
            }
        } while (pollResult != UNIFFI_RUST_FUTURE_POLL_READY);

        return liftFunc(
            uniffiRustCallWithError(errorHandler, { status -> completeFunc(rustFuture, status) })
        )
    } finally {
        freeFunc(rustFuture)
    }
}
internal inline fun<T> uniffiTraitInterfaceCallAsync(
    crossinline makeCall: suspend () -> T,
    crossinline handleSuccess: (T) -> Unit,
    crossinline handleError: (UniffiRustCallStatus.ByValue) -> Unit,
): UniffiForeignFuture {
    // Using `GlobalScope` is labeled as a "delicate API" and generally discouraged in Kotlin programs, since it breaks structured concurrency.
    // However, our parent task is a Rust future, so we're going to need to break structure concurrency in any case.
    //
    // Uniffi does its best to support structured concurrency across the FFI.
    // If the Rust future is dropped, `uniffiForeignFutureFreeImpl` is called, which will cancel the Kotlin coroutine if it's still running.
    @OptIn(DelicateCoroutinesApi::class)
    val job = GlobalScope.launch coroutineBlock@ {
        // Note: it's important we call either `handleSuccess` or `handleError` exactly once.  Each
        // call consumes an Arc reference, which means there should be no possibility of a double
        // call.  The following code is structured so that will will never call both `handleSuccess`
        // and `handleError`, even in the face of weird exceptions.
        //
        // In extreme circumstances we may not call either, for example if we fail to make the JNA
        // call to `handleSuccess`.  This means we will leak the Arc reference, which is better than
        // double-freeing it.
        val callResult = try {
            makeCall()
        } catch(e: kotlin.Exception) {
            handleError(
                UniffiRustCallStatus.create(
                    UNIFFI_CALL_UNEXPECTED_ERROR,
                    FfiConverterString.lower(e.toString()),
                )
            )
            return@coroutineBlock
        }
        handleSuccess(callResult)
    }
    val handle = uniffiForeignFutureHandleMap.insert(job)
    return UniffiForeignFuture(handle, uniffiForeignFutureFreeImpl)
}

internal inline fun<T, reified E: Throwable> uniffiTraitInterfaceCallAsyncWithError(
    crossinline makeCall: suspend () -> T,
    crossinline handleSuccess: (T) -> Unit,
    crossinline handleError: (UniffiRustCallStatus.ByValue) -> Unit,
    crossinline lowerError: (E) -> RustBuffer.ByValue,
): UniffiForeignFuture {
    // See uniffiTraitInterfaceCallAsync for details on `DelicateCoroutinesApi`
    @OptIn(DelicateCoroutinesApi::class)
    val job = GlobalScope.launch coroutineBlock@ {
        // See the note in uniffiTraitInterfaceCallAsync for details on `handleSuccess` and
        // `handleError`.
        val callResult = try {
            makeCall()
        } catch(e: kotlin.Exception) {
            if (e is E) {
                handleError(
                    UniffiRustCallStatus.create(
                        UNIFFI_CALL_ERROR,
                        lowerError(e),
                    )
                )
            } else {
                handleError(
                    UniffiRustCallStatus.create(
                        UNIFFI_CALL_UNEXPECTED_ERROR,
                        FfiConverterString.lower(e.toString()),
                    )
                )
            }
            return@coroutineBlock
        }
        handleSuccess(callResult)
    }
    val handle = uniffiForeignFutureHandleMap.insert(job)
    return UniffiForeignFuture(handle, uniffiForeignFutureFreeImpl)
}

internal val uniffiForeignFutureHandleMap = UniffiHandleMap<Job>()

internal object uniffiForeignFutureFreeImpl: UniffiForeignFutureFree {
    override fun callback(handle: Long) {
        val job = uniffiForeignFutureHandleMap.remove(handle)
        if (!job.isCompleted) {
            job.cancel()
        }
    }
}

// For testing
public fun uniffiForeignFutureHandleCount() = uniffiForeignFutureHandleMap.size

// Public interface members begin here.


// Interface implemented by anything that can contain an object reference.
//
// Such types expose a `destroy()` method that must be called to cleanly
// dispose of the contained objects. Failure to call this method may result
// in memory leaks.
//
// The easiest way to ensure this method is called is to use the `.use`
// helper method to execute a block and destroy the object at the end.
interface Disposable {
    fun destroy()
    companion object {
        fun destroy(vararg args: Any?) {
            for (arg in args) {
                when (arg) {
                    is Disposable -> arg.destroy()
                    is ArrayList<*> -> {
                        for (idx in arg.indices) {
                            val element = arg[idx]
                            if (element is Disposable) {
                                element.destroy()
                            }
                        }
                    }
                    is Map<*, *> -> {
                        for (element in arg.values) {
                            if (element is Disposable) {
                                element.destroy()
                            }
                        }
                    }
                    is Iterable<*> -> {
                        for (element in arg) {
                            if (element is Disposable) {
                                element.destroy()
                            }
                        }
                    }
                }
            }
        }
    }
}

/**
 * @suppress
 */
inline fun <T : Disposable?, R> T.use(block: (T) -> R) =
    try {
        block(this)
    } finally {
        try {
            // N.B. our implementation is on the nullable type `Disposable?`.
            this?.destroy()
        } catch (e: Throwable) {
            // swallow
        }
    }

/** 
 * Used to instantiate an interface without an actual pointer, for fakes in tests, mostly.
 *
 * @suppress
 * */
object NoPointer// Magic number for the Rust proxy to call using the same mechanism as every other method,
// to free the callback once it's dropped by Rust.
internal const val IDX_CALLBACK_FREE = 0
// Callback return codes
internal const val UNIFFI_CALLBACK_SUCCESS = 0
internal const val UNIFFI_CALLBACK_ERROR = 1
internal const val UNIFFI_CALLBACK_UNEXPECTED_ERROR = 2

/**
 * @suppress
 */
public abstract class FfiConverterCallbackInterface<CallbackInterface: Any>: FfiConverter<CallbackInterface, Long> {
    internal val handleMap = UniffiHandleMap<CallbackInterface>()

    internal fun drop(handle: Long) {
        handleMap.remove(handle)
    }

    override fun lift(value: Long): CallbackInterface {
        return handleMap.get(value)
    }

    override fun read(buf: ByteBuffer) = lift(buf.getLong())

    override fun lower(value: CallbackInterface) = handleMap.insert(value)

    override fun allocationSize(value: CallbackInterface) = 8UL

    override fun write(value: CallbackInterface, buf: ByteBuffer) {
        buf.putLong(lower(value))
    }
}
/**
 * The cleaner interface for Object finalization code to run.
 * This is the entry point to any implementation that we're using.
 *
 * The cleaner registers objects and returns cleanables, so now we are
 * defining a `UniffiCleaner` with a `UniffiClenaer.Cleanable` to abstract the
 * different implmentations available at compile time.
 *
 * @suppress
 */
interface UniffiCleaner {
    interface Cleanable {
        fun clean()
    }

    fun register(value: Any, cleanUpTask: Runnable): UniffiCleaner.Cleanable

    companion object
}

// The fallback Jna cleaner, which is available for both Android, and the JVM.
private class UniffiJnaCleaner : UniffiCleaner {
    private val cleaner = com.sun.jna.internal.Cleaner.getCleaner()

    override fun register(value: Any, cleanUpTask: Runnable): UniffiCleaner.Cleanable =
        UniffiJnaCleanable(cleaner.register(value, cleanUpTask))
}

private class UniffiJnaCleanable(
    private val cleanable: com.sun.jna.internal.Cleaner.Cleanable,
) : UniffiCleaner.Cleanable {
    override fun clean() = cleanable.clean()
}


// We decide at uniffi binding generation time whether we were
// using Android or not.
// There are further runtime checks to chose the correct implementation
// of the cleaner.
private fun UniffiCleaner.Companion.create(): UniffiCleaner =
    try {
        // For safety's sake: if the library hasn't been run in android_cleaner = true
        // mode, but is being run on Android, then we still need to think about
        // Android API versions.
        // So we check if java.lang.ref.Cleaner is there, and use that…
        java.lang.Class.forName("java.lang.ref.Cleaner")
        JavaLangRefCleaner()
    } catch (e: ClassNotFoundException) {
        // … otherwise, fallback to the JNA cleaner.
        UniffiJnaCleaner()
    }

private class JavaLangRefCleaner : UniffiCleaner {
    val cleaner = java.lang.ref.Cleaner.create()

    override fun register(value: Any, cleanUpTask: Runnable): UniffiCleaner.Cleanable =
        JavaLangRefCleanable(cleaner.register(value, cleanUpTask))
}

private class JavaLangRefCleanable(
    val cleanable: java.lang.ref.Cleaner.Cleanable
) : UniffiCleaner.Cleanable {
    override fun clean() = cleanable.clean()
}

/**
 * @suppress
 */
public object FfiConverterUByte: FfiConverter<UByte, Byte> {
    override fun lift(value: Byte): UByte {
        return value.toUByte()
    }

    override fun read(buf: ByteBuffer): UByte {
        return lift(buf.get())
    }

    override fun lower(value: UByte): Byte {
        return value.toByte()
    }

    override fun allocationSize(value: UByte) = 1UL

    override fun write(value: UByte, buf: ByteBuffer) {
        buf.put(value.toByte())
    }
}

/**
 * @suppress
 */
public object FfiConverterUInt: FfiConverter<UInt, Int> {
    override fun lift(value: Int): UInt {
        return value.toUInt()
    }

    override fun read(buf: ByteBuffer): UInt {
        return lift(buf.getInt())
    }

    override fun lower(value: UInt): Int {
        return value.toInt()
    }

    override fun allocationSize(value: UInt) = 4UL

    override fun write(value: UInt, buf: ByteBuffer) {
        buf.putInt(value.toInt())
    }
}

/**
 * @suppress
 */
public object FfiConverterBoolean: FfiConverter<Boolean, Byte> {
    override fun lift(value: Byte): Boolean {
        return value.toInt() != 0
    }

    override fun read(buf: ByteBuffer): Boolean {
        return lift(buf.get())
    }

    override fun lower(value: Boolean): Byte {
        return if (value) 1.toByte() else 0.toByte()
    }

    override fun allocationSize(value: Boolean) = 1UL

    override fun write(value: Boolean, buf: ByteBuffer) {
        buf.put(lower(value))
    }
}

/**
 * @suppress
 */
public object FfiConverterString: FfiConverter<String, RustBuffer.ByValue> {
    // Note: we don't inherit from FfiConverterRustBuffer, because we use a
    // special encoding when lowering/lifting.  We can use `RustBuffer.len` to
    // store our length and avoid writing it out to the buffer.
    override fun lift(value: RustBuffer.ByValue): String {
        try {
            val byteArr = ByteArray(value.len.toInt())
            value.asByteBuffer()!!.get(byteArr)
            return byteArr.toString(Charsets.UTF_8)
        } finally {
            RustBuffer.free(value)
        }
    }

    override fun read(buf: ByteBuffer): String {
        val len = buf.getInt()
        val byteArr = ByteArray(len)
        buf.get(byteArr)
        return byteArr.toString(Charsets.UTF_8)
    }

    fun toUtf8(value: String): ByteBuffer {
        // Make sure we don't have invalid UTF-16, check for lone surrogates.
        return Charsets.UTF_8.newEncoder().run {
            onMalformedInput(CodingErrorAction.REPORT)
            encode(CharBuffer.wrap(value))
        }
    }

    override fun lower(value: String): RustBuffer.ByValue {
        val byteBuf = toUtf8(value)
        // Ideally we'd pass these bytes to `ffi_bytebuffer_from_bytes`, but doing so would require us
        // to copy them into a JNA `Memory`. So we might as well directly copy them into a `RustBuffer`.
        val rbuf = RustBuffer.alloc(byteBuf.limit().toULong())
        rbuf.asByteBuffer()!!.put(byteBuf)
        return rbuf
    }

    // We aren't sure exactly how many bytes our string will be once it's UTF-8
    // encoded.  Allocate 3 bytes per UTF-16 code unit which will always be
    // enough.
    override fun allocationSize(value: String): ULong {
        val sizeForLength = 4UL
        val sizeForString = value.length.toULong() * 3UL
        return sizeForLength + sizeForString
    }

    override fun write(value: String, buf: ByteBuffer) {
        val byteBuf = toUtf8(value)
        buf.putInt(byteBuf.limit())
        buf.put(byteBuf)
    }
}

/**
 * @suppress
 */
public object FfiConverterByteArray: FfiConverterRustBuffer<ByteArray> {
    override fun read(buf: ByteBuffer): ByteArray {
        val len = buf.getInt()
        val byteArr = ByteArray(len)
        buf.get(byteArr)
        return byteArr
    }
    override fun allocationSize(value: ByteArray): ULong {
        return 4UL + value.size.toULong()
    }
    override fun write(value: ByteArray, buf: ByteBuffer) {
        buf.putInt(value.size)
        buf.put(value)
    }
}


// This template implements a class for working with a Rust struct via a Pointer/Arc<T>
// to the live Rust struct on the other side of the FFI.
//
// Each instance implements core operations for working with the Rust `Arc<T>` and the
// Kotlin Pointer to work with the live Rust struct on the other side of the FFI.
//
// There's some subtlety here, because we have to be careful not to operate on a Rust
// struct after it has been dropped, and because we must expose a public API for freeing
// theq Kotlin wrapper object in lieu of reliable finalizers. The core requirements are:
//
//   * Each instance holds an opaque pointer to the underlying Rust struct.
//     Method calls need to read this pointer from the object's state and pass it in to
//     the Rust FFI.
//
//   * When an instance is no longer needed, its pointer should be passed to a
//     special destructor function provided by the Rust FFI, which will drop the
//     underlying Rust struct.
//
//   * Given an instance, calling code is expected to call the special
//     `destroy` method in order to free it after use, either by calling it explicitly
//     or by using a higher-level helper like the `use` method. Failing to do so risks
//     leaking the underlying Rust struct.
//
//   * We can't assume that calling code will do the right thing, and must be prepared
//     to handle Kotlin method calls executing concurrently with or even after a call to
//     `destroy`, and to handle multiple (possibly concurrent!) calls to `destroy`.
//
//   * We must never allow Rust code to operate on the underlying Rust struct after
//     the destructor has been called, and must never call the destructor more than once.
//     Doing so may trigger memory unsafety.
//
//   * To mitigate many of the risks of leaking memory and use-after-free unsafety, a `Cleaner`
//     is implemented to call the destructor when the Kotlin object becomes unreachable.
//     This is done in a background thread. This is not a panacea, and client code should be aware that
//      1. the thread may starve if some there are objects that have poorly performing
//     `drop` methods or do significant work in their `drop` methods.
//      2. the thread is shared across the whole library. This can be tuned by using `android_cleaner = true`,
//         or `android = true` in the [`kotlin` section of the `uniffi.toml` file](https://mozilla.github.io/uniffi-rs/kotlin/configuration.html).
//
// If we try to implement this with mutual exclusion on access to the pointer, there is the
// possibility of a race between a method call and a concurrent call to `destroy`:
//
//    * Thread A starts a method call, reads the value of the pointer, but is interrupted
//      before it can pass the pointer over the FFI to Rust.
//    * Thread B calls `destroy` and frees the underlying Rust struct.
//    * Thread A resumes, passing the already-read pointer value to Rust and triggering
//      a use-after-free.
//
// One possible solution would be to use a `ReadWriteLock`, with each method call taking
// a read lock (and thus allowed to run concurrently) and the special `destroy` method
// taking a write lock (and thus blocking on live method calls). However, we aim not to
// generate methods with any hidden blocking semantics, and a `destroy` method that might
// block if called incorrectly seems to meet that bar.
//
// So, we achieve our goals by giving each instance an associated `AtomicLong` counter to track
// the number of in-flight method calls, and an `AtomicBoolean` flag to indicate whether `destroy`
// has been called. These are updated according to the following rules:
//
//    * The initial value of the counter is 1, indicating a live object with no in-flight calls.
//      The initial value for the flag is false.
//
//    * At the start of each method call, we atomically check the counter.
//      If it is 0 then the underlying Rust struct has already been destroyed and the call is aborted.
//      If it is nonzero them we atomically increment it by 1 and proceed with the method call.
//
//    * At the end of each method call, we atomically decrement and check the counter.
//      If it has reached zero then we destroy the underlying Rust struct.
//
//    * When `destroy` is called, we atomically flip the flag from false to true.
//      If the flag was already true we silently fail.
//      Otherwise we atomically decrement and check the counter.
//      If it has reached zero then we destroy the underlying Rust struct.
//
// Astute readers may observe that this all sounds very similar to the way that Rust's `Arc<T>` works,
// and indeed it is, with the addition of a flag to guard against multiple calls to `destroy`.
//
// The overall effect is that the underlying Rust struct is destroyed only when `destroy` has been
// called *and* all in-flight method calls have completed, avoiding violating any of the expectations
// of the underlying Rust code.
//
// This makes a cleaner a better alternative to _not_ calling `destroy()` as
// and when the object is finished with, but the abstraction is not perfect: if the Rust object's `drop`
// method is slow, and/or there are many objects to cleanup, and it's on a low end Android device, then the cleaner
// thread may be starved, and the app will leak memory.
//
// In this case, `destroy`ing manually may be a better solution.
//
// The cleaner can live side by side with the manual calling of `destroy`. In the order of responsiveness, uniffi objects
// with Rust peers are reclaimed:
//
// 1. By calling the `destroy` method of the object, which calls `rustObject.free()`. If that doesn't happen:
// 2. When the object becomes unreachable, AND the Cleaner thread gets to call `rustObject.free()`. If the thread is starved then:
// 3. The memory is reclaimed when the process terminates.
//
// [1] https://stackoverflow.com/questions/24376768/can-java-finalize-an-object-when-it-is-still-in-scope/24380219
//


public interface ZenDecisionInterface {
    
    suspend fun `evaluate`(`context`: JsonBuffer, `options`: ZenEvaluateOptions?): ZenEngineResponse
    
    fun `validate`()
    
    companion object
}

open class ZenDecision: Disposable, AutoCloseable, ZenDecisionInterface
{

    constructor(pointer: Pointer) {
        this.pointer = pointer
        this.cleanable = UniffiLib.CLEANER.register(this, UniffiCleanAction(pointer))
    }

    /**
     * This constructor can be used to instantiate a fake object. Only used for tests. Any
     * attempt to actually use an object constructed this way will fail as there is no
     * connected Rust object.
     */
    @Suppress("UNUSED_PARAMETER")
    constructor(noPointer: NoPointer) {
        this.pointer = null
        this.cleanable = UniffiLib.CLEANER.register(this, UniffiCleanAction(pointer))
    }

    protected val pointer: Pointer?
    protected val cleanable: UniffiCleaner.Cleanable

    private val wasDestroyed = AtomicBoolean(false)
    private val callCounter = AtomicLong(1)

    override fun destroy() {
        // Only allow a single call to this method.
        // TODO: maybe we should log a warning if called more than once?
        if (this.wasDestroyed.compareAndSet(false, true)) {
            // This decrement always matches the initial count of 1 given at creation time.
            if (this.callCounter.decrementAndGet() == 0L) {
                cleanable.clean()
            }
        }
    }

    @Synchronized
    override fun close() {
        this.destroy()
    }

    internal inline fun <R> callWithPointer(block: (ptr: Pointer) -> R): R {
        // Check and increment the call counter, to keep the object alive.
        // This needs a compare-and-set retry loop in case of concurrent updates.
        do {
            val c = this.callCounter.get()
            if (c == 0L) {
                throw IllegalStateException("${this.javaClass.simpleName} object has already been destroyed")
            }
            if (c == Long.MAX_VALUE) {
                throw IllegalStateException("${this.javaClass.simpleName} call counter would overflow")
            }
        } while (! this.callCounter.compareAndSet(c, c + 1L))
        // Now we can safely do the method call without the pointer being freed concurrently.
        try {
            return block(this.uniffiClonePointer())
        } finally {
            // This decrement always matches the increment we performed above.
            if (this.callCounter.decrementAndGet() == 0L) {
                cleanable.clean()
            }
        }
    }

    // Use a static inner class instead of a closure so as not to accidentally
    // capture `this` as part of the cleanable's action.
    private class UniffiCleanAction(private val pointer: Pointer?) : Runnable {
        override fun run() {
            pointer?.let { ptr ->
                uniffiRustCall { status ->
                    UniffiLib.INSTANCE.uniffi_zen_uniffi_fn_free_zendecision(ptr, status)
                }
            }
        }
    }

    fun uniffiClonePointer(): Pointer {
        return uniffiRustCall() { status ->
            UniffiLib.INSTANCE.uniffi_zen_uniffi_fn_clone_zendecision(pointer!!, status)
        }
    }

    
    @Throws(ZenException::class)
    @Suppress("ASSIGNED_BUT_NEVER_ACCESSED_VARIABLE")
    override suspend fun `evaluate`(`context`: JsonBuffer, `options`: ZenEvaluateOptions?) : ZenEngineResponse {
        return uniffiRustCallAsync(
        callWithPointer { thisPtr ->
            UniffiLib.INSTANCE.uniffi_zen_uniffi_fn_method_zendecision_evaluate(
                thisPtr,
                FfiConverterTypeJsonBuffer.lower(`context`),FfiConverterOptionalTypeZenEvaluateOptions.lower(`options`),
            )
        },
        { future, callback, continuation -> UniffiLib.INSTANCE.ffi_zen_uniffi_rust_future_poll_rust_buffer(future, callback, continuation) },
        { future, continuation -> UniffiLib.INSTANCE.ffi_zen_uniffi_rust_future_complete_rust_buffer(future, continuation) },
        { future -> UniffiLib.INSTANCE.ffi_zen_uniffi_rust_future_free_rust_buffer(future) },
        // lift function
        { FfiConverterTypeZenEngineResponse.lift(it) },
        // Error FFI converter
        ZenException.ErrorHandler,
    )
    }

    
    @Throws(ZenException::class)override fun `validate`()
        = 
    callWithPointer {
    uniffiRustCallWithError(ZenException) { _status ->
    UniffiLib.INSTANCE.uniffi_zen_uniffi_fn_method_zendecision_validate(
        it, _status)
}
    }
    
    

    

    
    
    companion object
    
}

/**
 * @suppress
 */
public object FfiConverterTypeZenDecision: FfiConverter<ZenDecision, Pointer> {

    override fun lower(value: ZenDecision): Pointer {
        return value.uniffiClonePointer()
    }

    override fun lift(value: Pointer): ZenDecision {
        return ZenDecision(value)
    }

    override fun read(buf: ByteBuffer): ZenDecision {
        // The Rust code always writes pointers as 8 bytes, and will
        // fail to compile if they don't fit.
        return lift(Pointer(buf.getLong()))
    }

    override fun allocationSize(value: ZenDecision) = 8UL

    override fun write(value: ZenDecision, buf: ByteBuffer) {
        // The Rust code always expects pointers written as 8 bytes,
        // and will fail to compile if they don't fit.
        buf.putLong(Pointer.nativeValue(lower(value)))
    }
}


// This template implements a class for working with a Rust struct via a Pointer/Arc<T>
// to the live Rust struct on the other side of the FFI.
//
// Each instance implements core operations for working with the Rust `Arc<T>` and the
// Kotlin Pointer to work with the live Rust struct on the other side of the FFI.
//
// There's some subtlety here, because we have to be careful not to operate on a Rust
// struct after it has been dropped, and because we must expose a public API for freeing
// theq Kotlin wrapper object in lieu of reliable finalizers. The core requirements are:
//
//   * Each instance holds an opaque pointer to the underlying Rust struct.
//     Method calls need to read this pointer from the object's state and pass it in to
//     the Rust FFI.
//
//   * When an instance is no longer needed, its pointer should be passed to a
//     special destructor function provided by the Rust FFI, which will drop the
//     underlying Rust struct.
//
//   * Given an instance, calling code is expected to call the special
//     `destroy` method in order to free it after use, either by calling it explicitly
//     or by using a higher-level helper like the `use` method. Failing to do so risks
//     leaking the underlying Rust struct.
//
//   * We can't assume that calling code will do the right thing, and must be prepared
//     to handle Kotlin method calls executing concurrently with or even after a call to
//     `destroy`, and to handle multiple (possibly concurrent!) calls to `destroy`.
//
//   * We must never allow Rust code to operate on the underlying Rust struct after
//     the destructor has been called, and must never call the destructor more than once.
//     Doing so may trigger memory unsafety.
//
//   * To mitigate many of the risks of leaking memory and use-after-free unsafety, a `Cleaner`
//     is implemented to call the destructor when the Kotlin object becomes unreachable.
//     This is done in a background thread. This is not a panacea, and client code should be aware that
//      1. the thread may starve if some there are objects that have poorly performing
//     `drop` methods or do significant work in their `drop` methods.
//      2. the thread is shared across the whole library. This can be tuned by using `android_cleaner = true`,
//         or `android = true` in the [`kotlin` section of the `uniffi.toml` file](https://mozilla.github.io/uniffi-rs/kotlin/configuration.html).
//
// If we try to implement this with mutual exclusion on access to the pointer, there is the
// possibility of a race between a method call and a concurrent call to `destroy`:
//
//    * Thread A starts a method call, reads the value of the pointer, but is interrupted
//      before it can pass the pointer over the FFI to Rust.
//    * Thread B calls `destroy` and frees the underlying Rust struct.
//    * Thread A resumes, passing the already-read pointer value to Rust and triggering
//      a use-after-free.
//
// One possible solution would be to use a `ReadWriteLock`, with each method call taking
// a read lock (and thus allowed to run concurrently) and the special `destroy` method
// taking a write lock (and thus blocking on live method calls). However, we aim not to
// generate methods with any hidden blocking semantics, and a `destroy` method that might
// block if called incorrectly seems to meet that bar.
//
// So, we achieve our goals by giving each instance an associated `AtomicLong` counter to track
// the number of in-flight method calls, and an `AtomicBoolean` flag to indicate whether `destroy`
// has been called. These are updated according to the following rules:
//
//    * The initial value of the counter is 1, indicating a live object with no in-flight calls.
//      The initial value for the flag is false.
//
//    * At the start of each method call, we atomically check the counter.
//      If it is 0 then the underlying Rust struct has already been destroyed and the call is aborted.
//      If it is nonzero them we atomically increment it by 1 and proceed with the method call.
//
//    * At the end of each method call, we atomically decrement and check the counter.
//      If it has reached zero then we destroy the underlying Rust struct.
//
//    * When `destroy` is called, we atomically flip the flag from false to true.
//      If the flag was already true we silently fail.
//      Otherwise we atomically decrement and check the counter.
//      If it has reached zero then we destroy the underlying Rust struct.
//
// Astute readers may observe that this all sounds very similar to the way that Rust's `Arc<T>` works,
// and indeed it is, with the addition of a flag to guard against multiple calls to `destroy`.
//
// The overall effect is that the underlying Rust struct is destroyed only when `destroy` has been
// called *and* all in-flight method calls have completed, avoiding violating any of the expectations
// of the underlying Rust code.
//
// This makes a cleaner a better alternative to _not_ calling `destroy()` as
// and when the object is finished with, but the abstraction is not perfect: if the Rust object's `drop`
// method is slow, and/or there are many objects to cleanup, and it's on a low end Android device, then the cleaner
// thread may be starved, and the app will leak memory.
//
// In this case, `destroy`ing manually may be a better solution.
//
// The cleaner can live side by side with the manual calling of `destroy`. In the order of responsiveness, uniffi objects
// with Rust peers are reclaimed:
//
// 1. By calling the `destroy` method of the object, which calls `rustObject.free()`. If that doesn't happen:
// 2. When the object becomes unreachable, AND the Cleaner thread gets to call `rustObject.free()`. If the thread is starved then:
// 3. The memory is reclaimed when the process terminates.
//
// [1] https://stackoverflow.com/questions/24376768/can-java-finalize-an-object-when-it-is-still-in-scope/24380219
//


public interface ZenEngineInterface {
    
    fun `createDecision`(`content`: JsonBuffer): ZenDecision
    
    suspend fun `evaluate`(`key`: kotlin.String, `context`: JsonBuffer, `options`: ZenEvaluateOptions?): ZenEngineResponse
    
    suspend fun `getDecision`(`key`: kotlin.String): ZenDecision
    
    companion object
}

open class ZenEngine: Disposable, AutoCloseable, ZenEngineInterface
{

    constructor(pointer: Pointer) {
        this.pointer = pointer
        this.cleanable = UniffiLib.CLEANER.register(this, UniffiCleanAction(pointer))
    }

    /**
     * This constructor can be used to instantiate a fake object. Only used for tests. Any
     * attempt to actually use an object constructed this way will fail as there is no
     * connected Rust object.
     */
    @Suppress("UNUSED_PARAMETER")
    constructor(noPointer: NoPointer) {
        this.pointer = null
        this.cleanable = UniffiLib.CLEANER.register(this, UniffiCleanAction(pointer))
    }
    constructor(`loader`: ZenDecisionLoaderCallback?, `customNode`: ZenCustomNodeCallback?) :
        this(
    uniffiRustCall() { _status ->
    UniffiLib.INSTANCE.uniffi_zen_uniffi_fn_constructor_zenengine_new(
        FfiConverterOptionalTypeZenDecisionLoaderCallback.lower(`loader`),FfiConverterOptionalTypeZenCustomNodeCallback.lower(`customNode`),_status)
}
    )

    protected val pointer: Pointer?
    protected val cleanable: UniffiCleaner.Cleanable

    private val wasDestroyed = AtomicBoolean(false)
    private val callCounter = AtomicLong(1)

    override fun destroy() {
        // Only allow a single call to this method.
        // TODO: maybe we should log a warning if called more than once?
        if (this.wasDestroyed.compareAndSet(false, true)) {
            // This decrement always matches the initial count of 1 given at creation time.
            if (this.callCounter.decrementAndGet() == 0L) {
                cleanable.clean()
            }
        }
    }

    @Synchronized
    override fun close() {
        this.destroy()
    }

    internal inline fun <R> callWithPointer(block: (ptr: Pointer) -> R): R {
        // Check and increment the call counter, to keep the object alive.
        // This needs a compare-and-set retry loop in case of concurrent updates.
        do {
            val c = this.callCounter.get()
            if (c == 0L) {
                throw IllegalStateException("${this.javaClass.simpleName} object has already been destroyed")
            }
            if (c == Long.MAX_VALUE) {
                throw IllegalStateException("${this.javaClass.simpleName} call counter would overflow")
            }
        } while (! this.callCounter.compareAndSet(c, c + 1L))
        // Now we can safely do the method call without the pointer being freed concurrently.
        try {
            return block(this.uniffiClonePointer())
        } finally {
            // This decrement always matches the increment we performed above.
            if (this.callCounter.decrementAndGet() == 0L) {
                cleanable.clean()
            }
        }
    }

    // Use a static inner class instead of a closure so as not to accidentally
    // capture `this` as part of the cleanable's action.
    private class UniffiCleanAction(private val pointer: Pointer?) : Runnable {
        override fun run() {
            pointer?.let { ptr ->
                uniffiRustCall { status ->
                    UniffiLib.INSTANCE.uniffi_zen_uniffi_fn_free_zenengine(ptr, status)
                }
            }
        }
    }

    fun uniffiClonePointer(): Pointer {
        return uniffiRustCall() { status ->
            UniffiLib.INSTANCE.uniffi_zen_uniffi_fn_clone_zenengine(pointer!!, status)
        }
    }

    
    @Throws(ZenException::class)override fun `createDecision`(`content`: JsonBuffer): ZenDecision {
            return FfiConverterTypeZenDecision.lift(
    callWithPointer {
    uniffiRustCallWithError(ZenException) { _status ->
    UniffiLib.INSTANCE.uniffi_zen_uniffi_fn_method_zenengine_create_decision(
        it, FfiConverterTypeJsonBuffer.lower(`content`),_status)
}
    }
    )
    }
    

    
    @Throws(ZenException::class)
    @Suppress("ASSIGNED_BUT_NEVER_ACCESSED_VARIABLE")
    override suspend fun `evaluate`(`key`: kotlin.String, `context`: JsonBuffer, `options`: ZenEvaluateOptions?) : ZenEngineResponse {
        return uniffiRustCallAsync(
        callWithPointer { thisPtr ->
            UniffiLib.INSTANCE.uniffi_zen_uniffi_fn_method_zenengine_evaluate(
                thisPtr,
                FfiConverterString.lower(`key`),FfiConverterTypeJsonBuffer.lower(`context`),FfiConverterOptionalTypeZenEvaluateOptions.lower(`options`),
            )
        },
        { future, callback, continuation -> UniffiLib.INSTANCE.ffi_zen_uniffi_rust_future_poll_rust_buffer(future, callback, continuation) },
        { future, continuation -> UniffiLib.INSTANCE.ffi_zen_uniffi_rust_future_complete_rust_buffer(future, continuation) },
        { future -> UniffiLib.INSTANCE.ffi_zen_uniffi_rust_future_free_rust_buffer(future) },
        // lift function
        { FfiConverterTypeZenEngineResponse.lift(it) },
        // Error FFI converter
        ZenException.ErrorHandler,
    )
    }

    
    @Throws(ZenException::class)
    @Suppress("ASSIGNED_BUT_NEVER_ACCESSED_VARIABLE")
    override suspend fun `getDecision`(`key`: kotlin.String) : ZenDecision {
        return uniffiRustCallAsync(
        callWithPointer { thisPtr ->
            UniffiLib.INSTANCE.uniffi_zen_uniffi_fn_method_zenengine_get_decision(
                thisPtr,
                FfiConverterString.lower(`key`),
            )
        },
        { future, callback, continuation -> UniffiLib.INSTANCE.ffi_zen_uniffi_rust_future_poll_pointer(future, callback, continuation) },
        { future, continuation -> UniffiLib.INSTANCE.ffi_zen_uniffi_rust_future_complete_pointer(future, continuation) },
        { future -> UniffiLib.INSTANCE.ffi_zen_uniffi_rust_future_free_pointer(future) },
        // lift function
        { FfiConverterTypeZenDecision.lift(it) },
        // Error FFI converter
        ZenException.ErrorHandler,
    )
    }

    

    
    
    companion object
    
}

/**
 * @suppress
 */
public object FfiConverterTypeZenEngine: FfiConverter<ZenEngine, Pointer> {

    override fun lower(value: ZenEngine): Pointer {
        return value.uniffiClonePointer()
    }

    override fun lift(value: Pointer): ZenEngine {
        return ZenEngine(value)
    }

    override fun read(buf: ByteBuffer): ZenEngine {
        // The Rust code always writes pointers as 8 bytes, and will
        // fail to compile if they don't fit.
        return lift(Pointer(buf.getLong()))
    }

    override fun allocationSize(value: ZenEngine) = 8UL

    override fun write(value: ZenEngine, buf: ByteBuffer) {
        // The Rust code always expects pointers written as 8 bytes,
        // and will fail to compile if they don't fit.
        buf.putLong(Pointer.nativeValue(lower(value)))
    }
}


// This template implements a class for working with a Rust struct via a Pointer/Arc<T>
// to the live Rust struct on the other side of the FFI.
//
// Each instance implements core operations for working with the Rust `Arc<T>` and the
// Kotlin Pointer to work with the live Rust struct on the other side of the FFI.
//
// There's some subtlety here, because we have to be careful not to operate on a Rust
// struct after it has been dropped, and because we must expose a public API for freeing
// theq Kotlin wrapper object in lieu of reliable finalizers. The core requirements are:
//
//   * Each instance holds an opaque pointer to the underlying Rust struct.
//     Method calls need to read this pointer from the object's state and pass it in to
//     the Rust FFI.
//
//   * When an instance is no longer needed, its pointer should be passed to a
//     special destructor function provided by the Rust FFI, which will drop the
//     underlying Rust struct.
//
//   * Given an instance, calling code is expected to call the special
//     `destroy` method in order to free it after use, either by calling it explicitly
//     or by using a higher-level helper like the `use` method. Failing to do so risks
//     leaking the underlying Rust struct.
//
//   * We can't assume that calling code will do the right thing, and must be prepared
//     to handle Kotlin method calls executing concurrently with or even after a call to
//     `destroy`, and to handle multiple (possibly concurrent!) calls to `destroy`.
//
//   * We must never allow Rust code to operate on the underlying Rust struct after
//     the destructor has been called, and must never call the destructor more than once.
//     Doing so may trigger memory unsafety.
//
//   * To mitigate many of the risks of leaking memory and use-after-free unsafety, a `Cleaner`
//     is implemented to call the destructor when the Kotlin object becomes unreachable.
//     This is done in a background thread. This is not a panacea, and client code should be aware that
//      1. the thread may starve if some there are objects that have poorly performing
//     `drop` methods or do significant work in their `drop` methods.
//      2. the thread is shared across the whole library. This can be tuned by using `android_cleaner = true`,
//         or `android = true` in the [`kotlin` section of the `uniffi.toml` file](https://mozilla.github.io/uniffi-rs/kotlin/configuration.html).
//
// If we try to implement this with mutual exclusion on access to the pointer, there is the
// possibility of a race between a method call and a concurrent call to `destroy`:
//
//    * Thread A starts a method call, reads the value of the pointer, but is interrupted
//      before it can pass the pointer over the FFI to Rust.
//    * Thread B calls `destroy` and frees the underlying Rust struct.
//    * Thread A resumes, passing the already-read pointer value to Rust and triggering
//      a use-after-free.
//
// One possible solution would be to use a `ReadWriteLock`, with each method call taking
// a read lock (and thus allowed to run concurrently) and the special `destroy` method
// taking a write lock (and thus blocking on live method calls). However, we aim not to
// generate methods with any hidden blocking semantics, and a `destroy` method that might
// block if called incorrectly seems to meet that bar.
//
// So, we achieve our goals by giving each instance an associated `AtomicLong` counter to track
// the number of in-flight method calls, and an `AtomicBoolean` flag to indicate whether `destroy`
// has been called. These are updated according to the following rules:
//
//    * The initial value of the counter is 1, indicating a live object with no in-flight calls.
//      The initial value for the flag is false.
//
//    * At the start of each method call, we atomically check the counter.
//      If it is 0 then the underlying Rust struct has already been destroyed and the call is aborted.
//      If it is nonzero them we atomically increment it by 1 and proceed with the method call.
//
//    * At the end of each method call, we atomically decrement and check the counter.
//      If it has reached zero then we destroy the underlying Rust struct.
//
//    * When `destroy` is called, we atomically flip the flag from false to true.
//      If the flag was already true we silently fail.
//      Otherwise we atomically decrement and check the counter.
//      If it has reached zero then we destroy the underlying Rust struct.
//
// Astute readers may observe that this all sounds very similar to the way that Rust's `Arc<T>` works,
// and indeed it is, with the addition of a flag to guard against multiple calls to `destroy`.
//
// The overall effect is that the underlying Rust struct is destroyed only when `destroy` has been
// called *and* all in-flight method calls have completed, avoiding violating any of the expectations
// of the underlying Rust code.
//
// This makes a cleaner a better alternative to _not_ calling `destroy()` as
// and when the object is finished with, but the abstraction is not perfect: if the Rust object's `drop`
// method is slow, and/or there are many objects to cleanup, and it's on a low end Android device, then the cleaner
// thread may be starved, and the app will leak memory.
//
// In this case, `destroy`ing manually may be a better solution.
//
// The cleaner can live side by side with the manual calling of `destroy`. In the order of responsiveness, uniffi objects
// with Rust peers are reclaimed:
//
// 1. By calling the `destroy` method of the object, which calls `rustObject.free()`. If that doesn't happen:
// 2. When the object becomes unreachable, AND the Cleaner thread gets to call `rustObject.free()`. If the thread is starved then:
// 3. The memory is reclaimed when the process terminates.
//
// [1] https://stackoverflow.com/questions/24376768/can-java-finalize-an-object-when-it-is-still-in-scope/24380219
//


public interface ZenExpressionInterface {
    
    fun `evaluate`(`context`: JsonBuffer?): JsonBuffer
    
    companion object
}

open class ZenExpression: Disposable, AutoCloseable, ZenExpressionInterface
{

    constructor(pointer: Pointer) {
        this.pointer = pointer
        this.cleanable = UniffiLib.CLEANER.register(this, UniffiCleanAction(pointer))
    }

    /**
     * This constructor can be used to instantiate a fake object. Only used for tests. Any
     * attempt to actually use an object constructed this way will fail as there is no
     * connected Rust object.
     */
    @Suppress("UNUSED_PARAMETER")
    constructor(noPointer: NoPointer) {
        this.pointer = null
        this.cleanable = UniffiLib.CLEANER.register(this, UniffiCleanAction(pointer))
    }

    protected val pointer: Pointer?
    protected val cleanable: UniffiCleaner.Cleanable

    private val wasDestroyed = AtomicBoolean(false)
    private val callCounter = AtomicLong(1)

    override fun destroy() {
        // Only allow a single call to this method.
        // TODO: maybe we should log a warning if called more than once?
        if (this.wasDestroyed.compareAndSet(false, true)) {
            // This decrement always matches the initial count of 1 given at creation time.
            if (this.callCounter.decrementAndGet() == 0L) {
                cleanable.clean()
            }
        }
    }

    @Synchronized
    override fun close() {
        this.destroy()
    }

    internal inline fun <R> callWithPointer(block: (ptr: Pointer) -> R): R {
        // Check and increment the call counter, to keep the object alive.
        // This needs a compare-and-set retry loop in case of concurrent updates.
        do {
            val c = this.callCounter.get()
            if (c == 0L) {
                throw IllegalStateException("${this.javaClass.simpleName} object has already been destroyed")
            }
            if (c == Long.MAX_VALUE) {
                throw IllegalStateException("${this.javaClass.simpleName} call counter would overflow")
            }
        } while (! this.callCounter.compareAndSet(c, c + 1L))
        // Now we can safely do the method call without the pointer being freed concurrently.
        try {
            return block(this.uniffiClonePointer())
        } finally {
            // This decrement always matches the increment we performed above.
            if (this.callCounter.decrementAndGet() == 0L) {
                cleanable.clean()
            }
        }
    }

    // Use a static inner class instead of a closure so as not to accidentally
    // capture `this` as part of the cleanable's action.
    private class UniffiCleanAction(private val pointer: Pointer?) : Runnable {
        override fun run() {
            pointer?.let { ptr ->
                uniffiRustCall { status ->
                    UniffiLib.INSTANCE.uniffi_zen_uniffi_fn_free_zenexpression(ptr, status)
                }
            }
        }
    }

    fun uniffiClonePointer(): Pointer {
        return uniffiRustCall() { status ->
            UniffiLib.INSTANCE.uniffi_zen_uniffi_fn_clone_zenexpression(pointer!!, status)
        }
    }

    
    @Throws(ZenException::class)override fun `evaluate`(`context`: JsonBuffer?): JsonBuffer {
            return FfiConverterTypeJsonBuffer.lift(
    callWithPointer {
    uniffiRustCallWithError(ZenException) { _status ->
    UniffiLib.INSTANCE.uniffi_zen_uniffi_fn_method_zenexpression_evaluate(
        it, FfiConverterOptionalTypeJsonBuffer.lower(`context`),_status)
}
    }
    )
    }
    

    

    
    companion object {
        
    @Throws(ZenException::class) fun `compile`(`expression`: kotlin.String): ZenExpression {
            return FfiConverterTypeZenExpression.lift(
    uniffiRustCallWithError(ZenException) { _status ->
    UniffiLib.INSTANCE.uniffi_zen_uniffi_fn_constructor_zenexpression_compile(
        FfiConverterString.lower(`expression`),_status)
}
    )
    }
    

        
    }
    
}

/**
 * @suppress
 */
public object FfiConverterTypeZenExpression: FfiConverter<ZenExpression, Pointer> {

    override fun lower(value: ZenExpression): Pointer {
        return value.uniffiClonePointer()
    }

    override fun lift(value: Pointer): ZenExpression {
        return ZenExpression(value)
    }

    override fun read(buf: ByteBuffer): ZenExpression {
        // The Rust code always writes pointers as 8 bytes, and will
        // fail to compile if they don't fit.
        return lift(Pointer(buf.getLong()))
    }

    override fun allocationSize(value: ZenExpression) = 8UL

    override fun write(value: ZenExpression, buf: ByteBuffer) {
        // The Rust code always expects pointers written as 8 bytes,
        // and will fail to compile if they don't fit.
        buf.putLong(Pointer.nativeValue(lower(value)))
    }
}


// This template implements a class for working with a Rust struct via a Pointer/Arc<T>
// to the live Rust struct on the other side of the FFI.
//
// Each instance implements core operations for working with the Rust `Arc<T>` and the
// Kotlin Pointer to work with the live Rust struct on the other side of the FFI.
//
// There's some subtlety here, because we have to be careful not to operate on a Rust
// struct after it has been dropped, and because we must expose a public API for freeing
// theq Kotlin wrapper object in lieu of reliable finalizers. The core requirements are:
//
//   * Each instance holds an opaque pointer to the underlying Rust struct.
//     Method calls need to read this pointer from the object's state and pass it in to
//     the Rust FFI.
//
//   * When an instance is no longer needed, its pointer should be passed to a
//     special destructor function provided by the Rust FFI, which will drop the
//     underlying Rust struct.
//
//   * Given an instance, calling code is expected to call the special
//     `destroy` method in order to free it after use, either by calling it explicitly
//     or by using a higher-level helper like the `use` method. Failing to do so risks
//     leaking the underlying Rust struct.
//
//   * We can't assume that calling code will do the right thing, and must be prepared
//     to handle Kotlin method calls executing concurrently with or even after a call to
//     `destroy`, and to handle multiple (possibly concurrent!) calls to `destroy`.
//
//   * We must never allow Rust code to operate on the underlying Rust struct after
//     the destructor has been called, and must never call the destructor more than once.
//     Doing so may trigger memory unsafety.
//
//   * To mitigate many of the risks of leaking memory and use-after-free unsafety, a `Cleaner`
//     is implemented to call the destructor when the Kotlin object becomes unreachable.
//     This is done in a background thread. This is not a panacea, and client code should be aware that
//      1. the thread may starve if some there are objects that have poorly performing
//     `drop` methods or do significant work in their `drop` methods.
//      2. the thread is shared across the whole library. This can be tuned by using `android_cleaner = true`,
//         or `android = true` in the [`kotlin` section of the `uniffi.toml` file](https://mozilla.github.io/uniffi-rs/kotlin/configuration.html).
//
// If we try to implement this with mutual exclusion on access to the pointer, there is the
// possibility of a race between a method call and a concurrent call to `destroy`:
//
//    * Thread A starts a method call, reads the value of the pointer, but is interrupted
//      before it can pass the pointer over the FFI to Rust.
//    * Thread B calls `destroy` and frees the underlying Rust struct.
//    * Thread A resumes, passing the already-read pointer value to Rust and triggering
//      a use-after-free.
//
// One possible solution would be to use a `ReadWriteLock`, with each method call taking
// a read lock (and thus allowed to run concurrently) and the special `destroy` method
// taking a write lock (and thus blocking on live method calls). However, we aim not to
// generate methods with any hidden blocking semantics, and a `destroy` method that might
// block if called incorrectly seems to meet that bar.
//
// So, we achieve our goals by giving each instance an associated `AtomicLong` counter to track
// the number of in-flight method calls, and an `AtomicBoolean` flag to indicate whether `destroy`
// has been called. These are updated according to the following rules:
//
//    * The initial value of the counter is 1, indicating a live object with no in-flight calls.
//      The initial value for the flag is false.
//
//    * At the start of each method call, we atomically check the counter.
//      If it is 0 then the underlying Rust struct has already been destroyed and the call is aborted.
//      If it is nonzero them we atomically increment it by 1 and proceed with the method call.
//
//    * At the end of each method call, we atomically decrement and check the counter.
//      If it has reached zero then we destroy the underlying Rust struct.
//
//    * When `destroy` is called, we atomically flip the flag from false to true.
//      If the flag was already true we silently fail.
//      Otherwise we atomically decrement and check the counter.
//      If it has reached zero then we destroy the underlying Rust struct.
//
// Astute readers may observe that this all sounds very similar to the way that Rust's `Arc<T>` works,
// and indeed it is, with the addition of a flag to guard against multiple calls to `destroy`.
//
// The overall effect is that the underlying Rust struct is destroyed only when `destroy` has been
// called *and* all in-flight method calls have completed, avoiding violating any of the expectations
// of the underlying Rust code.
//
// This makes a cleaner a better alternative to _not_ calling `destroy()` as
// and when the object is finished with, but the abstraction is not perfect: if the Rust object's `drop`
// method is slow, and/or there are many objects to cleanup, and it's on a low end Android device, then the cleaner
// thread may be starved, and the app will leak memory.
//
// In this case, `destroy`ing manually may be a better solution.
//
// The cleaner can live side by side with the manual calling of `destroy`. In the order of responsiveness, uniffi objects
// with Rust peers are reclaimed:
//
// 1. By calling the `destroy` method of the object, which calls `rustObject.free()`. If that doesn't happen:
// 2. When the object becomes unreachable, AND the Cleaner thread gets to call `rustObject.free()`. If the thread is starved then:
// 3. The memory is reclaimed when the process terminates.
//
// [1] https://stackoverflow.com/questions/24376768/can-java-finalize-an-object-when-it-is-still-in-scope/24380219
//


public interface ZenExpressionUnaryInterface {
    
    fun `evaluate`(`context`: JsonBuffer): kotlin.Boolean
    
    companion object
}

open class ZenExpressionUnary: Disposable, AutoCloseable, ZenExpressionUnaryInterface
{

    constructor(pointer: Pointer) {
        this.pointer = pointer
        this.cleanable = UniffiLib.CLEANER.register(this, UniffiCleanAction(pointer))
    }

    /**
     * This constructor can be used to instantiate a fake object. Only used for tests. Any
     * attempt to actually use an object constructed this way will fail as there is no
     * connected Rust object.
     */
    @Suppress("UNUSED_PARAMETER")
    constructor(noPointer: NoPointer) {
        this.pointer = null
        this.cleanable = UniffiLib.CLEANER.register(this, UniffiCleanAction(pointer))
    }

    protected val pointer: Pointer?
    protected val cleanable: UniffiCleaner.Cleanable

    private val wasDestroyed = AtomicBoolean(false)
    private val callCounter = AtomicLong(1)

    override fun destroy() {
        // Only allow a single call to this method.
        // TODO: maybe we should log a warning if called more than once?
        if (this.wasDestroyed.compareAndSet(false, true)) {
            // This decrement always matches the initial count of 1 given at creation time.
            if (this.callCounter.decrementAndGet() == 0L) {
                cleanable.clean()
            }
        }
    }

    @Synchronized
    override fun close() {
        this.destroy()
    }

    internal inline fun <R> callWithPointer(block: (ptr: Pointer) -> R): R {
        // Check and increment the call counter, to keep the object alive.
        // This needs a compare-and-set retry loop in case of concurrent updates.
        do {
            val c = this.callCounter.get()
            if (c == 0L) {
                throw IllegalStateException("${this.javaClass.simpleName} object has already been destroyed")
            }
            if (c == Long.MAX_VALUE) {
                throw IllegalStateException("${this.javaClass.simpleName} call counter would overflow")
            }
        } while (! this.callCounter.compareAndSet(c, c + 1L))
        // Now we can safely do the method call without the pointer being freed concurrently.
        try {
            return block(this.uniffiClonePointer())
        } finally {
            // This decrement always matches the increment we performed above.
            if (this.callCounter.decrementAndGet() == 0L) {
                cleanable.clean()
            }
        }
    }

    // Use a static inner class instead of a closure so as not to accidentally
    // capture `this` as part of the cleanable's action.
    private class UniffiCleanAction(private val pointer: Pointer?) : Runnable {
        override fun run() {
            pointer?.let { ptr ->
                uniffiRustCall { status ->
                    UniffiLib.INSTANCE.uniffi_zen_uniffi_fn_free_zenexpressionunary(ptr, status)
                }
            }
        }
    }

    fun uniffiClonePointer(): Pointer {
        return uniffiRustCall() { status ->
            UniffiLib.INSTANCE.uniffi_zen_uniffi_fn_clone_zenexpressionunary(pointer!!, status)
        }
    }

    
    @Throws(ZenException::class)override fun `evaluate`(`context`: JsonBuffer): kotlin.Boolean {
            return FfiConverterBoolean.lift(
    callWithPointer {
    uniffiRustCallWithError(ZenException) { _status ->
    UniffiLib.INSTANCE.uniffi_zen_uniffi_fn_method_zenexpressionunary_evaluate(
        it, FfiConverterTypeJsonBuffer.lower(`context`),_status)
}
    }
    )
    }
    

    

    
    companion object {
        
    @Throws(ZenException::class) fun `compile`(`expression`: kotlin.String): ZenExpressionUnary {
            return FfiConverterTypeZenExpressionUnary.lift(
    uniffiRustCallWithError(ZenException) { _status ->
    UniffiLib.INSTANCE.uniffi_zen_uniffi_fn_constructor_zenexpressionunary_compile(
        FfiConverterString.lower(`expression`),_status)
}
    )
    }
    

        
    }
    
}

/**
 * @suppress
 */
public object FfiConverterTypeZenExpressionUnary: FfiConverter<ZenExpressionUnary, Pointer> {

    override fun lower(value: ZenExpressionUnary): Pointer {
        return value.uniffiClonePointer()
    }

    override fun lift(value: Pointer): ZenExpressionUnary {
        return ZenExpressionUnary(value)
    }

    override fun read(buf: ByteBuffer): ZenExpressionUnary {
        // The Rust code always writes pointers as 8 bytes, and will
        // fail to compile if they don't fit.
        return lift(Pointer(buf.getLong()))
    }

    override fun allocationSize(value: ZenExpressionUnary) = 8UL

    override fun write(value: ZenExpressionUnary, buf: ByteBuffer) {
        // The Rust code always expects pointers written as 8 bytes,
        // and will fail to compile if they don't fit.
        buf.putLong(Pointer.nativeValue(lower(value)))
    }
}



data class DecisionNode (
    val `id`: kotlin.String, 
    val `name`: kotlin.String, 
    val `kind`: kotlin.String, 
    val `config`: JsonBuffer
) {
    
    companion object
}

/**
 * @suppress
 */
public object FfiConverterTypeDecisionNode: FfiConverterRustBuffer<DecisionNode> {
    override fun read(buf: ByteBuffer): DecisionNode {
        return DecisionNode(
            FfiConverterString.read(buf),
            FfiConverterString.read(buf),
            FfiConverterString.read(buf),
            FfiConverterTypeJsonBuffer.read(buf),
        )
    }

    override fun allocationSize(value: DecisionNode) = (
            FfiConverterString.allocationSize(value.`id`) +
            FfiConverterString.allocationSize(value.`name`) +
            FfiConverterString.allocationSize(value.`kind`) +
            FfiConverterTypeJsonBuffer.allocationSize(value.`config`)
    )

    override fun write(value: DecisionNode, buf: ByteBuffer) {
            FfiConverterString.write(value.`id`, buf)
            FfiConverterString.write(value.`name`, buf)
            FfiConverterString.write(value.`kind`, buf)
            FfiConverterTypeJsonBuffer.write(value.`config`, buf)
    }
}



data class ZenConfig (
    val `nodesInContext`: kotlin.Boolean?
) {
    
    companion object
}

/**
 * @suppress
 */
public object FfiConverterTypeZenConfig: FfiConverterRustBuffer<ZenConfig> {
    override fun read(buf: ByteBuffer): ZenConfig {
        return ZenConfig(
            FfiConverterOptionalBoolean.read(buf),
        )
    }

    override fun allocationSize(value: ZenConfig) = (
            FfiConverterOptionalBoolean.allocationSize(value.`nodesInContext`)
    )

    override fun write(value: ZenConfig, buf: ByteBuffer) {
            FfiConverterOptionalBoolean.write(value.`nodesInContext`, buf)
    }
}



data class ZenEngineHandlerRequest (
    val `input`: JsonBuffer, 
    val `node`: DecisionNode
) {
    
    companion object
}

/**
 * @suppress
 */
public object FfiConverterTypeZenEngineHandlerRequest: FfiConverterRustBuffer<ZenEngineHandlerRequest> {
    override fun read(buf: ByteBuffer): ZenEngineHandlerRequest {
        return ZenEngineHandlerRequest(
            FfiConverterTypeJsonBuffer.read(buf),
            FfiConverterTypeDecisionNode.read(buf),
        )
    }

    override fun allocationSize(value: ZenEngineHandlerRequest) = (
            FfiConverterTypeJsonBuffer.allocationSize(value.`input`) +
            FfiConverterTypeDecisionNode.allocationSize(value.`node`)
    )

    override fun write(value: ZenEngineHandlerRequest, buf: ByteBuffer) {
            FfiConverterTypeJsonBuffer.write(value.`input`, buf)
            FfiConverterTypeDecisionNode.write(value.`node`, buf)
    }
}



data class ZenEngineHandlerResponse (
    val `output`: JsonBuffer, 
    val `traceData`: JsonBuffer?
) {
    
    companion object
}

/**
 * @suppress
 */
public object FfiConverterTypeZenEngineHandlerResponse: FfiConverterRustBuffer<ZenEngineHandlerResponse> {
    override fun read(buf: ByteBuffer): ZenEngineHandlerResponse {
        return ZenEngineHandlerResponse(
            FfiConverterTypeJsonBuffer.read(buf),
            FfiConverterOptionalTypeJsonBuffer.read(buf),
        )
    }

    override fun allocationSize(value: ZenEngineHandlerResponse) = (
            FfiConverterTypeJsonBuffer.allocationSize(value.`output`) +
            FfiConverterOptionalTypeJsonBuffer.allocationSize(value.`traceData`)
    )

    override fun write(value: ZenEngineHandlerResponse, buf: ByteBuffer) {
            FfiConverterTypeJsonBuffer.write(value.`output`, buf)
            FfiConverterOptionalTypeJsonBuffer.write(value.`traceData`, buf)
    }
}



data class ZenEngineResponse (
    val `performance`: kotlin.String, 
    val `result`: JsonBuffer, 
    val `trace`: Map<kotlin.String, ZenEngineTrace>?
) {
    
    companion object
}

/**
 * @suppress
 */
public object FfiConverterTypeZenEngineResponse: FfiConverterRustBuffer<ZenEngineResponse> {
    override fun read(buf: ByteBuffer): ZenEngineResponse {
        return ZenEngineResponse(
            FfiConverterString.read(buf),
            FfiConverterTypeJsonBuffer.read(buf),
            FfiConverterOptionalMapStringTypeZenEngineTrace.read(buf),
        )
    }

    override fun allocationSize(value: ZenEngineResponse) = (
            FfiConverterString.allocationSize(value.`performance`) +
            FfiConverterTypeJsonBuffer.allocationSize(value.`result`) +
            FfiConverterOptionalMapStringTypeZenEngineTrace.allocationSize(value.`trace`)
    )

    override fun write(value: ZenEngineResponse, buf: ByteBuffer) {
            FfiConverterString.write(value.`performance`, buf)
            FfiConverterTypeJsonBuffer.write(value.`result`, buf)
            FfiConverterOptionalMapStringTypeZenEngineTrace.write(value.`trace`, buf)
    }
}



data class ZenEngineTrace (
    val `id`: kotlin.String, 
    val `name`: kotlin.String, 
    val `input`: JsonBuffer, 
    val `output`: JsonBuffer, 
    val `performance`: kotlin.String?, 
    val `traceData`: JsonBuffer?, 
    val `order`: kotlin.UInt
) {
    
    companion object
}

/**
 * @suppress
 */
public object FfiConverterTypeZenEngineTrace: FfiConverterRustBuffer<ZenEngineTrace> {
    override fun read(buf: ByteBuffer): ZenEngineTrace {
        return ZenEngineTrace(
            FfiConverterString.read(buf),
            FfiConverterString.read(buf),
            FfiConverterTypeJsonBuffer.read(buf),
            FfiConverterTypeJsonBuffer.read(buf),
            FfiConverterOptionalString.read(buf),
            FfiConverterOptionalTypeJsonBuffer.read(buf),
            FfiConverterUInt.read(buf),
        )
    }

    override fun allocationSize(value: ZenEngineTrace) = (
            FfiConverterString.allocationSize(value.`id`) +
            FfiConverterString.allocationSize(value.`name`) +
            FfiConverterTypeJsonBuffer.allocationSize(value.`input`) +
            FfiConverterTypeJsonBuffer.allocationSize(value.`output`) +
            FfiConverterOptionalString.allocationSize(value.`performance`) +
            FfiConverterOptionalTypeJsonBuffer.allocationSize(value.`traceData`) +
            FfiConverterUInt.allocationSize(value.`order`)
    )

    override fun write(value: ZenEngineTrace, buf: ByteBuffer) {
            FfiConverterString.write(value.`id`, buf)
            FfiConverterString.write(value.`name`, buf)
            FfiConverterTypeJsonBuffer.write(value.`input`, buf)
            FfiConverterTypeJsonBuffer.write(value.`output`, buf)
            FfiConverterOptionalString.write(value.`performance`, buf)
            FfiConverterOptionalTypeJsonBuffer.write(value.`traceData`, buf)
            FfiConverterUInt.write(value.`order`, buf)
    }
}



data class ZenEvaluateOptions (
    val `maxDepth`: kotlin.UByte?, 
    val `trace`: kotlin.Boolean?
) {
    
    companion object
}

/**
 * @suppress
 */
public object FfiConverterTypeZenEvaluateOptions: FfiConverterRustBuffer<ZenEvaluateOptions> {
    override fun read(buf: ByteBuffer): ZenEvaluateOptions {
        return ZenEvaluateOptions(
            FfiConverterOptionalUByte.read(buf),
            FfiConverterOptionalBoolean.read(buf),
        )
    }

    override fun allocationSize(value: ZenEvaluateOptions) = (
            FfiConverterOptionalUByte.allocationSize(value.`maxDepth`) +
            FfiConverterOptionalBoolean.allocationSize(value.`trace`)
    )

    override fun write(value: ZenEvaluateOptions, buf: ByteBuffer) {
            FfiConverterOptionalUByte.write(value.`maxDepth`, buf)
            FfiConverterOptionalBoolean.write(value.`trace`, buf)
    }
}





sealed class ZenException: kotlin.Exception() {
    
    class Zero(
        ) : ZenException() {
        override val message
            get() = ""
    }
    
    class InvalidArgument(
        ) : ZenException() {
        override val message
            get() = ""
    }
    
    class StringNullException(
        ) : ZenException() {
        override val message
            get() = ""
    }
    
    class StringUtf8Exception(
        ) : ZenException() {
        override val message
            get() = ""
    }
    
    class JsonSerializationFailed(
        ) : ZenException() {
        override val message
            get() = ""
    }
    
    class JsonDeserializationFailed(
        ) : ZenException() {
        override val message
            get() = ""
    }
    
    class ExecutionTaskSpawnException(
        ) : ZenException() {
        override val message
            get() = ""
    }
    
    class IsolateException(
        
        val v1: kotlin.String
        ) : ZenException() {
        override val message
            get() = "v1=${ v1 }"
    }
    
    class EvaluationException(
        
        val v1: kotlin.String
        ) : ZenException() {
        override val message
            get() = "v1=${ v1 }"
    }
    
    class ValidationException(
        
        val v1: kotlin.String
        ) : ZenException() {
        override val message
            get() = "v1=${ v1 }"
    }
    
    class LoaderKeyNotFound(
        
        val `key`: kotlin.String
        ) : ZenException() {
        override val message
            get() = "key=${ `key` }"
    }
    
    class LoaderInternalException(
        
        val `key`: kotlin.String, 
        
        val `details`: kotlin.String
        ) : ZenException() {
        override val message
            get() = "key=${ `key` }, details=${ `details` }"
    }
    
    class TemplateEngineException(
        
        val `template`: kotlin.String, 
        
        val `details`: kotlin.String
        ) : ZenException() {
        override val message
            get() = "template=${ `template` }, details=${ `details` }"
    }
    

    companion object ErrorHandler : UniffiRustCallStatusErrorHandler<ZenException> {
        override fun lift(error_buf: RustBuffer.ByValue): ZenException = FfiConverterTypeZenError.lift(error_buf)
    }

    
}

/**
 * @suppress
 */
public object FfiConverterTypeZenError : FfiConverterRustBuffer<ZenException> {
    override fun read(buf: ByteBuffer): ZenException {
        

        return when(buf.getInt()) {
            1 -> ZenException.Zero()
            2 -> ZenException.InvalidArgument()
            3 -> ZenException.StringNullException()
            4 -> ZenException.StringUtf8Exception()
            5 -> ZenException.JsonSerializationFailed()
            6 -> ZenException.JsonDeserializationFailed()
            7 -> ZenException.ExecutionTaskSpawnException()
            8 -> ZenException.IsolateException(
                FfiConverterString.read(buf),
                )
            9 -> ZenException.EvaluationException(
                FfiConverterString.read(buf),
                )
            10 -> ZenException.ValidationException(
                FfiConverterString.read(buf),
                )
            11 -> ZenException.LoaderKeyNotFound(
                FfiConverterString.read(buf),
                )
            12 -> ZenException.LoaderInternalException(
                FfiConverterString.read(buf),
                FfiConverterString.read(buf),
                )
            13 -> ZenException.TemplateEngineException(
                FfiConverterString.read(buf),
                FfiConverterString.read(buf),
                )
            else -> throw RuntimeException("invalid error enum value, something is very wrong!!")
        }
    }

    override fun allocationSize(value: ZenException): ULong {
        return when(value) {
            is ZenException.Zero -> (
                // Add the size for the Int that specifies the variant plus the size needed for all fields
                4UL
            )
            is ZenException.InvalidArgument -> (
                // Add the size for the Int that specifies the variant plus the size needed for all fields
                4UL
            )
            is ZenException.StringNullException -> (
                // Add the size for the Int that specifies the variant plus the size needed for all fields
                4UL
            )
            is ZenException.StringUtf8Exception -> (
                // Add the size for the Int that specifies the variant plus the size needed for all fields
                4UL
            )
            is ZenException.JsonSerializationFailed -> (
                // Add the size for the Int that specifies the variant plus the size needed for all fields
                4UL
            )
            is ZenException.JsonDeserializationFailed -> (
                // Add the size for the Int that specifies the variant plus the size needed for all fields
                4UL
            )
            is ZenException.ExecutionTaskSpawnException -> (
                // Add the size for the Int that specifies the variant plus the size needed for all fields
                4UL
            )
            is ZenException.IsolateException -> (
                // Add the size for the Int that specifies the variant plus the size needed for all fields
                4UL
                + FfiConverterString.allocationSize(value.v1)
            )
            is ZenException.EvaluationException -> (
                // Add the size for the Int that specifies the variant plus the size needed for all fields
                4UL
                + FfiConverterString.allocationSize(value.v1)
            )
            is ZenException.ValidationException -> (
                // Add the size for the Int that specifies the variant plus the size needed for all fields
                4UL
                + FfiConverterString.allocationSize(value.v1)
            )
            is ZenException.LoaderKeyNotFound -> (
                // Add the size for the Int that specifies the variant plus the size needed for all fields
                4UL
                + FfiConverterString.allocationSize(value.`key`)
            )
            is ZenException.LoaderInternalException -> (
                // Add the size for the Int that specifies the variant plus the size needed for all fields
                4UL
                + FfiConverterString.allocationSize(value.`key`)
                + FfiConverterString.allocationSize(value.`details`)
            )
            is ZenException.TemplateEngineException -> (
                // Add the size for the Int that specifies the variant plus the size needed for all fields
                4UL
                + FfiConverterString.allocationSize(value.`template`)
                + FfiConverterString.allocationSize(value.`details`)
            )
        }
    }

    override fun write(value: ZenException, buf: ByteBuffer) {
        when(value) {
            is ZenException.Zero -> {
                buf.putInt(1)
                Unit
            }
            is ZenException.InvalidArgument -> {
                buf.putInt(2)
                Unit
            }
            is ZenException.StringNullException -> {
                buf.putInt(3)
                Unit
            }
            is ZenException.StringUtf8Exception -> {
                buf.putInt(4)
                Unit
            }
            is ZenException.JsonSerializationFailed -> {
                buf.putInt(5)
                Unit
            }
            is ZenException.JsonDeserializationFailed -> {
                buf.putInt(6)
                Unit
            }
            is ZenException.ExecutionTaskSpawnException -> {
                buf.putInt(7)
                Unit
            }
            is ZenException.IsolateException -> {
                buf.putInt(8)
                FfiConverterString.write(value.v1, buf)
                Unit
            }
            is ZenException.EvaluationException -> {
                buf.putInt(9)
                FfiConverterString.write(value.v1, buf)
                Unit
            }
            is ZenException.ValidationException -> {
                buf.putInt(10)
                FfiConverterString.write(value.v1, buf)
                Unit
            }
            is ZenException.LoaderKeyNotFound -> {
                buf.putInt(11)
                FfiConverterString.write(value.`key`, buf)
                Unit
            }
            is ZenException.LoaderInternalException -> {
                buf.putInt(12)
                FfiConverterString.write(value.`key`, buf)
                FfiConverterString.write(value.`details`, buf)
                Unit
            }
            is ZenException.TemplateEngineException -> {
                buf.putInt(13)
                FfiConverterString.write(value.`template`, buf)
                FfiConverterString.write(value.`details`, buf)
                Unit
            }
        }.let { /* this makes the `when` an expression, which ensures it is exhaustive */ }
    }

}





public interface ZenCustomNodeCallback {
    
    suspend fun `handle`(`key`: ZenEngineHandlerRequest): ZenEngineHandlerResponse
    
    companion object
}



// Put the implementation in an object so we don't pollute the top-level namespace
internal object uniffiCallbackInterfaceZenCustomNodeCallback {
    internal object `handle`: UniffiCallbackInterfaceZenCustomNodeCallbackMethod0 {
        override fun callback(`uniffiHandle`: Long,`key`: RustBuffer.ByValue,`uniffiFutureCallback`: UniffiForeignFutureCompleteRustBuffer,`uniffiCallbackData`: Long,`uniffiOutReturn`: UniffiForeignFuture,) {
            val uniffiObj = FfiConverterTypeZenCustomNodeCallback.handleMap.get(uniffiHandle)
            val makeCall = suspend { ->
                uniffiObj.`handle`(
                    FfiConverterTypeZenEngineHandlerRequest.lift(`key`),
                )
            }
            val uniffiHandleSuccess = { returnValue: ZenEngineHandlerResponse ->
                val uniffiResult = UniffiForeignFutureStructRustBuffer.UniffiByValue(
                    FfiConverterTypeZenEngineHandlerResponse.lower(returnValue),
                    UniffiRustCallStatus.ByValue()
                )
                uniffiResult.write()
                uniffiFutureCallback.callback(uniffiCallbackData, uniffiResult)
            }
            val uniffiHandleError = { callStatus: UniffiRustCallStatus.ByValue ->
                uniffiFutureCallback.callback(
                    uniffiCallbackData,
                    UniffiForeignFutureStructRustBuffer.UniffiByValue(
                        RustBuffer.ByValue(),
                        callStatus,
                    ),
                )
            }

            uniffiOutReturn.uniffiSetValue(
                uniffiTraitInterfaceCallAsyncWithError(
                    makeCall,
                    uniffiHandleSuccess,
                    uniffiHandleError,
                    { e: ZenException -> FfiConverterTypeZenError.lower(e) }
                )
            )
        }
    }

    internal object uniffiFree: UniffiCallbackInterfaceFree {
        override fun callback(handle: Long) {
            FfiConverterTypeZenCustomNodeCallback.handleMap.remove(handle)
        }
    }

    internal var vtable = UniffiVTableCallbackInterfaceZenCustomNodeCallback.UniffiByValue(
        `handle`,
        uniffiFree,
    )

    // Registers the foreign callback with the Rust side.
    // This method is generated for each callback interface.
    internal fun register(lib: UniffiLib) {
        lib.uniffi_zen_uniffi_fn_init_callback_vtable_zencustomnodecallback(vtable)
    }
}

/**
 * The ffiConverter which transforms the Callbacks in to handles to pass to Rust.
 *
 * @suppress
 */
public object FfiConverterTypeZenCustomNodeCallback: FfiConverterCallbackInterface<ZenCustomNodeCallback>()





public interface ZenDecisionLoaderCallback {
    
    suspend fun `load`(`key`: kotlin.String): JsonBuffer?
    
    companion object
}



// Put the implementation in an object so we don't pollute the top-level namespace
internal object uniffiCallbackInterfaceZenDecisionLoaderCallback {
    internal object `load`: UniffiCallbackInterfaceZenDecisionLoaderCallbackMethod0 {
        override fun callback(`uniffiHandle`: Long,`key`: RustBuffer.ByValue,`uniffiFutureCallback`: UniffiForeignFutureCompleteRustBuffer,`uniffiCallbackData`: Long,`uniffiOutReturn`: UniffiForeignFuture,) {
            val uniffiObj = FfiConverterTypeZenDecisionLoaderCallback.handleMap.get(uniffiHandle)
            val makeCall = suspend { ->
                uniffiObj.`load`(
                    FfiConverterString.lift(`key`),
                )
            }
            val uniffiHandleSuccess = { returnValue: JsonBuffer? ->
                val uniffiResult = UniffiForeignFutureStructRustBuffer.UniffiByValue(
                    FfiConverterOptionalTypeJsonBuffer.lower(returnValue),
                    UniffiRustCallStatus.ByValue()
                )
                uniffiResult.write()
                uniffiFutureCallback.callback(uniffiCallbackData, uniffiResult)
            }
            val uniffiHandleError = { callStatus: UniffiRustCallStatus.ByValue ->
                uniffiFutureCallback.callback(
                    uniffiCallbackData,
                    UniffiForeignFutureStructRustBuffer.UniffiByValue(
                        RustBuffer.ByValue(),
                        callStatus,
                    ),
                )
            }

            uniffiOutReturn.uniffiSetValue(
                uniffiTraitInterfaceCallAsyncWithError(
                    makeCall,
                    uniffiHandleSuccess,
                    uniffiHandleError,
                    { e: ZenException -> FfiConverterTypeZenError.lower(e) }
                )
            )
        }
    }

    internal object uniffiFree: UniffiCallbackInterfaceFree {
        override fun callback(handle: Long) {
            FfiConverterTypeZenDecisionLoaderCallback.handleMap.remove(handle)
        }
    }

    internal var vtable = UniffiVTableCallbackInterfaceZenDecisionLoaderCallback.UniffiByValue(
        `load`,
        uniffiFree,
    )

    // Registers the foreign callback with the Rust side.
    // This method is generated for each callback interface.
    internal fun register(lib: UniffiLib) {
        lib.uniffi_zen_uniffi_fn_init_callback_vtable_zendecisionloadercallback(vtable)
    }
}

/**
 * The ffiConverter which transforms the Callbacks in to handles to pass to Rust.
 *
 * @suppress
 */
public object FfiConverterTypeZenDecisionLoaderCallback: FfiConverterCallbackInterface<ZenDecisionLoaderCallback>()




/**
 * @suppress
 */
public object FfiConverterOptionalUByte: FfiConverterRustBuffer<kotlin.UByte?> {
    override fun read(buf: ByteBuffer): kotlin.UByte? {
        if (buf.get().toInt() == 0) {
            return null
        }
        return FfiConverterUByte.read(buf)
    }

    override fun allocationSize(value: kotlin.UByte?): ULong {
        if (value == null) {
            return 1UL
        } else {
            return 1UL + FfiConverterUByte.allocationSize(value)
        }
    }

    override fun write(value: kotlin.UByte?, buf: ByteBuffer) {
        if (value == null) {
            buf.put(0)
        } else {
            buf.put(1)
            FfiConverterUByte.write(value, buf)
        }
    }
}




/**
 * @suppress
 */
public object FfiConverterOptionalBoolean: FfiConverterRustBuffer<kotlin.Boolean?> {
    override fun read(buf: ByteBuffer): kotlin.Boolean? {
        if (buf.get().toInt() == 0) {
            return null
        }
        return FfiConverterBoolean.read(buf)
    }

    override fun allocationSize(value: kotlin.Boolean?): ULong {
        if (value == null) {
            return 1UL
        } else {
            return 1UL + FfiConverterBoolean.allocationSize(value)
        }
    }

    override fun write(value: kotlin.Boolean?, buf: ByteBuffer) {
        if (value == null) {
            buf.put(0)
        } else {
            buf.put(1)
            FfiConverterBoolean.write(value, buf)
        }
    }
}




/**
 * @suppress
 */
public object FfiConverterOptionalString: FfiConverterRustBuffer<kotlin.String?> {
    override fun read(buf: ByteBuffer): kotlin.String? {
        if (buf.get().toInt() == 0) {
            return null
        }
        return FfiConverterString.read(buf)
    }

    override fun allocationSize(value: kotlin.String?): ULong {
        if (value == null) {
            return 1UL
        } else {
            return 1UL + FfiConverterString.allocationSize(value)
        }
    }

    override fun write(value: kotlin.String?, buf: ByteBuffer) {
        if (value == null) {
            buf.put(0)
        } else {
            buf.put(1)
            FfiConverterString.write(value, buf)
        }
    }
}




/**
 * @suppress
 */
public object FfiConverterOptionalTypeZenEvaluateOptions: FfiConverterRustBuffer<ZenEvaluateOptions?> {
    override fun read(buf: ByteBuffer): ZenEvaluateOptions? {
        if (buf.get().toInt() == 0) {
            return null
        }
        return FfiConverterTypeZenEvaluateOptions.read(buf)
    }

    override fun allocationSize(value: ZenEvaluateOptions?): ULong {
        if (value == null) {
            return 1UL
        } else {
            return 1UL + FfiConverterTypeZenEvaluateOptions.allocationSize(value)
        }
    }

    override fun write(value: ZenEvaluateOptions?, buf: ByteBuffer) {
        if (value == null) {
            buf.put(0)
        } else {
            buf.put(1)
            FfiConverterTypeZenEvaluateOptions.write(value, buf)
        }
    }
}




/**
 * @suppress
 */
public object FfiConverterOptionalTypeZenCustomNodeCallback: FfiConverterRustBuffer<ZenCustomNodeCallback?> {
    override fun read(buf: ByteBuffer): ZenCustomNodeCallback? {
        if (buf.get().toInt() == 0) {
            return null
        }
        return FfiConverterTypeZenCustomNodeCallback.read(buf)
    }

    override fun allocationSize(value: ZenCustomNodeCallback?): ULong {
        if (value == null) {
            return 1UL
        } else {
            return 1UL + FfiConverterTypeZenCustomNodeCallback.allocationSize(value)
        }
    }

    override fun write(value: ZenCustomNodeCallback?, buf: ByteBuffer) {
        if (value == null) {
            buf.put(0)
        } else {
            buf.put(1)
            FfiConverterTypeZenCustomNodeCallback.write(value, buf)
        }
    }
}




/**
 * @suppress
 */
public object FfiConverterOptionalTypeZenDecisionLoaderCallback: FfiConverterRustBuffer<ZenDecisionLoaderCallback?> {
    override fun read(buf: ByteBuffer): ZenDecisionLoaderCallback? {
        if (buf.get().toInt() == 0) {
            return null
        }
        return FfiConverterTypeZenDecisionLoaderCallback.read(buf)
    }

    override fun allocationSize(value: ZenDecisionLoaderCallback?): ULong {
        if (value == null) {
            return 1UL
        } else {
            return 1UL + FfiConverterTypeZenDecisionLoaderCallback.allocationSize(value)
        }
    }

    override fun write(value: ZenDecisionLoaderCallback?, buf: ByteBuffer) {
        if (value == null) {
            buf.put(0)
        } else {
            buf.put(1)
            FfiConverterTypeZenDecisionLoaderCallback.write(value, buf)
        }
    }
}




/**
 * @suppress
 */
public object FfiConverterOptionalMapStringTypeZenEngineTrace: FfiConverterRustBuffer<Map<kotlin.String, ZenEngineTrace>?> {
    override fun read(buf: ByteBuffer): Map<kotlin.String, ZenEngineTrace>? {
        if (buf.get().toInt() == 0) {
            return null
        }
        return FfiConverterMapStringTypeZenEngineTrace.read(buf)
    }

    override fun allocationSize(value: Map<kotlin.String, ZenEngineTrace>?): ULong {
        if (value == null) {
            return 1UL
        } else {
            return 1UL + FfiConverterMapStringTypeZenEngineTrace.allocationSize(value)
        }
    }

    override fun write(value: Map<kotlin.String, ZenEngineTrace>?, buf: ByteBuffer) {
        if (value == null) {
            buf.put(0)
        } else {
            buf.put(1)
            FfiConverterMapStringTypeZenEngineTrace.write(value, buf)
        }
    }
}




/**
 * @suppress
 */
public object FfiConverterOptionalTypeJsonBuffer: FfiConverterRustBuffer<JsonBuffer?> {
    override fun read(buf: ByteBuffer): JsonBuffer? {
        if (buf.get().toInt() == 0) {
            return null
        }
        return FfiConverterTypeJsonBuffer.read(buf)
    }

    override fun allocationSize(value: JsonBuffer?): ULong {
        if (value == null) {
            return 1UL
        } else {
            return 1UL + FfiConverterTypeJsonBuffer.allocationSize(value)
        }
    }

    override fun write(value: JsonBuffer?, buf: ByteBuffer) {
        if (value == null) {
            buf.put(0)
        } else {
            buf.put(1)
            FfiConverterTypeJsonBuffer.write(value, buf)
        }
    }
}




/**
 * @suppress
 */
public object FfiConverterMapStringTypeZenEngineTrace: FfiConverterRustBuffer<Map<kotlin.String, ZenEngineTrace>> {
    override fun read(buf: ByteBuffer): Map<kotlin.String, ZenEngineTrace> {
        val len = buf.getInt()
        return buildMap<kotlin.String, ZenEngineTrace>(len) {
            repeat(len) {
                val k = FfiConverterString.read(buf)
                val v = FfiConverterTypeZenEngineTrace.read(buf)
                this[k] = v
            }
        }
    }

    override fun allocationSize(value: Map<kotlin.String, ZenEngineTrace>): ULong {
        val spaceForMapSize = 4UL
        val spaceForChildren = value.map { (k, v) ->
            FfiConverterString.allocationSize(k) +
            FfiConverterTypeZenEngineTrace.allocationSize(v)
        }.sum()
        return spaceForMapSize + spaceForChildren
    }

    override fun write(value: Map<kotlin.String, ZenEngineTrace>, buf: ByteBuffer) {
        buf.putInt(value.size)
        // The parens on `(k, v)` here ensure we're calling the right method,
        // which is important for compatibility with older android devices.
        // Ref https://blog.danlew.net/2017/03/16/kotlin-puzzler-whose-line-is-it-anyways/
        value.forEach { (k, v) ->
            FfiConverterString.write(k, buf)
            FfiConverterTypeZenEngineTrace.write(v, buf)
        }
    }
}






/**
 * @suppress
 */
public object FfiConverterTypeJsonBuffer: FfiConverter<JsonBuffer, RustBuffer.ByValue> {
    override fun lift(value: RustBuffer.ByValue): JsonBuffer {
        val builtinValue = FfiConverterByteArray.lift(value)
        return JsonBuffer(builtinValue)
    }

    override fun lower(value: JsonBuffer): RustBuffer.ByValue {
        val builtinValue = value.value
        return FfiConverterByteArray.lower(builtinValue)
    }

    override fun read(buf: ByteBuffer): JsonBuffer {
        val builtinValue = FfiConverterByteArray.read(buf)
        return JsonBuffer(builtinValue)
    }

    override fun allocationSize(value: JsonBuffer): ULong {
        val builtinValue = value.value
        return FfiConverterByteArray.allocationSize(builtinValue)
    }

    override fun write(value: JsonBuffer, buf: ByteBuffer) {
        val builtinValue = value.value
        FfiConverterByteArray.write(builtinValue, buf)
    }
}








    @Throws(ZenException::class) fun `evaluateExpression`(`expression`: kotlin.String, `context`: JsonBuffer?): JsonBuffer {
            return FfiConverterTypeJsonBuffer.lift(
    uniffiRustCallWithError(ZenException) { _status ->
    UniffiLib.INSTANCE.uniffi_zen_uniffi_fn_func_evaluate_expression(
        FfiConverterString.lower(`expression`),FfiConverterOptionalTypeJsonBuffer.lower(`context`),_status)
}
    )
    }
    

    @Throws(ZenException::class) fun `evaluateUnaryExpression`(`expression`: kotlin.String, `context`: JsonBuffer): kotlin.Boolean {
            return FfiConverterBoolean.lift(
    uniffiRustCallWithError(ZenException) { _status ->
    UniffiLib.INSTANCE.uniffi_zen_uniffi_fn_func_evaluate_unary_expression(
        FfiConverterString.lower(`expression`),FfiConverterTypeJsonBuffer.lower(`context`),_status)
}
    )
    }
    
 fun `overrideConfig`(`config`: ZenConfig)
        = 
    uniffiRustCall() { _status ->
    UniffiLib.INSTANCE.uniffi_zen_uniffi_fn_func_override_config(
        FfiConverterTypeZenConfig.lower(`config`),_status)
}
    
    


