package io.github.vigoo.zioaws.sso.model
import java.lang.Integer
import io.github.vigoo.zioaws.sso.model.primitives.{
  AccountIdType,
  AccessTokenType,
  MaxResultType,
  NextTokenType
}
import zio.ZIO
import io.github.vigoo.zioaws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters.*
final case class ListAccountRolesRequest(
    nextToken: Option[NextTokenType] = None,
    maxResults: Option[MaxResultType] = None,
    accessToken: AccessTokenType,
    accountId: AccountIdType
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.sso.model.ListAccountRolesRequest = {
    import ListAccountRolesRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.sso.model.ListAccountRolesRequest
      .builder()
      .optionallyWith(nextToken.map(value => value: java.lang.String))(
        _.nextToken
      )
      .optionallyWith(maxResults.map(value => value: Integer))(_.maxResults)
      .accessToken(accessToken: java.lang.String)
      .accountId(accountId: java.lang.String)
      .build()
  }
  def asReadOnly
      : io.github.vigoo.zioaws.sso.model.ListAccountRolesRequest.ReadOnly =
    io.github.vigoo.zioaws.sso.model.ListAccountRolesRequest
      .wrap(buildAwsValue())
}
object ListAccountRolesRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.sso.model.ListAccountRolesRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def editable: io.github.vigoo.zioaws.sso.model.ListAccountRolesRequest =
      io.github.vigoo.zioaws.sso.model.ListAccountRolesRequest(
        nextTokenValue.map(value => value),
        maxResultsValue.map(value => value),
        accessTokenValue,
        accountIdValue
      )
    def nextTokenValue: Option[NextTokenType]
    def maxResultsValue: Option[MaxResultType]
    def accessTokenValue: AccessTokenType
    def accountIdValue: AccountIdType
    def nextToken: ZIO[Any, AwsError, NextTokenType] =
      AwsError.unwrapOptionField("nextToken", nextTokenValue)
    def maxResults: ZIO[Any, AwsError, MaxResultType] =
      AwsError.unwrapOptionField("maxResults", maxResultsValue)
    def accessToken: ZIO[Any, Nothing, AccessTokenType] =
      ZIO.succeed(accessTokenValue)
    def accountId: ZIO[Any, Nothing, AccountIdType] =
      ZIO.succeed(accountIdValue)
  }
  private class Wrapper(
      impl: software.amazon.awssdk.services.sso.model.ListAccountRolesRequest
  ) extends io.github.vigoo.zioaws.sso.model.ListAccountRolesRequest.ReadOnly {
    override def nextTokenValue: Option[NextTokenType] =
      scala.Option(impl.nextToken()).map(value => value: NextTokenType)
    override def maxResultsValue: Option[MaxResultType] =
      scala.Option(impl.maxResults()).map(value => value: MaxResultType)
    override def accessTokenValue: AccessTokenType =
      impl.accessToken(): AccessTokenType
    override def accountIdValue: AccountIdType = impl.accountId(): AccountIdType
  }
  def wrap(
      impl: software.amazon.awssdk.services.sso.model.ListAccountRolesRequest
  ): io.github.vigoo.zioaws.sso.model.ListAccountRolesRequest.ReadOnly =
    new Wrapper(impl)
}
