package io.github.vigoo.zioaws.sso.model
import scala.jdk.CollectionConverters.*
import java.time.Instant
import zio.{ Chunk, ZIO }
import software.amazon.awssdk.core.SdkBytes
final case class RoleInfo(roleName: scala.Option[primitives.RoleNameType] = None, accountId: scala.Option[primitives.AccountIdType] = None) {
  def buildAwsValue(): software.amazon.awssdk.services.sso.model.RoleInfo = {
    import RoleInfo.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.sso.model.RoleInfo.builder().optionallyWith(roleName.map(value => value: java.lang.String))(_.roleName).optionallyWith(accountId.map(value => value: java.lang.String))(_.accountId).build()
  }
  def asReadOnly: RoleInfo.ReadOnly = RoleInfo.wrap(buildAwsValue())
}
object RoleInfo {
  private lazy val zioAwsBuilderHelper: io.github.vigoo.zioaws.core.BuilderHelper[software.amazon.awssdk.services.sso.model.RoleInfo] = io.github.vigoo.zioaws.core.BuilderHelper.apply
  trait ReadOnly {
    def editable: RoleInfo = RoleInfo(roleNameValue.map(value => value), accountIdValue.map(value => value))
    def roleNameValue: scala.Option[primitives.RoleNameType]
    def accountIdValue: scala.Option[primitives.AccountIdType]
    def roleName: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, primitives.RoleNameType] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("roleName", roleNameValue)
    def accountId: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, primitives.AccountIdType] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("accountId", accountIdValue)
  }
  private class Wrapper(impl: software.amazon.awssdk.services.sso.model.RoleInfo) extends RoleInfo.ReadOnly {
    override def roleNameValue: scala.Option[primitives.RoleNameType] = scala.Option(impl.roleName()).map(value => value: primitives.RoleNameType)
    override def accountIdValue: scala.Option[primitives.AccountIdType] = scala.Option(impl.accountId()).map(value => value: primitives.AccountIdType)
  }
  def wrap(impl: software.amazon.awssdk.services.sso.model.RoleInfo): ReadOnly = new Wrapper(impl)
}