package io.github.vigoo.zioaws.sso.model
import scala.jdk.CollectionConverters.*
import java.time.Instant
import zio.{ Chunk, ZIO }
import software.amazon.awssdk.core.SdkBytes
final case class GetRoleCredentialsResponse(roleCredentials: scala.Option[RoleCredentials] = None) {
  def buildAwsValue(): software.amazon.awssdk.services.sso.model.GetRoleCredentialsResponse = {
    import GetRoleCredentialsResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.sso.model.GetRoleCredentialsResponse.builder().optionallyWith(roleCredentials.map(value => value.buildAwsValue()))(_.roleCredentials).build()
  }
  def asReadOnly: GetRoleCredentialsResponse.ReadOnly = GetRoleCredentialsResponse.wrap(buildAwsValue())
}
object GetRoleCredentialsResponse {
  private lazy val zioAwsBuilderHelper: io.github.vigoo.zioaws.core.BuilderHelper[software.amazon.awssdk.services.sso.model.GetRoleCredentialsResponse] = io.github.vigoo.zioaws.core.BuilderHelper.apply
  trait ReadOnly {
    def editable: GetRoleCredentialsResponse = GetRoleCredentialsResponse(roleCredentialsValue.map(value => value.editable))
    def roleCredentialsValue: scala.Option[RoleCredentials.ReadOnly]
    def roleCredentials: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, RoleCredentials.ReadOnly] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("roleCredentials", roleCredentialsValue)
  }
  private class Wrapper(impl: software.amazon.awssdk.services.sso.model.GetRoleCredentialsResponse) extends GetRoleCredentialsResponse.ReadOnly { override def roleCredentialsValue: scala.Option[RoleCredentials.ReadOnly] = scala.Option(impl.roleCredentials()).map(value => RoleCredentials.wrap(value)) }
  def wrap(impl: software.amazon.awssdk.services.sso.model.GetRoleCredentialsResponse): ReadOnly = new Wrapper(impl)
}