package io.github.vigoo.zioaws.sso.model
import scala.jdk.CollectionConverters.*
import java.time.Instant
import zio.{ Chunk, ZIO }
import software.amazon.awssdk.core.SdkBytes
final case class AccountInfo(accountId: scala.Option[primitives.AccountIdType] = None, accountName: scala.Option[primitives.AccountNameType] = None, emailAddress: scala.Option[primitives.EmailAddressType] = None) {
  def buildAwsValue(): software.amazon.awssdk.services.sso.model.AccountInfo = {
    import AccountInfo.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.sso.model.AccountInfo.builder().optionallyWith(accountId.map(value => value: java.lang.String))(_.accountId).optionallyWith(accountName.map(value => value: java.lang.String))(_.accountName).optionallyWith(emailAddress.map(value => value: java.lang.String))(_.emailAddress).build()
  }
  def asReadOnly: AccountInfo.ReadOnly = AccountInfo.wrap(buildAwsValue())
}
object AccountInfo {
  private lazy val zioAwsBuilderHelper: io.github.vigoo.zioaws.core.BuilderHelper[software.amazon.awssdk.services.sso.model.AccountInfo] = io.github.vigoo.zioaws.core.BuilderHelper.apply
  trait ReadOnly {
    def editable: AccountInfo = AccountInfo(accountIdValue.map(value => value), accountNameValue.map(value => value), emailAddressValue.map(value => value))
    def accountIdValue: scala.Option[primitives.AccountIdType]
    def accountNameValue: scala.Option[primitives.AccountNameType]
    def emailAddressValue: scala.Option[primitives.EmailAddressType]
    def accountId: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, primitives.AccountIdType] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("accountId", accountIdValue)
    def accountName: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, primitives.AccountNameType] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("accountName", accountNameValue)
    def emailAddress: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, primitives.EmailAddressType] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("emailAddress", emailAddressValue)
  }
  private class Wrapper(impl: software.amazon.awssdk.services.sso.model.AccountInfo) extends AccountInfo.ReadOnly {
    override def accountIdValue: scala.Option[primitives.AccountIdType] = scala.Option(impl.accountId()).map(value => value: primitives.AccountIdType)
    override def accountNameValue: scala.Option[primitives.AccountNameType] = scala.Option(impl.accountName()).map(value => value: primitives.AccountNameType)
    override def emailAddressValue: scala.Option[primitives.EmailAddressType] = scala.Option(impl.emailAddress()).map(value => value: primitives.EmailAddressType)
  }
  def wrap(impl: software.amazon.awssdk.services.sso.model.AccountInfo): ReadOnly = new Wrapper(impl)
}