package io.github.vigoo.zioaws
import io.github.vigoo.zioaws.core.*
import io.github.vigoo.zioaws.core.aspects.*
import io.github.vigoo.zioaws.core.config.AwsConfig
import io.github.vigoo.zioaws.core.httpclient.ServiceHttpCapabilities
import software.amazon.awssdk.core.client.config.{ ClientAsyncConfiguration, SdkAdvancedAsyncClientOption }
import software.amazon.awssdk.services.sso.paginators.*
import software.amazon.awssdk.services.sso.{ SsoAsyncClient, SsoAsyncClientBuilder }
import zio.{ Chunk, Has, IO, URLayer, ZIO, ZLayer, ZManaged }
import zio.stream.ZStream
import org.reactivestreams.Publisher
import scala.jdk.CollectionConverters.*
package object sso {
  type Sso = Has[Sso.Service]
  object Sso {
    trait Service extends AspectSupport[Service] {
      val api: SsoAsyncClient
      def getRoleCredentials(request: model.GetRoleCredentialsRequest): IO[AwsError, model.GetRoleCredentialsResponse.ReadOnly]
      def listAccountRoles(request: model.ListAccountRolesRequest): zio.stream.ZStream[Any, AwsError, model.RoleInfo.ReadOnly]
      def listAccounts(request: model.ListAccountsRequest): zio.stream.ZStream[Any, AwsError, model.AccountInfo.ReadOnly]
      def logout(request: model.LogoutRequest): IO[AwsError, scala.Unit]
    }
    object SsoMock extends zio.test.mock.Mock[Sso] {
      object GetRoleCredentials extends Effect[model.GetRoleCredentialsRequest, AwsError, model.GetRoleCredentialsResponse.ReadOnly]
      object ListAccountRoles extends Stream[model.ListAccountRolesRequest, AwsError, model.RoleInfo.ReadOnly]
      object ListAccounts extends Stream[model.ListAccountsRequest, AwsError, model.AccountInfo.ReadOnly]
      object Logout extends Effect[model.LogoutRequest, AwsError, scala.Unit]
      val compose: URLayer[Has[zio.test.mock.Proxy], Sso] = ZLayer.fromServiceM {
        proxy => withRuntime.map {
          rts => new Sso.Service {
            val api: SsoAsyncClient = null
            def withAspect[R1](newAspect: AwsCallAspect[R1], r: R1): Sso.Service = this
            def getRoleCredentials(request: model.GetRoleCredentialsRequest): IO[AwsError, model.GetRoleCredentialsResponse.ReadOnly] = proxy(GetRoleCredentials, request)
            def listAccountRoles(request: model.ListAccountRolesRequest): ZStream[Any, AwsError, model.RoleInfo.ReadOnly] = rts.unsafeRun(proxy(ListAccountRoles, request))
            def listAccounts(request: model.ListAccountsRequest): ZStream[Any, AwsError, model.AccountInfo.ReadOnly] = rts.unsafeRun(proxy(ListAccounts, request))
            def logout(request: model.LogoutRequest): IO[AwsError, scala.Unit] = proxy(Logout, request)
          }
        }
      }
    }
  }
  val live: ZLayer[AwsConfig, Throwable, Sso] = customized(identity)
  def customized(customization: SsoAsyncClientBuilder => SsoAsyncClientBuilder): ZLayer[AwsConfig, Throwable, Sso] = managed(customization).toLayer
  def managed(customization: SsoAsyncClientBuilder => SsoAsyncClientBuilder): ZManaged[AwsConfig, Throwable, Sso.Service] = for (awsConfig <- ZManaged.service[AwsConfig.Service]; executor <- ZIO.executor.toManaged_; builder = SsoAsyncClient.builder().asyncConfiguration(ClientAsyncConfiguration.builder().advancedOption(SdkAdvancedAsyncClientOption.FUTURE_COMPLETION_EXECUTOR, executor.asJava).build()); b0 <- awsConfig.configure[SsoAsyncClient, SsoAsyncClientBuilder](builder).toManaged_; b1 <- awsConfig.configureHttpClient[SsoAsyncClient, SsoAsyncClientBuilder](b0, ServiceHttpCapabilities(supportsHttp2 = false)).toManaged_; client <- ZIO(customization(b1).build()).toManaged_) yield new SsoImpl(client, AwsCallAspect.identity, ().asInstanceOf[Any])
  private class SsoImpl[R](override val api: SsoAsyncClient, override val aspect: AwsCallAspect[R], r: R) extends Sso.Service with AwsServiceBase[R, SsoImpl] {
    override val serviceName: String = "Sso"
    override def withAspect[R1](newAspect: AwsCallAspect[R1], r: R1): SsoImpl[R1] = new SsoImpl(api, newAspect, r)
    def getRoleCredentials(request: model.GetRoleCredentialsRequest): IO[AwsError, model.GetRoleCredentialsResponse.ReadOnly] = asyncRequestResponse[software.amazon.awssdk.services.sso.model.GetRoleCredentialsRequest, software.amazon.awssdk.services.sso.model.GetRoleCredentialsResponse]("getRoleCredentials", api.getRoleCredentials)(request.buildAwsValue()).map(model.GetRoleCredentialsResponse.wrap).provide(r)
    def listAccountRoles(request: model.ListAccountRolesRequest): zio.stream.ZStream[Any, AwsError, model.RoleInfo.ReadOnly] = asyncJavaPaginatedRequest[software.amazon.awssdk.services.sso.model.ListAccountRolesRequest, software.amazon.awssdk.services.sso.model.RoleInfo, software.amazon.awssdk.services.sso.paginators.ListAccountRolesPublisher]("listAccountRoles", api.listAccountRolesPaginator, _.roleList())(request.buildAwsValue()).map(item => model.RoleInfo.wrap(item)).provide(r)
    def listAccounts(request: model.ListAccountsRequest): zio.stream.ZStream[Any, AwsError, model.AccountInfo.ReadOnly] = asyncJavaPaginatedRequest[software.amazon.awssdk.services.sso.model.ListAccountsRequest, software.amazon.awssdk.services.sso.model.AccountInfo, software.amazon.awssdk.services.sso.paginators.ListAccountsPublisher]("listAccounts", api.listAccountsPaginator, _.accountList())(request.buildAwsValue()).map(item => model.AccountInfo.wrap(item)).provide(r)
    def logout(request: model.LogoutRequest): IO[AwsError, scala.Unit] = asyncRequestResponse[software.amazon.awssdk.services.sso.model.LogoutRequest, software.amazon.awssdk.services.sso.model.LogoutResponse]("logout", api.logout)(request.buildAwsValue()).unit.provide(r)
  }
  def getRoleCredentials(request: model.GetRoleCredentialsRequest): ZIO[Sso, AwsError, model.GetRoleCredentialsResponse.ReadOnly] = ZIO.accessM(_.get.getRoleCredentials(request))
  def listAccountRoles(request: model.ListAccountRolesRequest): zio.stream.ZStream[Sso, AwsError, model.RoleInfo.ReadOnly] = ZStream.accessStream(_.get.listAccountRoles(request))
  def listAccounts(request: model.ListAccountsRequest): zio.stream.ZStream[Sso, AwsError, model.AccountInfo.ReadOnly] = ZStream.accessStream(_.get.listAccounts(request))
  def logout(request: model.LogoutRequest): ZIO[Sso, AwsError, scala.Unit] = ZIO.accessM(_.get.logout(request))
}