package io.github.vigoo.zioaws.sso.model
import scala.jdk.CollectionConverters.*
import java.time.Instant
import zio.{ Chunk, ZIO }
import software.amazon.awssdk.core.SdkBytes
final case class ListAccountsResponse(nextToken: scala.Option[primitives.NextTokenType] = None, accountList: scala.Option[Iterable[AccountInfo]] = None) {
  def buildAwsValue(): software.amazon.awssdk.services.sso.model.ListAccountsResponse = {
    import ListAccountsResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.sso.model.ListAccountsResponse.builder().optionallyWith(nextToken.map(value => value: java.lang.String))(_.nextToken).optionallyWith(accountList.map(value => value.map { item => 
      item.buildAwsValue()
    }.asJavaCollection))(_.accountList).build()
  }
  def asReadOnly: ListAccountsResponse.ReadOnly = ListAccountsResponse.wrap(buildAwsValue())
}
object ListAccountsResponse {
  private lazy val zioAwsBuilderHelper: io.github.vigoo.zioaws.core.BuilderHelper[software.amazon.awssdk.services.sso.model.ListAccountsResponse] = io.github.vigoo.zioaws.core.BuilderHelper.apply
  trait ReadOnly {
    def editable: ListAccountsResponse = ListAccountsResponse(nextTokenValue.map(value => value), accountListValue.map(value => value.map { item => 
      item.editable
    }))
    def nextTokenValue: scala.Option[primitives.NextTokenType]
    def accountListValue: scala.Option[List[AccountInfo.ReadOnly]]
    def nextToken: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, primitives.NextTokenType] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("nextToken", nextTokenValue)
    def accountList: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, List[AccountInfo.ReadOnly]] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("accountList", accountListValue)
  }
  private class Wrapper(impl: software.amazon.awssdk.services.sso.model.ListAccountsResponse) extends ListAccountsResponse.ReadOnly {
    override def nextTokenValue: scala.Option[primitives.NextTokenType] = scala.Option(impl.nextToken()).map(value => value: primitives.NextTokenType)
    override def accountListValue: scala.Option[List[AccountInfo.ReadOnly]] = scala.Option(impl.accountList()).map(value => value.asScala.map { item => 
      AccountInfo.wrap(item)
    }.toList)
  }
  def wrap(impl: software.amazon.awssdk.services.sso.model.ListAccountsResponse): ReadOnly = new Wrapper(impl)
}