package io.github.vigoo.zioaws.sso.model
import scala.jdk.CollectionConverters.*
import java.time.Instant
import zio.{ Chunk, ZIO }
import software.amazon.awssdk.core.SdkBytes
final case class RoleCredentials(accessKeyId: scala.Option[primitives.AccessKeyType] = None, secretAccessKey: scala.Option[primitives.SecretAccessKeyType] = None, sessionToken: scala.Option[primitives.SessionTokenType] = None, expiration: scala.Option[primitives.ExpirationTimestampType] = None) {
  def buildAwsValue(): software.amazon.awssdk.services.sso.model.RoleCredentials = {
    import RoleCredentials.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.sso.model.RoleCredentials.builder().optionallyWith(accessKeyId.map(value => value: java.lang.String))(_.accessKeyId).optionallyWith(secretAccessKey.map(value => value: java.lang.String))(_.secretAccessKey).optionallyWith(sessionToken.map(value => value: java.lang.String))(_.sessionToken).optionallyWith(expiration.map(value => value: java.lang.Long))(_.expiration).build()
  }
  def asReadOnly: RoleCredentials.ReadOnly = RoleCredentials.wrap(buildAwsValue())
}
object RoleCredentials {
  private lazy val zioAwsBuilderHelper: io.github.vigoo.zioaws.core.BuilderHelper[software.amazon.awssdk.services.sso.model.RoleCredentials] = io.github.vigoo.zioaws.core.BuilderHelper.apply
  trait ReadOnly {
    def editable: RoleCredentials = RoleCredentials(accessKeyIdValue.map(value => value), secretAccessKeyValue.map(value => value), sessionTokenValue.map(value => value), expirationValue.map(value => value))
    def accessKeyIdValue: scala.Option[primitives.AccessKeyType]
    def secretAccessKeyValue: scala.Option[primitives.SecretAccessKeyType]
    def sessionTokenValue: scala.Option[primitives.SessionTokenType]
    def expirationValue: scala.Option[primitives.ExpirationTimestampType]
    def accessKeyId: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, primitives.AccessKeyType] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("accessKeyId", accessKeyIdValue)
    def secretAccessKey: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, primitives.SecretAccessKeyType] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("secretAccessKey", secretAccessKeyValue)
    def sessionToken: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, primitives.SessionTokenType] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("sessionToken", sessionTokenValue)
    def expiration: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, primitives.ExpirationTimestampType] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("expiration", expirationValue)
  }
  private class Wrapper(impl: software.amazon.awssdk.services.sso.model.RoleCredentials) extends RoleCredentials.ReadOnly {
    override def accessKeyIdValue: scala.Option[primitives.AccessKeyType] = scala.Option(impl.accessKeyId()).map(value => value: primitives.AccessKeyType)
    override def secretAccessKeyValue: scala.Option[primitives.SecretAccessKeyType] = scala.Option(impl.secretAccessKey()).map(value => value: primitives.SecretAccessKeyType)
    override def sessionTokenValue: scala.Option[primitives.SessionTokenType] = scala.Option(impl.sessionToken()).map(value => value: primitives.SessionTokenType)
    override def expirationValue: scala.Option[primitives.ExpirationTimestampType] = scala.Option(impl.expiration()).map(value => value: primitives.ExpirationTimestampType)
  }
  def wrap(impl: software.amazon.awssdk.services.sso.model.RoleCredentials): ReadOnly = new Wrapper(impl)
}