package io.github.vigoo.zioaws.sso.model
import scala.jdk.CollectionConverters.*
import java.time.Instant
import zio.{ Chunk, ZIO }
import software.amazon.awssdk.core.SdkBytes
final case class ListAccountRolesResponse(nextToken: scala.Option[primitives.NextTokenType] = None, roleList: scala.Option[Iterable[RoleInfo]] = None) {
  def buildAwsValue(): software.amazon.awssdk.services.sso.model.ListAccountRolesResponse = {
    import ListAccountRolesResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.sso.model.ListAccountRolesResponse.builder().optionallyWith(nextToken.map(value => value: java.lang.String))(_.nextToken).optionallyWith(roleList.map(value => value.map { item => 
      item.buildAwsValue()
    }.asJavaCollection))(_.roleList).build()
  }
  def asReadOnly: ListAccountRolesResponse.ReadOnly = ListAccountRolesResponse.wrap(buildAwsValue())
}
object ListAccountRolesResponse {
  private lazy val zioAwsBuilderHelper: io.github.vigoo.zioaws.core.BuilderHelper[software.amazon.awssdk.services.sso.model.ListAccountRolesResponse] = io.github.vigoo.zioaws.core.BuilderHelper.apply
  trait ReadOnly {
    def editable: ListAccountRolesResponse = ListAccountRolesResponse(nextTokenValue.map(value => value), roleListValue.map(value => value.map { item => 
      item.editable
    }))
    def nextTokenValue: scala.Option[primitives.NextTokenType]
    def roleListValue: scala.Option[List[RoleInfo.ReadOnly]]
    def nextToken: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, primitives.NextTokenType] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("nextToken", nextTokenValue)
    def roleList: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, List[RoleInfo.ReadOnly]] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("roleList", roleListValue)
  }
  private class Wrapper(impl: software.amazon.awssdk.services.sso.model.ListAccountRolesResponse) extends ListAccountRolesResponse.ReadOnly {
    override def nextTokenValue: scala.Option[primitives.NextTokenType] = scala.Option(impl.nextToken()).map(value => value: primitives.NextTokenType)
    override def roleListValue: scala.Option[List[RoleInfo.ReadOnly]] = scala.Option(impl.roleList()).map(value => value.asScala.map { item => 
      RoleInfo.wrap(item)
    }.toList)
  }
  def wrap(impl: software.amazon.awssdk.services.sso.model.ListAccountRolesResponse): ReadOnly = new Wrapper(impl)
}