package io.github.vigoo.zioaws.sso.model
import scala.jdk.CollectionConverters.*
import java.time.Instant
import zio.{ Chunk, ZIO }
import software.amazon.awssdk.core.SdkBytes
final case class GetRoleCredentialsRequest(roleName: primitives.RoleNameType, accountId: primitives.AccountIdType, accessToken: primitives.AccessTokenType) {
  def buildAwsValue(): software.amazon.awssdk.services.sso.model.GetRoleCredentialsRequest = {
    import GetRoleCredentialsRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.sso.model.GetRoleCredentialsRequest.builder().roleName(roleName: java.lang.String).accountId(accountId: java.lang.String).accessToken(accessToken: java.lang.String).build()
  }
  def asReadOnly: GetRoleCredentialsRequest.ReadOnly = GetRoleCredentialsRequest.wrap(buildAwsValue())
}
object GetRoleCredentialsRequest {
  private lazy val zioAwsBuilderHelper: io.github.vigoo.zioaws.core.BuilderHelper[software.amazon.awssdk.services.sso.model.GetRoleCredentialsRequest] = io.github.vigoo.zioaws.core.BuilderHelper.apply
  trait ReadOnly {
    def editable: GetRoleCredentialsRequest = GetRoleCredentialsRequest(roleNameValue, accountIdValue, accessTokenValue)
    def roleNameValue: primitives.RoleNameType
    def accountIdValue: primitives.AccountIdType
    def accessTokenValue: primitives.AccessTokenType
    def roleName: ZIO[Any, Nothing, primitives.RoleNameType] = ZIO.succeed(roleNameValue)
    def accountId: ZIO[Any, Nothing, primitives.AccountIdType] = ZIO.succeed(accountIdValue)
    def accessToken: ZIO[Any, Nothing, primitives.AccessTokenType] = ZIO.succeed(accessTokenValue)
  }
  private class Wrapper(impl: software.amazon.awssdk.services.sso.model.GetRoleCredentialsRequest) extends GetRoleCredentialsRequest.ReadOnly {
    override def roleNameValue: primitives.RoleNameType = impl.roleName(): primitives.RoleNameType
    override def accountIdValue: primitives.AccountIdType = impl.accountId(): primitives.AccountIdType
    override def accessTokenValue: primitives.AccessTokenType = impl.accessToken(): primitives.AccessTokenType
  }
  def wrap(impl: software.amazon.awssdk.services.sso.model.GetRoleCredentialsRequest): ReadOnly = new Wrapper(impl)
}