package io.github.vigoo.zioaws.sso.model
import scala.jdk.CollectionConverters.*
import java.time.Instant
import zio.{ Chunk, ZIO }
import software.amazon.awssdk.core.SdkBytes
final case class ListAccountRolesRequest(nextToken: scala.Option[primitives.NextTokenType] = None, maxResults: scala.Option[primitives.MaxResultType] = None, accessToken: primitives.AccessTokenType, accountId: primitives.AccountIdType) {
  def buildAwsValue(): software.amazon.awssdk.services.sso.model.ListAccountRolesRequest = {
    import ListAccountRolesRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.sso.model.ListAccountRolesRequest.builder().optionallyWith(nextToken.map(value => value: java.lang.String))(_.nextToken).optionallyWith(maxResults.map(value => value: java.lang.Integer))(_.maxResults).accessToken(accessToken: java.lang.String).accountId(accountId: java.lang.String).build()
  }
  def asReadOnly: ListAccountRolesRequest.ReadOnly = ListAccountRolesRequest.wrap(buildAwsValue())
}
object ListAccountRolesRequest {
  private lazy val zioAwsBuilderHelper: io.github.vigoo.zioaws.core.BuilderHelper[software.amazon.awssdk.services.sso.model.ListAccountRolesRequest] = io.github.vigoo.zioaws.core.BuilderHelper.apply
  trait ReadOnly {
    def editable: ListAccountRolesRequest = ListAccountRolesRequest(nextTokenValue.map(value => value), maxResultsValue.map(value => value), accessTokenValue, accountIdValue)
    def nextTokenValue: scala.Option[primitives.NextTokenType]
    def maxResultsValue: scala.Option[primitives.MaxResultType]
    def accessTokenValue: primitives.AccessTokenType
    def accountIdValue: primitives.AccountIdType
    def nextToken: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, primitives.NextTokenType] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("nextToken", nextTokenValue)
    def maxResults: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, primitives.MaxResultType] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("maxResults", maxResultsValue)
    def accessToken: ZIO[Any, Nothing, primitives.AccessTokenType] = ZIO.succeed(accessTokenValue)
    def accountId: ZIO[Any, Nothing, primitives.AccountIdType] = ZIO.succeed(accountIdValue)
  }
  private class Wrapper(impl: software.amazon.awssdk.services.sso.model.ListAccountRolesRequest) extends ListAccountRolesRequest.ReadOnly {
    override def nextTokenValue: scala.Option[primitives.NextTokenType] = scala.Option(impl.nextToken()).map(value => value: primitives.NextTokenType)
    override def maxResultsValue: scala.Option[primitives.MaxResultType] = scala.Option(impl.maxResults()).map(value => value: primitives.MaxResultType)
    override def accessTokenValue: primitives.AccessTokenType = impl.accessToken(): primitives.AccessTokenType
    override def accountIdValue: primitives.AccountIdType = impl.accountId(): primitives.AccountIdType
  }
  def wrap(impl: software.amazon.awssdk.services.sso.model.ListAccountRolesRequest): ReadOnly = new Wrapper(impl)
}