package io.github.vigoo.zioaws.sso.model
import scala.jdk.CollectionConverters.*
import java.time.Instant
import zio.{ Chunk, ZIO }
import software.amazon.awssdk.core.SdkBytes
final case class ListAccountsRequest(nextToken: scala.Option[primitives.NextTokenType] = None, maxResults: scala.Option[primitives.MaxResultType] = None, accessToken: primitives.AccessTokenType) {
  def buildAwsValue(): software.amazon.awssdk.services.sso.model.ListAccountsRequest = {
    import ListAccountsRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.sso.model.ListAccountsRequest.builder().optionallyWith(nextToken.map(value => value: java.lang.String))(_.nextToken).optionallyWith(maxResults.map(value => value: java.lang.Integer))(_.maxResults).accessToken(accessToken: java.lang.String).build()
  }
  def asReadOnly: ListAccountsRequest.ReadOnly = ListAccountsRequest.wrap(buildAwsValue())
}
object ListAccountsRequest {
  private lazy val zioAwsBuilderHelper: io.github.vigoo.zioaws.core.BuilderHelper[software.amazon.awssdk.services.sso.model.ListAccountsRequest] = io.github.vigoo.zioaws.core.BuilderHelper.apply
  trait ReadOnly {
    def editable: ListAccountsRequest = ListAccountsRequest(nextTokenValue.map(value => value), maxResultsValue.map(value => value), accessTokenValue)
    def nextTokenValue: scala.Option[primitives.NextTokenType]
    def maxResultsValue: scala.Option[primitives.MaxResultType]
    def accessTokenValue: primitives.AccessTokenType
    def nextToken: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, primitives.NextTokenType] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("nextToken", nextTokenValue)
    def maxResults: ZIO[Any, io.github.vigoo.zioaws.core.AwsError, primitives.MaxResultType] = io.github.vigoo.zioaws.core.AwsError.unwrapOptionField("maxResults", maxResultsValue)
    def accessToken: ZIO[Any, Nothing, primitives.AccessTokenType] = ZIO.succeed(accessTokenValue)
  }
  private class Wrapper(impl: software.amazon.awssdk.services.sso.model.ListAccountsRequest) extends ListAccountsRequest.ReadOnly {
    override def nextTokenValue: scala.Option[primitives.NextTokenType] = scala.Option(impl.nextToken()).map(value => value: primitives.NextTokenType)
    override def maxResultsValue: scala.Option[primitives.MaxResultType] = scala.Option(impl.maxResults()).map(value => value: primitives.MaxResultType)
    override def accessTokenValue: primitives.AccessTokenType = impl.accessToken(): primitives.AccessTokenType
  }
  def wrap(impl: software.amazon.awssdk.services.sso.model.ListAccountsRequest): ReadOnly = new Wrapper(impl)
}