package io.github.vigoo.zioaws.savingsplans.model
import java.lang.Integer
import io.github.vigoo.zioaws.savingsplans.model.primitives.{
  MaxResults,
  PaginationToken,
  SavingsPlanId
}
import zio.ZIO
import io.github.vigoo.zioaws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters.*
final case class DescribeSavingsPlanRatesRequest(
    savingsPlanId: SavingsPlanId,
    filters: Option[
      Iterable[io.github.vigoo.zioaws.savingsplans.model.SavingsPlanRateFilter]
    ] = None,
    nextToken: Option[PaginationToken] = None,
    maxResults: Option[MaxResults] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.savingsplans.model.DescribeSavingsPlanRatesRequest = {
    import DescribeSavingsPlanRatesRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.savingsplans.model.DescribeSavingsPlanRatesRequest
      .builder()
      .savingsPlanId(savingsPlanId: java.lang.String)
      .optionallyWith(
        filters.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.filters)
      .optionallyWith(nextToken.map(value => value: java.lang.String))(
        _.nextToken
      )
      .optionallyWith(maxResults.map(value => value: Integer))(_.maxResults)
      .build()
  }
  def asReadOnly
      : io.github.vigoo.zioaws.savingsplans.model.DescribeSavingsPlanRatesRequest.ReadOnly =
    io.github.vigoo.zioaws.savingsplans.model.DescribeSavingsPlanRatesRequest
      .wrap(buildAwsValue())
}
object DescribeSavingsPlanRatesRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.savingsplans.model.DescribeSavingsPlanRatesRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def editable
        : io.github.vigoo.zioaws.savingsplans.model.DescribeSavingsPlanRatesRequest =
      io.github.vigoo.zioaws.savingsplans.model.DescribeSavingsPlanRatesRequest(
        savingsPlanIdValue,
        filtersValue.map(value =>
          value.map { item =>
            item.editable
          }
        ),
        nextTokenValue.map(value => value),
        maxResultsValue.map(value => value)
      )
    def savingsPlanIdValue: SavingsPlanId
    def filtersValue: Option[List[
      io.github.vigoo.zioaws.savingsplans.model.SavingsPlanRateFilter.ReadOnly
    ]]
    def nextTokenValue: Option[PaginationToken]
    def maxResultsValue: Option[MaxResults]
    def savingsPlanId: ZIO[Any, Nothing, SavingsPlanId] =
      ZIO.succeed(savingsPlanIdValue)
    def filters: ZIO[Any, AwsError, List[
      io.github.vigoo.zioaws.savingsplans.model.SavingsPlanRateFilter.ReadOnly
    ]] = AwsError.unwrapOptionField("filters", filtersValue)
    def nextToken: ZIO[Any, AwsError, PaginationToken] =
      AwsError.unwrapOptionField("nextToken", nextTokenValue)
    def maxResults: ZIO[Any, AwsError, MaxResults] =
      AwsError.unwrapOptionField("maxResults", maxResultsValue)
  }
  private class Wrapper(
      impl: software.amazon.awssdk.services.savingsplans.model.DescribeSavingsPlanRatesRequest
  ) extends io.github.vigoo.zioaws.savingsplans.model.DescribeSavingsPlanRatesRequest.ReadOnly {
    override def savingsPlanIdValue: SavingsPlanId =
      impl.savingsPlanId(): SavingsPlanId
    override def filtersValue: Option[List[
      io.github.vigoo.zioaws.savingsplans.model.SavingsPlanRateFilter.ReadOnly
    ]] = scala
      .Option(impl.filters())
      .map(value =>
        value.asScala.map { item =>
          io.github.vigoo.zioaws.savingsplans.model.SavingsPlanRateFilter
            .wrap(item)
        }.toList
      )
    override def nextTokenValue: Option[PaginationToken] =
      scala.Option(impl.nextToken()).map(value => value: PaginationToken)
    override def maxResultsValue: Option[MaxResults] =
      scala.Option(impl.maxResults()).map(value => value: MaxResults)
  }
  def wrap(
      impl: software.amazon.awssdk.services.savingsplans.model.DescribeSavingsPlanRatesRequest
  ): io.github.vigoo.zioaws.savingsplans.model.DescribeSavingsPlanRatesRequest.ReadOnly =
    new Wrapper(impl)
}
