package io.github.vigoo.zioaws.savingsplans.model
import scala.jdk.CollectionConverters.*
sealed trait SavingsPlanState {
  def unwrap
      : software.amazon.awssdk.services.savingsplans.model.SavingsPlanState
}
object SavingsPlanState {
  def wrap(
      value: software.amazon.awssdk.services.savingsplans.model.SavingsPlanState
  ): io.github.vigoo.zioaws.savingsplans.model.SavingsPlanState = value match {
    case software.amazon.awssdk.services.savingsplans.model.SavingsPlanState.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.savingsplans.model.SavingsPlanState.PAYMENT_PENDING =>
      val r = `payment-pending`
      r
    case software.amazon.awssdk.services.savingsplans.model.SavingsPlanState.PAYMENT_FAILED =>
      val r = `payment-failed`
      r
    case software.amazon.awssdk.services.savingsplans.model.SavingsPlanState.ACTIVE =>
      val r = active
      r
    case software.amazon.awssdk.services.savingsplans.model.SavingsPlanState.RETIRED =>
      val r = retired
      r
    case software.amazon.awssdk.services.savingsplans.model.SavingsPlanState.QUEUED =>
      val r = queued
      r
    case software.amazon.awssdk.services.savingsplans.model.SavingsPlanState.QUEUED_DELETED =>
      val r = `queued-deleted`
      r
  }
  case object unknownToSdkVersion
      extends io.github.vigoo.zioaws.savingsplans.model.SavingsPlanState {
    override def unwrap
        : software.amazon.awssdk.services.savingsplans.model.SavingsPlanState =
      software.amazon.awssdk.services.savingsplans.model.SavingsPlanState.UNKNOWN_TO_SDK_VERSION
  }
  case object `payment-pending`
      extends io.github.vigoo.zioaws.savingsplans.model.SavingsPlanState {
    override def unwrap
        : software.amazon.awssdk.services.savingsplans.model.SavingsPlanState =
      software.amazon.awssdk.services.savingsplans.model.SavingsPlanState.PAYMENT_PENDING
  }
  case object `payment-failed`
      extends io.github.vigoo.zioaws.savingsplans.model.SavingsPlanState {
    override def unwrap
        : software.amazon.awssdk.services.savingsplans.model.SavingsPlanState =
      software.amazon.awssdk.services.savingsplans.model.SavingsPlanState.PAYMENT_FAILED
  }
  case object active
      extends io.github.vigoo.zioaws.savingsplans.model.SavingsPlanState {
    override def unwrap
        : software.amazon.awssdk.services.savingsplans.model.SavingsPlanState =
      software.amazon.awssdk.services.savingsplans.model.SavingsPlanState.ACTIVE
  }
  case object retired
      extends io.github.vigoo.zioaws.savingsplans.model.SavingsPlanState {
    override def unwrap
        : software.amazon.awssdk.services.savingsplans.model.SavingsPlanState =
      software.amazon.awssdk.services.savingsplans.model.SavingsPlanState.RETIRED
  }
  case object queued
      extends io.github.vigoo.zioaws.savingsplans.model.SavingsPlanState {
    override def unwrap
        : software.amazon.awssdk.services.savingsplans.model.SavingsPlanState =
      software.amazon.awssdk.services.savingsplans.model.SavingsPlanState.QUEUED
  }
  case object `queued-deleted`
      extends io.github.vigoo.zioaws.savingsplans.model.SavingsPlanState {
    override def unwrap
        : software.amazon.awssdk.services.savingsplans.model.SavingsPlanState =
      software.amazon.awssdk.services.savingsplans.model.SavingsPlanState.QUEUED_DELETED
  }
}
