package io.github.vigoo.zioaws.savingsplans.model
import io.github.vigoo.zioaws.savingsplans.model.primitives.JsonSafeFilterValueString
import zio.ZIO
import io.github.vigoo.zioaws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters.*
final case class SavingsPlanOfferingRateFilterElement(
    name: Option[
      io.github.vigoo.zioaws.savingsplans.model.SavingsPlanRateFilterAttribute
    ] = None,
    values: Option[Iterable[JsonSafeFilterValueString]] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.savingsplans.model.SavingsPlanOfferingRateFilterElement = {
    import SavingsPlanOfferingRateFilterElement.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.savingsplans.model.SavingsPlanOfferingRateFilterElement
      .builder()
      .optionallyWith(name.map(value => value.unwrap))(_.name)
      .optionallyWith(
        values.map(value =>
          value.map { item =>
            item: java.lang.String
          }.asJavaCollection
        )
      )(_.values)
      .build()
  }
  def asReadOnly
      : io.github.vigoo.zioaws.savingsplans.model.SavingsPlanOfferingRateFilterElement.ReadOnly =
    io.github.vigoo.zioaws.savingsplans.model.SavingsPlanOfferingRateFilterElement
      .wrap(buildAwsValue())
}
object SavingsPlanOfferingRateFilterElement {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.savingsplans.model.SavingsPlanOfferingRateFilterElement
  ] = BuilderHelper.apply
  trait ReadOnly {
    def editable
        : io.github.vigoo.zioaws.savingsplans.model.SavingsPlanOfferingRateFilterElement =
      io.github.vigoo.zioaws.savingsplans.model
        .SavingsPlanOfferingRateFilterElement(
          nameValue.map(value => value),
          valuesValue.map(value => value)
        )
    def nameValue: Option[
      io.github.vigoo.zioaws.savingsplans.model.SavingsPlanRateFilterAttribute
    ]
    def valuesValue: Option[List[JsonSafeFilterValueString]]
    def name: ZIO[
      Any,
      AwsError,
      io.github.vigoo.zioaws.savingsplans.model.SavingsPlanRateFilterAttribute
    ] = AwsError.unwrapOptionField("name", nameValue)
    def values: ZIO[Any, AwsError, List[JsonSafeFilterValueString]] =
      AwsError.unwrapOptionField("values", valuesValue)
  }
  private class Wrapper(
      impl: software.amazon.awssdk.services.savingsplans.model.SavingsPlanOfferingRateFilterElement
  ) extends io.github.vigoo.zioaws.savingsplans.model.SavingsPlanOfferingRateFilterElement.ReadOnly {
    override def nameValue: Option[
      io.github.vigoo.zioaws.savingsplans.model.SavingsPlanRateFilterAttribute
    ] = scala
      .Option(impl.name())
      .map(value =>
        io.github.vigoo.zioaws.savingsplans.model.SavingsPlanRateFilterAttribute
          .wrap(value)
      )
    override def valuesValue: Option[List[JsonSafeFilterValueString]] = scala
      .Option(impl.values())
      .map(value =>
        value.asScala.map { item =>
          item: JsonSafeFilterValueString
        }.toList
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.savingsplans.model.SavingsPlanOfferingRateFilterElement
  ): io.github.vigoo.zioaws.savingsplans.model.SavingsPlanOfferingRateFilterElement.ReadOnly =
    new Wrapper(impl)
}
