package io.github.vigoo.zioaws.savingsplans
import io.github.vigoo.zioaws.savingsplans.model.primitives.{
  JsonSafeFilterValueString,
  SavingsPlanArn,
  SavingsPlansDuration,
  SavingsPlanRateOperation,
  SavingsPlanRateUsageType,
  SavingsPlanUsageType,
  TagValue,
  UUID,
  SavingsPlanOperation,
  SavingsPlanServiceCode,
  SavingsPlanDescription,
  SavingsPlanId,
  TagKey
}
import java.time.Instant
package object model {
  import scala.jdk.CollectionConverters.*
  object primitives {
    type Amount = String
    type ClientToken = String
    type DateTime = Instant
    type EC2InstanceFamily = String
    type JsonSafeFilterValueString = String
    type MaxResults = Int
    type PageSize = Int
    type PaginationToken = String
    type Region = String
    type SavingsPlanArn = String
    type SavingsPlanDescription = String
    type SavingsPlanId = String
    type SavingsPlanOfferingId = String
    type SavingsPlanOperation = String
    type SavingsPlanRateOperation = String
    type SavingsPlanRatePricePerUnit = String
    type SavingsPlanRateUsageType = String
    type SavingsPlanServiceCode = String
    type SavingsPlanUsageType = String
    type SavingsPlansDuration = Long
    type TagKey = String
    type TagValue = String
    type TermDurationInSeconds = Long
    type UUID = String
  }
  type CurrencyList =
    List[io.github.vigoo.zioaws.savingsplans.model.CurrencyCode]
  type DurationsList = List[SavingsPlansDuration]
  type FilterValuesList = List[JsonSafeFilterValueString]
  type ListOfStrings = List[String]
  type SavingsPlanArnList = List[SavingsPlanArn]
  type SavingsPlanDescriptionsList = List[SavingsPlanDescription]
  type SavingsPlanFilterList =
    List[io.github.vigoo.zioaws.savingsplans.model.SavingsPlanFilter]
  type SavingsPlanIdList = List[SavingsPlanId]
  type SavingsPlanList =
    List[io.github.vigoo.zioaws.savingsplans.model.SavingsPlan]
  type SavingsPlanOfferingFiltersList = List[
    io.github.vigoo.zioaws.savingsplans.model.SavingsPlanOfferingFilterElement
  ]
  type SavingsPlanOfferingPropertyList =
    List[io.github.vigoo.zioaws.savingsplans.model.SavingsPlanOfferingProperty]
  type SavingsPlanOfferingRateFiltersList = List[
    io.github.vigoo.zioaws.savingsplans.model.SavingsPlanOfferingRateFilterElement
  ]
  type SavingsPlanOfferingRatePropertyList = List[
    io.github.vigoo.zioaws.savingsplans.model.SavingsPlanOfferingRateProperty
  ]
  type SavingsPlanOfferingRatesList =
    List[io.github.vigoo.zioaws.savingsplans.model.SavingsPlanOfferingRate]
  type SavingsPlanOfferingsList =
    List[io.github.vigoo.zioaws.savingsplans.model.SavingsPlanOffering]
  type SavingsPlanOperationList = List[SavingsPlanOperation]
  type SavingsPlanPaymentOptionList =
    List[io.github.vigoo.zioaws.savingsplans.model.SavingsPlanPaymentOption]
  type SavingsPlanProductTypeList =
    List[io.github.vigoo.zioaws.savingsplans.model.SavingsPlanProductType]
  type SavingsPlanRateFilterList =
    List[io.github.vigoo.zioaws.savingsplans.model.SavingsPlanRateFilter]
  type SavingsPlanRateList =
    List[io.github.vigoo.zioaws.savingsplans.model.SavingsPlanRate]
  type SavingsPlanRateOperationList = List[SavingsPlanRateOperation]
  type SavingsPlanRatePropertyList =
    List[io.github.vigoo.zioaws.savingsplans.model.SavingsPlanRateProperty]
  type SavingsPlanRateServiceCodeList =
    List[io.github.vigoo.zioaws.savingsplans.model.SavingsPlanRateServiceCode]
  type SavingsPlanRateUsageTypeList = List[SavingsPlanRateUsageType]
  type SavingsPlanServiceCodeList = List[SavingsPlanServiceCode]
  type SavingsPlanStateList =
    List[io.github.vigoo.zioaws.savingsplans.model.SavingsPlanState]
  type SavingsPlanTypeList =
    List[io.github.vigoo.zioaws.savingsplans.model.SavingsPlanType]
  type SavingsPlanUsageTypeList = List[SavingsPlanUsageType]
  type TagKeyList = List[TagKey]
  type TagMap = Map[TagKey, TagValue]
  type UUIDs = List[UUID]
}
