package io.github.vigoo.zioaws.savingsplans.model
import io.github.vigoo.zioaws.savingsplans.model.primitives.{
  TagKey,
  SavingsPlanArn
}
import zio.ZIO
import io.github.vigoo.zioaws.core.BuilderHelper
import scala.jdk.CollectionConverters.*
final case class UntagResourceRequest(
    resourceArn: SavingsPlanArn,
    tagKeys: Iterable[TagKey]
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.savingsplans.model.UntagResourceRequest = {
    import UntagResourceRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.savingsplans.model.UntagResourceRequest
      .builder()
      .resourceArn(resourceArn: java.lang.String)
      .tagKeys(tagKeys.map { item =>
        item: java.lang.String
      }.asJavaCollection)
      .build()
  }
  def asReadOnly
      : io.github.vigoo.zioaws.savingsplans.model.UntagResourceRequest.ReadOnly =
    io.github.vigoo.zioaws.savingsplans.model.UntagResourceRequest
      .wrap(buildAwsValue())
}
object UntagResourceRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.savingsplans.model.UntagResourceRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def editable
        : io.github.vigoo.zioaws.savingsplans.model.UntagResourceRequest =
      io.github.vigoo.zioaws.savingsplans.model
        .UntagResourceRequest(resourceArnValue, tagKeysValue)
    def resourceArnValue: SavingsPlanArn
    def tagKeysValue: List[TagKey]
    def resourceArn: ZIO[Any, Nothing, SavingsPlanArn] =
      ZIO.succeed(resourceArnValue)
    def tagKeys: ZIO[Any, Nothing, List[TagKey]] = ZIO.succeed(tagKeysValue)
  }
  private class Wrapper(
      impl: software.amazon.awssdk.services.savingsplans.model.UntagResourceRequest
  ) extends io.github.vigoo.zioaws.savingsplans.model.UntagResourceRequest.ReadOnly {
    override def resourceArnValue: SavingsPlanArn =
      impl.resourceArn(): SavingsPlanArn
    override def tagKeysValue: List[TagKey] = impl
      .tagKeys()
      .asScala
      .map { item =>
        item: TagKey
      }
      .toList
  }
  def wrap(
      impl: software.amazon.awssdk.services.savingsplans.model.UntagResourceRequest
  ): io.github.vigoo.zioaws.savingsplans.model.UntagResourceRequest.ReadOnly =
    new Wrapper(impl)
}
