package io.github.vigoo.zioaws.savingsplans.model
import io.github.vigoo.zioaws.savingsplans.model.primitives.JsonSafeFilterValueString
import zio.ZIO
import io.github.vigoo.zioaws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters.*
final case class SavingsPlanOfferingRateProperty(
    name: Option[JsonSafeFilterValueString] = None,
    value: Option[JsonSafeFilterValueString] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.savingsplans.model.SavingsPlanOfferingRateProperty = {
    import SavingsPlanOfferingRateProperty.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.savingsplans.model.SavingsPlanOfferingRateProperty
      .builder()
      .optionallyWith(name.map(value => value: java.lang.String))(_.name)
      .optionallyWith(value.map(value => value: java.lang.String))(_.value)
      .build()
  }
  def asReadOnly
      : io.github.vigoo.zioaws.savingsplans.model.SavingsPlanOfferingRateProperty.ReadOnly =
    io.github.vigoo.zioaws.savingsplans.model.SavingsPlanOfferingRateProperty
      .wrap(buildAwsValue())
}
object SavingsPlanOfferingRateProperty {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.savingsplans.model.SavingsPlanOfferingRateProperty
  ] = BuilderHelper.apply
  trait ReadOnly {
    def editable
        : io.github.vigoo.zioaws.savingsplans.model.SavingsPlanOfferingRateProperty =
      io.github.vigoo.zioaws.savingsplans.model.SavingsPlanOfferingRateProperty(
        nameValue.map(value => value),
        valueValue.map(value => value)
      )
    def nameValue: Option[JsonSafeFilterValueString]
    def valueValue: Option[JsonSafeFilterValueString]
    def name: ZIO[Any, AwsError, JsonSafeFilterValueString] =
      AwsError.unwrapOptionField("name", nameValue)
    def value: ZIO[Any, AwsError, JsonSafeFilterValueString] =
      AwsError.unwrapOptionField("value", valueValue)
  }
  private class Wrapper(
      impl: software.amazon.awssdk.services.savingsplans.model.SavingsPlanOfferingRateProperty
  ) extends io.github.vigoo.zioaws.savingsplans.model.SavingsPlanOfferingRateProperty.ReadOnly {
    override def nameValue: Option[JsonSafeFilterValueString] =
      scala.Option(impl.name()).map(value => value: JsonSafeFilterValueString)
    override def valueValue: Option[JsonSafeFilterValueString] =
      scala.Option(impl.value()).map(value => value: JsonSafeFilterValueString)
  }
  def wrap(
      impl: software.amazon.awssdk.services.savingsplans.model.SavingsPlanOfferingRateProperty
  ): io.github.vigoo.zioaws.savingsplans.model.SavingsPlanOfferingRateProperty.ReadOnly =
    new Wrapper(impl)
}
