package io.github.vigoo.zioaws.savingsplans.model
import io.github.vigoo.zioaws.savingsplans.model.primitives.{
  SavingsPlanRateOperation,
  SavingsPlanRateUsageType,
  SavingsPlanRatePricePerUnit
}
import zio.ZIO
import io.github.vigoo.zioaws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters.*
final case class SavingsPlanOfferingRate(
    savingsPlanOffering: Option[
      io.github.vigoo.zioaws.savingsplans.model.ParentSavingsPlanOffering
    ] = None,
    rate: Option[SavingsPlanRatePricePerUnit] = None,
    unit: Option[
      io.github.vigoo.zioaws.savingsplans.model.SavingsPlanRateUnit
    ] = None,
    productType: Option[
      io.github.vigoo.zioaws.savingsplans.model.SavingsPlanProductType
    ] = None,
    serviceCode: Option[
      io.github.vigoo.zioaws.savingsplans.model.SavingsPlanRateServiceCode
    ] = None,
    usageType: Option[SavingsPlanRateUsageType] = None,
    operation: Option[SavingsPlanRateOperation] = None,
    properties: Option[Iterable[
      io.github.vigoo.zioaws.savingsplans.model.SavingsPlanOfferingRateProperty
    ]] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.savingsplans.model.SavingsPlanOfferingRate = {
    import SavingsPlanOfferingRate.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.savingsplans.model.SavingsPlanOfferingRate
      .builder()
      .optionallyWith(savingsPlanOffering.map(value => value.buildAwsValue()))(
        _.savingsPlanOffering
      )
      .optionallyWith(rate.map(value => value: java.lang.String))(_.rate)
      .optionallyWith(unit.map(value => value.unwrap))(_.unit)
      .optionallyWith(productType.map(value => value.unwrap))(_.productType)
      .optionallyWith(serviceCode.map(value => value.unwrap))(_.serviceCode)
      .optionallyWith(usageType.map(value => value: java.lang.String))(
        _.usageType
      )
      .optionallyWith(operation.map(value => value: java.lang.String))(
        _.operation
      )
      .optionallyWith(
        properties.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.properties)
      .build()
  }
  def asReadOnly
      : io.github.vigoo.zioaws.savingsplans.model.SavingsPlanOfferingRate.ReadOnly =
    io.github.vigoo.zioaws.savingsplans.model.SavingsPlanOfferingRate
      .wrap(buildAwsValue())
}
object SavingsPlanOfferingRate {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.savingsplans.model.SavingsPlanOfferingRate
  ] = BuilderHelper.apply
  trait ReadOnly {
    def editable
        : io.github.vigoo.zioaws.savingsplans.model.SavingsPlanOfferingRate =
      io.github.vigoo.zioaws.savingsplans.model.SavingsPlanOfferingRate(
        savingsPlanOfferingValue.map(value => value.editable),
        rateValue.map(value => value),
        unitValue.map(value => value),
        productTypeValue.map(value => value),
        serviceCodeValue.map(value => value),
        usageTypeValue.map(value => value),
        operationValue.map(value => value),
        propertiesValue.map(value =>
          value.map { item =>
            item.editable
          }
        )
      )
    def savingsPlanOfferingValue: Option[
      io.github.vigoo.zioaws.savingsplans.model.ParentSavingsPlanOffering.ReadOnly
    ]
    def rateValue: Option[SavingsPlanRatePricePerUnit]
    def unitValue
        : Option[io.github.vigoo.zioaws.savingsplans.model.SavingsPlanRateUnit]
    def productTypeValue: Option[
      io.github.vigoo.zioaws.savingsplans.model.SavingsPlanProductType
    ]
    def serviceCodeValue: Option[
      io.github.vigoo.zioaws.savingsplans.model.SavingsPlanRateServiceCode
    ]
    def usageTypeValue: Option[SavingsPlanRateUsageType]
    def operationValue: Option[SavingsPlanRateOperation]
    def propertiesValue: Option[List[
      io.github.vigoo.zioaws.savingsplans.model.SavingsPlanOfferingRateProperty.ReadOnly
    ]]
    def savingsPlanOffering: ZIO[
      Any,
      AwsError,
      io.github.vigoo.zioaws.savingsplans.model.ParentSavingsPlanOffering.ReadOnly
    ] = AwsError.unwrapOptionField(
      "savingsPlanOffering",
      savingsPlanOfferingValue
    )
    def rate: ZIO[Any, AwsError, SavingsPlanRatePricePerUnit] =
      AwsError.unwrapOptionField("rate", rateValue)
    def unit: ZIO[
      Any,
      AwsError,
      io.github.vigoo.zioaws.savingsplans.model.SavingsPlanRateUnit
    ] = AwsError.unwrapOptionField("unit", unitValue)
    def productType: ZIO[
      Any,
      AwsError,
      io.github.vigoo.zioaws.savingsplans.model.SavingsPlanProductType
    ] = AwsError.unwrapOptionField("productType", productTypeValue)
    def serviceCode: ZIO[
      Any,
      AwsError,
      io.github.vigoo.zioaws.savingsplans.model.SavingsPlanRateServiceCode
    ] = AwsError.unwrapOptionField("serviceCode", serviceCodeValue)
    def usageType: ZIO[Any, AwsError, SavingsPlanRateUsageType] =
      AwsError.unwrapOptionField("usageType", usageTypeValue)
    def operation: ZIO[Any, AwsError, SavingsPlanRateOperation] =
      AwsError.unwrapOptionField("operation", operationValue)
    def properties: ZIO[Any, AwsError, List[
      io.github.vigoo.zioaws.savingsplans.model.SavingsPlanOfferingRateProperty.ReadOnly
    ]] = AwsError.unwrapOptionField("properties", propertiesValue)
  }
  private class Wrapper(
      impl: software.amazon.awssdk.services.savingsplans.model.SavingsPlanOfferingRate
  ) extends io.github.vigoo.zioaws.savingsplans.model.SavingsPlanOfferingRate.ReadOnly {
    override def savingsPlanOfferingValue: Option[
      io.github.vigoo.zioaws.savingsplans.model.ParentSavingsPlanOffering.ReadOnly
    ] = scala
      .Option(impl.savingsPlanOffering())
      .map(value =>
        io.github.vigoo.zioaws.savingsplans.model.ParentSavingsPlanOffering
          .wrap(value)
      )
    override def rateValue: Option[SavingsPlanRatePricePerUnit] =
      scala.Option(impl.rate()).map(value => value: SavingsPlanRatePricePerUnit)
    override def unitValue: Option[
      io.github.vigoo.zioaws.savingsplans.model.SavingsPlanRateUnit
    ] = scala
      .Option(impl.unit())
      .map(value =>
        io.github.vigoo.zioaws.savingsplans.model.SavingsPlanRateUnit
          .wrap(value)
      )
    override def productTypeValue: Option[
      io.github.vigoo.zioaws.savingsplans.model.SavingsPlanProductType
    ] = scala
      .Option(impl.productType())
      .map(value =>
        io.github.vigoo.zioaws.savingsplans.model.SavingsPlanProductType
          .wrap(value)
      )
    override def serviceCodeValue: Option[
      io.github.vigoo.zioaws.savingsplans.model.SavingsPlanRateServiceCode
    ] = scala
      .Option(impl.serviceCode())
      .map(value =>
        io.github.vigoo.zioaws.savingsplans.model.SavingsPlanRateServiceCode
          .wrap(value)
      )
    override def usageTypeValue: Option[SavingsPlanRateUsageType] = scala
      .Option(impl.usageType())
      .map(value => value: SavingsPlanRateUsageType)
    override def operationValue: Option[SavingsPlanRateOperation] = scala
      .Option(impl.operation())
      .map(value => value: SavingsPlanRateOperation)
    override def propertiesValue: Option[List[
      io.github.vigoo.zioaws.savingsplans.model.SavingsPlanOfferingRateProperty.ReadOnly
    ]] = scala
      .Option(impl.properties())
      .map(value =>
        value.asScala.map { item =>
          io.github.vigoo.zioaws.savingsplans.model.SavingsPlanOfferingRateProperty
            .wrap(item)
        }.toList
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.savingsplans.model.SavingsPlanOfferingRate
  ): io.github.vigoo.zioaws.savingsplans.model.SavingsPlanOfferingRate.ReadOnly =
    new Wrapper(impl)
}
